/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.fielddata.LeafFieldData;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;

final class BytesBinaryDVLeafFieldData
implements LeafFieldData {
    private final BinaryDocValues values;

    BytesBinaryDVLeafFieldData(BinaryDocValues values) {
        this.values = values;
    }

    public long ramBytesUsed() {
        return 0L;
    }

    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    @Override
    public SortedBinaryDocValues getBytesValues() {
        return new SortedBinaryDocValues(){
            int count;
            final ByteArrayDataInput in = new ByteArrayDataInput();
            final BytesRef scratch = new BytesRef();

            @Override
            public boolean advanceExact(int doc) throws IOException {
                if (BytesBinaryDVLeafFieldData.this.values.advanceExact(doc)) {
                    BytesRef bytes = BytesBinaryDVLeafFieldData.this.values.binaryValue();
                    assert (bytes.length > 0);
                    this.in.reset(bytes.bytes, bytes.offset, bytes.length);
                    this.count = this.in.readVInt();
                    this.scratch.bytes = bytes.bytes;
                    return true;
                }
                return false;
            }

            @Override
            public int docValueCount() {
                return this.count;
            }

            @Override
            public BytesRef nextValue() throws IOException {
                this.scratch.length = this.in.readVInt();
                this.scratch.offset = this.in.getPosition();
                this.in.setPosition(this.scratch.offset + this.scratch.length);
                return this.scratch;
            }
        };
    }

    public ScriptDocValues<BytesRef> getScriptValues() {
        return new ScriptDocValues.BytesRefs(this.getBytesValues());
    }

    @Override
    public void close() {
    }
}

