/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.elasticsearch.common.collect.CopyOnWriteHashMap;
import org.elasticsearch.index.mapper.DynamicKeyFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;

class DynamicKeyFieldTypeLookup {
    private final CopyOnWriteHashMap<String, DynamicKeyFieldMapper> mappers;
    private final Map<String, String> aliasToConcreteName;
    private final int maxKeyDepth;

    DynamicKeyFieldTypeLookup() {
        this.mappers = new CopyOnWriteHashMap();
        this.aliasToConcreteName = Collections.emptyMap();
        this.maxKeyDepth = 0;
    }

    private DynamicKeyFieldTypeLookup(CopyOnWriteHashMap<String, DynamicKeyFieldMapper> mappers, Map<String, String> aliasToConcreteName, int maxKeyDepth) {
        this.mappers = mappers;
        this.aliasToConcreteName = aliasToConcreteName;
        this.maxKeyDepth = maxKeyDepth;
    }

    DynamicKeyFieldTypeLookup copyAndAddAll(Map<String, DynamicKeyFieldMapper> newMappers, Map<String, String> aliasToConcreteName) {
        CopyOnWriteHashMap<String, DynamicKeyFieldMapper> combinedMappers = this.mappers.copyAndPutAll(newMappers);
        int maxKeyDepth = DynamicKeyFieldTypeLookup.getMaxKeyDepth(combinedMappers, aliasToConcreteName);
        return new DynamicKeyFieldTypeLookup(combinedMappers, aliasToConcreteName, maxKeyDepth);
    }

    MappedFieldType get(String field) {
        String parentField;
        String concreteField;
        DynamicKeyFieldMapper mapper;
        if (this.mappers.isEmpty()) {
            return null;
        }
        int dotIndex = -1;
        int fieldDepth = 0;
        do {
            if (++fieldDepth > this.maxKeyDepth) {
                return null;
            }
            if ((dotIndex = field.indexOf(46, dotIndex + 1)) >= 0) continue;
            return null;
        } while ((mapper = this.mappers.get(concreteField = this.aliasToConcreteName.getOrDefault(parentField = field.substring(0, dotIndex), parentField))) == null);
        String key = field.substring(dotIndex + 1);
        return mapper.keyedFieldType(key);
    }

    Iterator<MappedFieldType> fieldTypes() {
        return this.mappers.values().stream().map(mapper -> mapper.keyedFieldType("")).iterator();
    }

    static int getMaxKeyDepth(Map<String, DynamicKeyFieldMapper> dynamicKeyMappers, Map<String, String> aliasToConcreteName) {
        int maxFieldDepth = 0;
        for (Map.Entry<String, String> entry : aliasToConcreteName.entrySet()) {
            String aliasName = entry.getKey();
            String path = entry.getValue();
            if (!dynamicKeyMappers.containsKey(path)) continue;
            maxFieldDepth = Math.max(maxFieldDepth, DynamicKeyFieldTypeLookup.fieldDepth(aliasName));
        }
        for (String fieldName : dynamicKeyMappers.keySet()) {
            if (!dynamicKeyMappers.containsKey(fieldName)) continue;
            maxFieldDepth = Math.max(maxFieldDepth, DynamicKeyFieldTypeLookup.fieldDepth(fieldName));
        }
        return maxFieldDepth;
    }

    private static int fieldDepth(String field) {
        int numDots = 0;
        int dotIndex = -1;
        while ((dotIndex = field.indexOf(46, dotIndex + 1)) >= 0) {
            ++numDots;
        }
        return numDots + 1;
    }
}

