/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.internal.SearchContext;

public abstract class ValuesSourceAggregatorFactory<VS extends ValuesSource>
extends AggregatorFactory {
    protected ValuesSourceConfig<VS> config;

    public ValuesSourceAggregatorFactory(String name, ValuesSourceConfig<VS> config, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metaData) throws IOException {
        super(name, queryShardContext, parent, subFactoriesBuilder, metaData);
        this.config = config;
    }

    @Override
    public Aggregator createInternal(SearchContext searchContext, Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        VS vs = this.config.toValuesSource(this.queryShardContext, this::resolveMissingAny);
        if (vs == null) {
            return this.createUnmapped(searchContext, parent, pipelineAggregators, metaData);
        }
        return this.doCreateInternal(vs, searchContext, parent, collectsFromSingleBucket, pipelineAggregators, metaData);
    }

    protected ValuesSource resolveMissingAny(Object missing) {
        return ValuesSource.Bytes.WithOrdinals.EMPTY;
    }

    protected abstract Aggregator createUnmapped(SearchContext var1, Aggregator var2, List<PipelineAggregator> var3, Map<String, Object> var4) throws IOException;

    protected abstract Aggregator doCreateInternal(VS var1, SearchContext var2, Aggregator var3, boolean var4, List<PipelineAggregator> var5, Map<String, Object> var6) throws IOException;
}

