/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.function.Consumer;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.reindex.AbstractBaseReindexRestHandler;
import org.elasticsearch.index.reindex.AbstractBulkByScrollRequest;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.search.RestSearchAction;

public abstract class AbstractBulkByQueryRestHandler<Request extends AbstractBulkByScrollRequest<Request>, A extends ActionType<BulkByScrollResponse>>
extends AbstractBaseReindexRestHandler<Request, A> {
    protected AbstractBulkByQueryRestHandler(A action) {
        super(action);
    }

    protected void parseInternalRequest(Request internal, RestRequest restRequest, Map<String, Consumer<Object>> bodyConsumers) throws IOException {
        assert (internal != null) : "Request should not be null";
        assert (restRequest != null) : "RestRequest should not be null";
        SearchRequest searchRequest = internal.getSearchRequest();
        try (XContentParser parser = this.extractRequestSpecificFields(restRequest, bodyConsumers);){
            RestSearchAction.parseSearchRequest((SearchRequest)searchRequest, (RestRequest)restRequest, (XContentParser)parser, size -> this.setMaxDocsFromSearchSize(internal, size));
        }
        searchRequest.source().size(restRequest.paramAsInt("scroll_size", searchRequest.source().size()));
        String conflicts = restRequest.param("conflicts");
        if (conflicts != null) {
            internal.setConflicts(conflicts);
        }
        if (restRequest.hasParam("search_timeout")) {
            searchRequest.source().timeout(restRequest.paramAsTime("search_timeout", null));
        }
    }

    private XContentParser extractRequestSpecificFields(RestRequest restRequest, Map<String, Consumer<Object>> bodyConsumers) throws IOException {
        if (!restRequest.hasContentOrSourceParam()) {
            return null;
        }
        try (XContentParser parser = restRequest.contentOrSourceParamParser();){
            XContentParser xContentParser;
            block14: {
                XContentBuilder builder = XContentFactory.contentBuilder((XContentType)parser.contentType());
                try {
                    Map body = parser.map();
                    for (Map.Entry<String, Consumer<Object>> consumer : bodyConsumers.entrySet()) {
                        Object value = body.remove(consumer.getKey());
                        if (value == null) continue;
                        consumer.getValue().accept(value);
                    }
                    xContentParser = parser.contentType().xContent().createParser(parser.getXContentRegistry(), parser.getDeprecationHandler(), (InputStream)BytesReference.bytes((XContentBuilder)builder.map(body)).streamInput());
                    if (builder == null) break block14;
                }
                catch (Throwable throwable) {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                builder.close();
            }
            return xContentParser;
        }
    }

    private void setMaxDocsFromSearchSize(Request request, int size) {
        LoggingDeprecationHandler.INSTANCE.usedDeprecatedName(null, null, "size", "max_docs");
        AbstractBulkByQueryRestHandler.setMaxDocsValidateIdentical(request, size);
    }
}

