/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.fonts;

import java.awt.Rectangle;
import org.apache.fop.afp.AFPEventProducer;
import org.apache.fop.afp.fonts.CharacterSet;
import org.apache.fop.afp.fonts.CharacterSetType;
import org.apache.fop.afp.util.AFPResourceAccessor;
import org.apache.fop.fonts.Typeface;

public class FopCharacterSet
extends CharacterSet {
    private Typeface charSet;

    public FopCharacterSet(String codePage, String encoding, String name, Typeface charSet, AFPEventProducer eventProducer) {
        super(codePage, encoding, CharacterSetType.SINGLE_BYTE, name, null, eventProducer);
        this.charSet = charSet;
    }

    public FopCharacterSet(String codePage, String encoding, String name, Typeface charSet, AFPResourceAccessor accessor, AFPEventProducer eventProducer) {
        super(codePage, encoding, CharacterSetType.SINGLE_BYTE, name, accessor, eventProducer);
        this.charSet = charSet;
    }

    @Override
    public int getAscender() {
        return this.charSet.getAscender(1);
    }

    @Override
    public int getCapHeight() {
        return this.charSet.getCapHeight(1);
    }

    @Override
    public int getDescender() {
        return this.charSet.getDescender(1);
    }

    @Override
    public int getXHeight() {
        return this.charSet.getXHeight(1);
    }

    @Override
    public int getWidth(char character, int size) {
        return this.charSet.getWidth(character, size);
    }

    @Override
    public Rectangle getCharacterBox(char character, int size) {
        return this.charSet.getBoundingBox(character, size);
    }

    @Override
    public int getUnderscoreWidth() {
        return this.charSet.getUnderlineThickness(1);
    }

    @Override
    public int getUnderscorePosition() {
        return this.charSet.getUnderlinePosition(1);
    }

    @Override
    public char mapChar(char c) {
        return this.charSet.mapChar(c);
    }
}

