/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.Component;
import java.awt.Container;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.InGameController;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.SwingGUI;
import net.sf.freecol.client.gui.action.UnloadAction;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.debug.DebugUtils;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.util.LogBuilder;

public final class TilePopup
extends JPopupMenu {
    private static final Logger logger = Logger.getLogger(TilePopup.class.getName());
    public static final int UNIT_LINES_IN_FIRST_MENU = 9;
    public static final int UNIT_LINES_IN_OTHER_MENUS = 19;
    private final FreeColClient freeColClient;
    private final SwingGUI gui;
    private final Canvas canvas;
    private boolean hasAnItem = false;

    public TilePopup(FreeColClient freeColClient, Canvas canvas, Tile tile) {
        super(Messages.message(tile.getSimpleLabel()));
        Component lastComponent;
        Settlement settlement;
        Tile unitTile;
        boolean owned;
        this.freeColClient = freeColClient;
        this.gui = (SwingGUI)freeColClient.getGUI();
        this.canvas = canvas;
        Player player = freeColClient.getMyPlayer();
        Unit activeUnit = this.gui.getActiveUnit();
        boolean bl = owned = player != null && activeUnit != null && player.owns(activeUnit);
        if (activeUnit != null && owned && (unitTile = activeUnit.getTile()) != null) {
            JMenuItem gotoMenuItem = null;
            if (activeUnit.isOffensiveUnit() && unitTile.isAdjacent(tile) && activeUnit.getMoveType(tile).isAttack()) {
                gotoMenuItem = Utility.localizedMenuItem(activeUnit.getCombatLabel(tile));
            } else if (activeUnit.getSimpleMoveType(unitTile, tile).isLegal()) {
                gotoMenuItem = Utility.localizedMenuItem("goToThisTile");
            }
            if (gotoMenuItem != null) {
                gotoMenuItem.addActionListener(ae -> {
                    if (!freeColClient.currentPlayerIsMyPlayer()) {
                        return;
                    }
                    Tile currTile = activeUnit.getTile();
                    if (currTile == tile) {
                        return;
                    }
                    freeColClient.getInGameController().goToTile(activeUnit, tile);
                    if (activeUnit.getTile() == currTile) {
                        canvas.updateCurrentPathForActiveUnit();
                    }
                });
                this.add(gotoMenuItem);
            }
            InGameController igc = freeColClient.getInGameController();
            if (unitTile == tile && activeUnit.hasHighSeasMove()) {
                JMenuItem europeMenuItem = Utility.localizedMenuItem(StringTemplate.template("goToEurope"));
                europeMenuItem.addActionListener(ae -> {
                    if (!freeColClient.currentPlayerIsMyPlayer()) {
                        return;
                    }
                    igc.moveTo(activeUnit, player.getEurope());
                });
                this.add(europeMenuItem);
                this.hasAnItem = true;
            }
            if (unitTile == tile) {
                JMenuItem ji = null;
                if (activeUnit.checkSetState(Unit.UnitState.ACTIVE)) {
                    ji = Utility.localizedMenuItem("activateUnit");
                    ji.addActionListener(ae -> igc.changeState(activeUnit, Unit.UnitState.ACTIVE));
                    this.add(ji);
                    this.hasAnItem = true;
                }
                if (activeUnit.checkSetState(Unit.UnitState.FORTIFYING)) {
                    ji = Utility.localizedMenuItem("fortify");
                    ji.addActionListener(ae -> igc.changeState(activeUnit, Unit.UnitState.FORTIFYING));
                    this.add(ji);
                    this.hasAnItem = true;
                }
                if (activeUnit.checkSetState(Unit.UnitState.SKIPPED)) {
                    ji = Utility.localizedMenuItem("skip");
                    ji.addActionListener(ae -> igc.changeState(activeUnit, Unit.UnitState.SKIPPED));
                    this.add(ji);
                    this.hasAnItem = true;
                }
                if (activeUnit.canCarryTreasure() && activeUnit.canCashInTreasureTrain()) {
                    ji = Utility.localizedMenuItem("cashInTreasureTrain");
                    ji.addActionListener(ae -> igc.checkCashInTreasureTrain(activeUnit));
                    ji.setEnabled(true);
                    this.add(ji);
                    this.hasAnItem = true;
                }
                if (activeUnit.getDestination() != null) {
                    ji = Utility.localizedMenuItem("clearOrders");
                    ji.addActionListener(ae -> igc.clearOrders(activeUnit));
                    this.add(ji);
                    this.hasAnItem = true;
                }
            }
            if (this.hasAnItem) {
                this.addSeparator();
            }
        }
        if ((settlement = tile.getSettlement()) != null) {
            if (settlement.getOwner() == player) {
                this.addColony((Colony)settlement);
            } else if (settlement instanceof IndianSettlement) {
                this.addIndianSettlement((IndianSettlement)settlement);
            }
            if (this.hasAnItem) {
                this.addSeparator();
            }
        }
        if (tile.isExplored()) {
            this.addTile(tile);
        }
        this.addSeparator();
        int lineCount = 0;
        int maxUnits = 9;
        JComponent currentMenu = this;
        boolean moreUnits = false;
        Unit firstUnit = tile.getFirstUnit();
        for (Unit u : tile.getUnitList().stream().sorted(Unit.typeRoleComparator).collect(Collectors.toList())) {
            if (lineCount > maxUnits) {
                JMenu more = Utility.localizedMenu("more");
                more.setFont(more.getFont().deriveFont(2));
                more.setOpaque(false);
                currentMenu.add(more);
                currentMenu = more;
                moreUnits = true;
                lineCount = 0;
                maxUnits = 19;
            }
            lineCount += this.addUnit(currentMenu, u, !u.isDamaged(), false);
        }
        if (tile.getUnitCount() > 1 && player.owns(firstUnit)) {
            if (moreUnits) {
                this.addSeparator();
            }
            JMenuItem activateAllItem = Utility.localizedMenuItem(StringTemplate.template("activateAllUnits"));
            activateAllItem.addActionListener(ae -> {
                Unit lastUnit = null;
                for (Unit unit : tile.getUnitList()) {
                    freeColClient.getInGameController().clearOrders(unit);
                    lastUnit = unit;
                }
                this.gui.setActiveUnit(lastUnit);
            });
            this.add(activateAllItem);
        }
        if (FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.MENUS) && freeColClient.getFreeColServer() != null) {
            this.addDebugItems(freeColClient, tile);
        }
        if ((lastComponent = this.getComponent(this.getComponentCount() - 1)) instanceof JSeparator) {
            this.remove(lastComponent);
        }
    }

    public void addDebugItems(FreeColClient freeColClient, Tile tile) {
        Unit activeUnit;
        this.addSeparator();
        JMenu changeOwnership = new JMenu("Change ownership");
        changeOwnership.setOpaque(false);
        JMenu transportLists = new JMenu("Transport lists");
        transportLists.setOpaque(false);
        JMenu changeRole = new JMenu("Change role");
        changeRole.setOpaque(false);
        for (Unit unit : tile.getUnitList()) {
            JMenuItem toMenuItem = new JMenuItem(unit.toString());
            toMenuItem.addActionListener(ae -> DebugUtils.changeOwnership(freeColClient, unit));
            changeOwnership.add(toMenuItem);
            if (unit.isCarrier()) {
                JMenuItem menuItem = new JMenuItem(unit.toString());
                menuItem.addActionListener(ae -> DebugUtils.displayMission(freeColClient, unit));
                transportLists.add(menuItem);
            }
            if (!unit.isPerson()) continue;
            JMenuItem roleMenuItem = new JMenuItem(unit.toString());
            roleMenuItem.addActionListener(ae -> DebugUtils.changeRole(freeColClient, unit));
            changeRole.add(roleMenuItem);
        }
        if (transportLists.getItemCount() > 0) {
            this.add(transportLists);
        }
        if (tile.getColony() != null) {
            if (changeOwnership.getItemCount() > 0) {
                changeOwnership.addSeparator();
            }
            JMenuItem toMenuItem = new JMenuItem(tile.getColony().toString());
            Colony colony = tile.getColony();
            toMenuItem.addActionListener(ae -> DebugUtils.changeOwnership(freeColClient, colony));
            changeOwnership.add(toMenuItem);
            JMenuItem displayColonyPlan = new JMenuItem("Display Colony Plan");
            displayColonyPlan.addActionListener(ae -> DebugUtils.displayColonyPlan(freeColClient, colony));
            this.add(displayColonyPlan);
            JMenuItem applyDisaster = new JMenuItem("Apply Disaster");
            applyDisaster.addActionListener(ae -> DebugUtils.applyDisaster(freeColClient, colony));
            this.add(applyDisaster);
        }
        if (tile.getIndianSettlement() != null) {
            JMenuItem displayGoods = new JMenuItem("Examine Settlement");
            IndianSettlement is = tile.getIndianSettlement();
            displayGoods.addActionListener(ae -> DebugUtils.summarizeSettlement(freeColClient, is));
            this.add(displayGoods);
        }
        if (changeOwnership.getItemCount() > 0) {
            this.add(changeOwnership);
        }
        if (changeRole.getItemCount() > 0) {
            this.add(changeRole);
        }
        if (tile.hasLostCityRumour()) {
            JMenuItem rumourItem = new JMenuItem("Set Lost City Rumour type");
            rumourItem.setOpaque(false);
            rumourItem.addActionListener(ae -> DebugUtils.setRumourType(freeColClient, tile));
            this.add(rumourItem);
        }
        JMenuItem addu = new JMenuItem("Add unit");
        addu.setOpaque(false);
        addu.addActionListener(ae -> DebugUtils.addNewUnitToTile(freeColClient, tile));
        this.add(addu);
        if (!tile.isEmpty()) {
            JMenuItem adda = new JMenuItem("Reset moves");
            adda.setOpaque(false);
            List<Unit> tileUnits = tile.getUnitList();
            adda.addActionListener(ae -> DebugUtils.resetMoves(freeColClient, tileUnits));
            this.add(adda);
        }
        if ((activeUnit = this.gui.getActiveUnit()) != null && activeUnit.getTile() != null) {
            JMenuItem menuItem = new JMenuItem("Show search");
            menuItem.addActionListener(ae -> {
                if (!freeColClient.currentPlayerIsMyPlayer()) {
                    return;
                }
                Tile currTile = activeUnit.getTile();
                if (currTile == tile) {
                    return;
                }
                Map map = activeUnit.getGame().getMap();
                LogBuilder lb = new LogBuilder(512);
                PathNode path = map.findPath(activeUnit, activeUnit.getTile(), tile, activeUnit.getCarrier(), null, lb);
                this.gui.showInformationMessage(lb.toString());
                this.canvas.setCurrentPath(path);
                this.gui.refresh();
            });
            this.add(menuItem);
        }
        for (Unit u : tile.getUnitList()) {
            if (!u.canCarryGoods() || !u.hasSpaceLeft()) continue;
            JMenuItem addg = new JMenuItem("Add goods");
            addg.setOpaque(false);
            Unit unit = u;
            addg.addActionListener(ae -> DebugUtils.addUnitGoods(freeColClient, unit));
            this.add(addg);
            break;
        }
        JMenuItem dumpItem = new JMenuItem("Dump tile");
        dumpItem.setOpaque(false);
        dumpItem.addActionListener(ae -> DebugUtils.dumpTile(freeColClient, tile));
        this.add(dumpItem);
    }

    private int addUnit(Container menu, Unit unit, boolean enabled, boolean indent) {
        StringTemplate occ = unit.getOccupationLabel(this.freeColClient.getMyPlayer(), true);
        String text = (indent ? "    " : "") + unit.getDescription(Unit.UnitLabelType.NATIONAL) + " (" + Messages.message(occ) + ")";
        JMenuItem menuItem = new JMenuItem(text);
        menuItem.setFont(FontLibrary.createFont(FontLibrary.FontType.NORMAL, FontLibrary.FontSize.TINY, 1, this.gui.getImageLibrary().getScaleFactor()));
        menuItem.addActionListener(ae -> this.gui.setActiveUnit(unit));
        if (indent) {
            menuItem.setFont(menuItem.getFont().deriveFont(2));
        }
        menuItem.setEnabled(enabled);
        menu.add(menuItem);
        int lineCount = 1 + unit.getUnitList().stream().mapToInt(u -> this.addUnit(menu, (Unit)u, true, true)).sum();
        boolean hasGoods = false;
        for (Goods goods : unit.getGoodsList()) {
            text = (indent ? "         " : "     ") + Messages.message(goods.getLabel(true));
            menuItem = new JMenuItem(text);
            menuItem.setFont(menuItem.getFont().deriveFont(2));
            menuItem.setEnabled(false);
            menu.add(menuItem);
            ++lineCount;
            hasGoods = true;
        }
        if (hasGoods) {
            JMenuItem dumpItem = Utility.localizedMenuItem("dumpCargo");
            dumpItem.setAction(new UnloadAction(this.freeColClient, unit));
            menu.add(dumpItem);
            ++lineCount;
        }
        this.hasAnItem = true;
        return lineCount;
    }

    private void addColony(Colony colony) {
        StringTemplate name = colony.getLocationLabelFor(this.freeColClient.getMyPlayer());
        JMenuItem menuItem = Utility.localizedMenuItem(name);
        menuItem.setFont(FontLibrary.createFont(FontLibrary.FontType.NORMAL, FontLibrary.FontSize.TINY, 1, this.gui.getImageLibrary().getScaleFactor()));
        menuItem.addActionListener(ae -> this.gui.showColonyPanel(colony, null));
        this.add(menuItem);
        menuItem = Utility.localizedMenuItem("rename");
        menuItem.addActionListener(ae -> this.freeColClient.getInGameController().rename(colony));
        this.add(menuItem);
        this.hasAnItem = true;
    }

    private void addIndianSettlement(IndianSettlement settlement) {
        StringTemplate name = settlement.getLocationLabelFor(this.freeColClient.getMyPlayer());
        JMenuItem menuItem = Utility.localizedMenuItem(name);
        menuItem.setFont(FontLibrary.createFont(FontLibrary.FontType.NORMAL, FontLibrary.FontSize.TINY, 1, this.gui.getImageLibrary().getScaleFactor()));
        menuItem.addActionListener(ae -> this.gui.showIndianSettlementPanel(settlement));
        this.add(menuItem);
        this.hasAnItem = true;
    }

    private void addTile(Tile tile) {
        JMenuItem menuItem = new JMenuItem(Messages.getName(tile));
        menuItem.addActionListener(ae -> this.gui.showTilePanel(tile));
        this.add(menuItem);
    }

    public boolean hasItem() {
        return this.getComponentCount() > 0;
    }
}

