/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.shtm;

import com.lightdev.app.shtm.DefaultTextResources;
import com.lightdev.app.shtm.SHTMLPanel;
import com.lightdev.app.shtm.SHTMLPanelImpl;
import com.lightdev.app.shtm.SHTMLPlugin;
import com.lightdev.app.shtm.TextResources;
import com.lightdev.app.shtm.Util;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;

public abstract class AbstractPlugin
implements SHTMLPlugin {
    public static TextResources textResources;
    public static final String PREFSID_PLUGIN_ACTIVE = "Active";
    public static final String PREFSID_PLUGIN_DOCK_LOCATION = "DockLocation";
    protected String internalName;
    protected String pluginMenuId;
    protected String helpMenuId;
    protected JMenuItem pMenu = null;
    protected JMenuItem hMenu = null;
    protected boolean active = true;
    protected int dockLocation = 4;
    protected JComponent c = null;
    protected JFrame frame = null;
    protected Preferences prefs = Preferences.userNodeForPackage(this.getClass());
    protected SHTMLPanelImpl owner;

    public void initPlugin(SHTMLPanelImpl owner) {
        this.owner = owner;
    }

    protected void createPluginMenu() {
        if (this.pluginMenuId != null) {
            this.pMenu = this.owner.dynRes.createMenu(textResources, this.pluginMenuId);
        }
    }

    protected void createHelpMenu() {
        if (this.helpMenuId != null) {
            this.hMenu = this.owner.dynRes.createMenu(textResources, this.helpMenuId);
            this.initHelpMenu();
        }
    }

    public void initHelpMenu() {
    }

    protected void createFrame() {
        if (this.c != null) {
            this.frame = new JFrame(this.getGUIName());
            this.frame.setDefaultCloseOperation(1);
            this.frame.setSize(300, 400);
            this.frame.getContentPane().add(this.c);
        }
        this.frame.pack();
    }

    protected void createFrameAsNeeded(int location) {
        if (location == 0) {
            if (this.frame == null && this.c != null) {
                this.createFrame();
            }
            if (this.frame != null) {
                this.frame.setVisible(true);
            }
        } else if (this.frame != null) {
            this.frame.setVisible(false);
        }
    }

    public void initPlugin(SHTMLPanel owner, String internalName, String pluginMenuId, String helpMenuId) {
        this.owner = (SHTMLPanelImpl)owner;
        this.internalName = internalName;
        this.pluginMenuId = pluginMenuId;
        this.helpMenuId = helpMenuId;
        try {
            if (SHTMLPanelImpl.pluginManager != null) {
                ClassLoader plLoader = SHTMLPanelImpl.pluginManager.getPluginLoader();
                if (plLoader != null) {
                    ResourceBundle resourceBundle = ResourceBundle.getBundle(this.getClass().getName(), Locale.getDefault(), plLoader);
                    textResources = new DefaultTextResources(resourceBundle);
                } else {
                    DefaultTextResources instance = new DefaultTextResources(ResourceBundle.getBundle(this.getClass().getName(), Locale.getDefault()));
                    textResources = instance;
                }
            } else {
                DefaultTextResources instance = new DefaultTextResources(ResourceBundle.getBundle(this.getClass().getName(), Locale.getDefault()));
                textResources = instance;
            }
            this.active = this.prefs.getBoolean(internalName + PREFSID_PLUGIN_ACTIVE, true);
            this.dockLocation = this.prefs.getInt(internalName + PREFSID_PLUGIN_DOCK_LOCATION, 4);
            this.createFrameAsNeeded(this.dockLocation);
        }
        catch (MissingResourceException mre) {
            Util.errMsg(null, this.getClass().getName() + ".properties not found", mre);
        }
    }

    public void setOwner(SHTMLPanelImpl owner) {
        this.owner = owner;
    }

    public SHTMLPanelImpl getOwner() {
        return this.owner;
    }

    public void setStatus(boolean isActive) {
        this.active = isActive;
        this.prefs.putBoolean(this.getInternalName() + PREFSID_PLUGIN_ACTIVE, isActive);
        try {
            this.prefs.flush();
        }
        catch (Exception e) {
            Util.errMsg(null, e.getMessage(), e);
        }
    }

    public void setDockLocation(int location) {
        this.dockLocation = location;
        this.prefs.putInt(this.getInternalName() + PREFSID_PLUGIN_DOCK_LOCATION, location);
        try {
            this.prefs.flush();
        }
        catch (Exception e) {
            Util.errMsg(null, e.getMessage(), e);
        }
        this.createFrameAsNeeded(location);
    }

    public JMenuItem getPluginMenu() {
        return this.pMenu;
    }

    public JMenuItem getHelpMenu() {
        return this.hMenu;
    }

    public String getGUIName() {
        return "AbstractPlugin";
    }

    public String getInternalName() {
        return this.internalName;
    }

    public int getDockLocation() {
        return this.dockLocation;
    }

    public JComponent getComponent() {
        return this.c;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getOwnerResString(String nm) {
        return Util.getResourceString(SHTMLPanelImpl.getResources(), nm);
    }

    public Action getOwnerAction(String cmd) {
        return this.owner.getDynRes().getAction(cmd);
    }
}

