/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.image;

import com.lizardworks.tiff.Tiff;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.fibs.geotag.image.ImageFile;
import org.fibs.geotag.util.ImageInputStreamGobbler;
import org.fibs.geotag.util.ImageUtil;

public class TiffImageFile
extends ImageFile {
    TiffImageFile(File file) {
        super(file);
    }

    @Override
    public BufferedImage read() throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        FileInputStream fileInputStream = new FileInputStream(this.getFile());
        ImageInputStreamGobbler gobbler = new ImageInputStreamGobbler(fileInputStream, (OutputStream)outputStream);
        gobbler.start();
        try {
            int sleepTime = 10;
            while (gobbler.isAlive()) {
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Tiff tiff = new Tiff();
        tiff.read(outputStream.toByteArray());
        Image image = tiff.getImage(0);
        BufferedImage bufferedImage = ImageUtil.bufferImage(image);
        fileInputStream.close();
        outputStream.close();
        if (bufferedImage == null) {
            throw new IOException();
        }
        return bufferedImage;
    }
}

