/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.x.io;

import com.google.protobuf.GeneratedMessage;
import com.mysql.cj.api.x.io.ColToFieldTransformer;
import com.mysql.cj.api.x.io.MessageListener;
import com.mysql.cj.api.x.io.ResultListener;
import com.mysql.cj.core.exceptions.WrongArgumentException;
import com.mysql.cj.core.result.Field;
import com.mysql.cj.x.core.XDevAPIError;
import com.mysql.cj.x.io.StatementExecuteOkBuilder;
import com.mysql.cj.x.io.XProtocolRow;
import com.mysql.cj.x.protobuf.Mysqlx;
import com.mysql.cj.x.protobuf.MysqlxNotice;
import com.mysql.cj.x.protobuf.MysqlxResultset;
import com.mysql.cj.x.protobuf.MysqlxSql;
import java.util.ArrayList;

public class ResultMessageListener
implements MessageListener {
    private ResultListener callbacks;
    private ColToFieldTransformer colToField;
    private ArrayList<Field> metadata = new ArrayList();
    private boolean metadataSent = false;
    private StatementExecuteOkBuilder okBuilder = new StatementExecuteOkBuilder();

    public ResultMessageListener(ColToFieldTransformer colToField, ResultListener callbacks) {
        this.callbacks = callbacks;
        this.colToField = colToField;
    }

    private boolean handleColumn(MysqlxResultset.ColumnMetaData col) {
        Field f = (Field)this.colToField.apply(col);
        this.metadata.add(f);
        return false;
    }

    private boolean handleRow(MysqlxResultset.Row r) {
        XProtocolRow row = new XProtocolRow(this.metadata, r);
        this.callbacks.onRow(row);
        return false;
    }

    private boolean handleStmtExecuteOk() {
        this.callbacks.onComplete(this.okBuilder.build());
        return true;
    }

    private boolean handleError(Mysqlx.Error error) {
        XDevAPIError e = new XDevAPIError(error);
        this.callbacks.onError(e);
        return true;
    }

    private void handleException(Throwable ex) {
        this.callbacks.onException(ex);
    }

    @Override
    public Boolean apply(Class<? extends GeneratedMessage> msgClass, GeneratedMessage msg) {
        if (MysqlxResultset.ColumnMetaData.class.equals(msgClass)) {
            return this.handleColumn((MysqlxResultset.ColumnMetaData)MysqlxResultset.ColumnMetaData.class.cast(msg));
        }
        if (!this.metadataSent) {
            this.callbacks.onMetadata(this.metadata);
            this.metadataSent = true;
        }
        if (MysqlxSql.StmtExecuteOk.class.equals(msgClass)) {
            return this.handleStmtExecuteOk();
        }
        if (MysqlxResultset.FetchDone.class.equals(msgClass)) {
            return false;
        }
        if (MysqlxResultset.Row.class.equals(msgClass)) {
            return this.handleRow((MysqlxResultset.Row)MysqlxResultset.Row.class.cast(msg));
        }
        if (Mysqlx.Error.class.equals(msgClass)) {
            return this.handleError((Mysqlx.Error)Mysqlx.Error.class.cast(msg));
        }
        if (MysqlxNotice.Frame.class.equals(msgClass)) {
            this.okBuilder.addNotice((MysqlxNotice.Frame)MysqlxNotice.Frame.class.cast(msg));
            return false;
        }
        this.handleException(new WrongArgumentException("Unhandled msg class (" + msgClass + ") + msg=" + msg));
        return false;
    }

    @Override
    public void closed() {
    }

    @Override
    public void error(Throwable ex) {
        this.handleException(ex);
    }
}

