/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.openide.filesystems.declmime.MIMEResolverImpl;
import org.openide.filesystems.FileObject;
import org.openide.util.Parameters;

public abstract class MIMEResolver {
    private String[] resolvableMIMETypes = null;

    public MIMEResolver(String ... mimeTypes) {
        Parameters.notNull((CharSequence)"mimeTypes", (Object)mimeTypes);
        if (mimeTypes.length == 0) {
            throw new IllegalArgumentException("The mimeTypes parameter cannot be empty array.");
        }
        for (String mimeType : mimeTypes) {
            if (mimeType != null && mimeType.length() != 0) continue;
            throw new IllegalArgumentException("The item in mimeTypes parameter cannot be null nor empty String.");
        }
        this.resolvableMIMETypes = mimeTypes;
    }

    @Deprecated
    public MIMEResolver() {
    }

    public abstract String findMIMEType(FileObject var1);

    String[] getMIMETypes() {
        return this.resolvableMIMETypes;
    }

    static MIMEResolver create(FileObject fo) throws IOException {
        return MIMEResolverImpl.create(fo);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ExtensionRegistration {
        public String displayName();

        public String mimeType();

        public String[] extension();

        public int position() default 0x7FFFFFFF;

        public String[] showInFileChooser() default {};
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NamespaceRegistration {
        public String displayName();

        public String mimeType();

        public int position() default 0x7FFFFFFF;

        public String[] acceptedExtension() default {};

        public String[] checkedExtension() default {"xml"};

        public String elementName() default "";

        public String[] elementNS() default {};

        public String[] doctypePublicId() default {};
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Registration {
        public String resource();

        public int position() default 0x7FFFFFFF;

        public String displayName();

        public String[] showInFileChooser() default {};
    }

    public abstract class UIHelpers {
        protected UIHelpers() {
            if (this.getClass().getName().equals("org.netbeans.core.ui.options.filetypes.FileAssociationsModel")) {
                return;
            }
            throw new IllegalStateException();
        }

        protected final void storeUserDefinedResolver(Map<String, Set<String>> mimeToExtensions) {
            MIMEResolverImpl.storeUserDefinedResolver(mimeToExtensions);
        }

        protected final Collection<? extends FileObject> getOrderedResolvers() {
            return MIMEResolverImpl.getOrderedResolvers();
        }

        protected final boolean isUserDefined(FileObject mimeResolverFO) {
            return MIMEResolverImpl.isUserDefined(mimeResolverFO);
        }

        protected final Map<String, Set<String>> getMIMEToExtensions(FileObject fo) {
            return MIMEResolverImpl.getMIMEToExtensions(fo);
        }
    }
}

