/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import org.openide.util.LookupListener;

final class LookupListenerList {
    private Object listeners;
    private static final LookupListener[] EMPTY = new LookupListener[0];

    LookupListenerList() {
    }

    synchronized void add(LookupListener l) {
        if (this.listeners == null) {
            this.listeners = l;
        } else if (this.listeners instanceof LookupListener) {
            if (this.listeners != l) {
                LookupListener[] arr;
                this.listeners = arr = new LookupListener[]{(LookupListener)this.listeners, l};
            }
        } else {
            LookupListener[] arr = (LookupListener[])this.listeners;
            LookupListener[] newArr = new LookupListener[arr.length + 1];
            for (int i = 0; i < arr.length; ++i) {
                if (l == arr[i]) {
                    return;
                }
                newArr[i] = arr[i];
            }
            newArr[arr.length] = l;
            this.listeners = newArr;
        }
    }

    synchronized void remove(LookupListener l) {
        if (this.listeners == null) {
            return;
        }
        if (this.listeners instanceof LookupListener) {
            if (this.listeners == l) {
                this.listeners = null;
            }
        } else {
            LookupListener[] arr = (LookupListener[])this.listeners;
            LookupListener[] newArr = new LookupListener[arr.length - 1];
            int indx = 0;
            for (int i = 0; i < arr.length; ++i) {
                if (l == arr[i]) continue;
                if (indx == newArr.length) {
                    return;
                }
                newArr[indx++] = arr[i];
            }
            this.listeners = newArr.length == 0 ? null : newArr;
        }
    }

    synchronized int getListenerCount() {
        if (this.listeners == null) {
            return 0;
        }
        if (this.listeners instanceof LookupListener) {
            return 1;
        }
        return ((LookupListener[])this.listeners).length;
    }

    synchronized LookupListener[] getListenerList() {
        if (this.listeners == null) {
            return EMPTY;
        }
        if (this.listeners instanceof LookupListener) {
            return new LookupListener[]{(LookupListener)this.listeners};
        }
        return (LookupListener[])this.listeners;
    }
}

