/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.edges;

import java.util.ArrayList;
import javax.swing.Icon;
import org.gephi.datalab.api.AttributeColumnsController;
import org.gephi.datalab.api.datatables.DataTablesController;
import org.gephi.datalab.plugin.manipulators.GeneralColumnsChooser;
import org.gephi.datalab.plugin.manipulators.edges.BasicEdgesManipulator;
import org.gephi.datalab.plugin.manipulators.ui.GeneralChooseColumnsUI;
import org.gephi.datalab.spi.ManipulatorUI;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.GraphController;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ClearEdgesData
extends BasicEdgesManipulator
implements GeneralColumnsChooser {
    private Edge[] edges;
    private Column[] columnsToClearData;

    public void setup(Edge[] edges, Edge clickedEdge) {
        this.edges = edges;
        AttributeColumnsController ac = (AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class);
        ArrayList<Column> columnsToClearDataList = new ArrayList<Column>();
        for (Column column : ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getEdgeTable()) {
            if (!ac.canClearColumnData(column)) continue;
            columnsToClearDataList.add(column);
        }
        this.columnsToClearData = columnsToClearDataList.toArray(new Column[0]);
    }

    public void execute() {
        if (this.columnsToClearData.length >= 0) {
            AttributeColumnsController ac = (AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class);
            ac.clearEdgesData(this.edges, this.columnsToClearData);
            ((DataTablesController)Lookup.getDefault().lookup(DataTablesController.class)).refreshCurrentTable();
        }
    }

    @Override
    public String getName() {
        if (this.edges.length > 1) {
            return NbBundle.getMessage(ClearEdgesData.class, (String)"ClearEdgesData.name.multiple");
        }
        return NbBundle.getMessage(ClearEdgesData.class, (String)"ClearEdgesData.name.single");
    }

    public String getDescription() {
        return NbBundle.getMessage(ClearEdgesData.class, (String)"ClearEdgesData.description");
    }

    public boolean canExecute() {
        return true;
    }

    public ManipulatorUI getUI() {
        return new GeneralChooseColumnsUI(NbBundle.getMessage(ClearEdgesData.class, (String)"ClearEdgesData.ui.description"));
    }

    public int getType() {
        return 200;
    }

    public int getPosition() {
        return 100;
    }

    public Icon getIcon() {
        return ImageUtilities.loadImageIcon((String)"org/gephi/datalab/plugin/manipulators/resources/clear-data.png", (boolean)true);
    }

    @Override
    public Column[] getColumns() {
        return this.columnsToClearData;
    }

    @Override
    public void setColumns(Column[] columnsToClearData) {
        this.columnsToClearData = columnsToClearData;
    }
}

