/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.statistics.plugin;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import org.gephi.graph.api.DirectedGraph;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeIterable;
import org.gephi.graph.api.Table;
import org.gephi.statistics.plugin.ChartUtils;
import org.gephi.statistics.spi.Statistics;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.openide.util.NbBundle;

public class WeightedDegree
implements Statistics,
LongTask {
    public static final String WDEGREE = "weighted degree";
    public static final String WINDEGREE = "weighted indegree";
    public static final String WOUTDEGREE = "weighted outdegree";
    private boolean isDirected;
    private boolean isCanceled;
    private ProgressTicket progress;
    private double avgWDegree;
    private Map<Double, Integer> degreeDist;
    private Map<Double, Integer> inDegreeDist;
    private Map<Double, Integer> outDegreeDist;

    public double getAverageDegree() {
        return this.avgWDegree;
    }

    public void execute(GraphModel graphModel) {
        Graph graph = graphModel.getGraphVisible();
        this.execute(graph);
    }

    public void execute(Graph graph) {
        this.isDirected = graph.isDirected();
        this.isCanceled = false;
        this.initializeDegreeDists();
        this.initializeAttributeColunms(graph.getModel());
        graph.readLock();
        try {
            this.avgWDegree = this.calculateAverageWeightedDegree(graph, this.isDirected, true);
        }
        finally {
            graph.readUnlockAll();
        }
    }

    public double calculateAverageWeightedDegree(Graph graph, boolean isDirected, boolean updateAttributes) {
        double averageWeightedDegree = 0.0;
        DirectedGraph directedGraph = null;
        if (isDirected) {
            directedGraph = (DirectedGraph)graph;
        }
        Progress.start((ProgressTicket)this.progress, (int)graph.getNodeCount());
        NodeIterable nodesIterable = graph.getNodes();
        for (Node n : nodesIterable) {
            double totalWeight = 0.0;
            if (isDirected) {
                double totalInWeight = 0.0;
                double totalOutWeight = 0.0;
                for (Edge e : directedGraph.getEdges(n)) {
                    if (e.getSource().equals(n)) {
                        totalOutWeight += e.getWeight();
                    }
                    if (!e.getTarget().equals(n)) continue;
                    totalInWeight += e.getWeight();
                }
                totalWeight = totalInWeight + totalOutWeight;
                n.setAttribute(WINDEGREE, (Object)totalInWeight);
                n.setAttribute(WOUTDEGREE, (Object)totalOutWeight);
                n.setAttribute(WDEGREE, (Object)totalWeight);
                this.updateDegreeDists(totalInWeight, totalOutWeight, totalWeight);
            } else {
                for (Edge e : graph.getEdges(n)) {
                    totalWeight += (double)(e.isSelfLoop() ? 2 : 1) * e.getWeight();
                }
                n.setAttribute(WDEGREE, (Object)totalWeight);
                this.updateDegreeDists(totalWeight);
            }
            averageWeightedDegree += totalWeight;
            if (this.isCanceled) {
                nodesIterable.doBreak();
                break;
            }
            Progress.progress((ProgressTicket)this.progress);
        }
        return averageWeightedDegree /= (isDirected ? 2.0 : 1.0) * (double)graph.getNodeCount();
    }

    private void initializeDegreeDists() {
        this.degreeDist = new HashMap<Double, Integer>();
        this.inDegreeDist = new HashMap<Double, Integer>();
        this.outDegreeDist = new HashMap<Double, Integer>();
    }

    private void initializeAttributeColunms(GraphModel graphModel) {
        Table nodeTable = graphModel.getNodeTable();
        if (this.isDirected) {
            if (!nodeTable.hasColumn(WINDEGREE)) {
                nodeTable.addColumn(WINDEGREE, NbBundle.getMessage(WeightedDegree.class, (String)"WeightedDegree.nodecolumn.InDegree"), Double.class, (Object)0.0);
            }
            if (!nodeTable.hasColumn(WOUTDEGREE)) {
                nodeTable.addColumn(WOUTDEGREE, NbBundle.getMessage(WeightedDegree.class, (String)"WeightedDegree.nodecolumn.OutDegree"), Double.class, (Object)0.0);
            }
        }
        if (!nodeTable.hasColumn(WDEGREE)) {
            nodeTable.addColumn(WDEGREE, NbBundle.getMessage(WeightedDegree.class, (String)"WeightedDegree.nodecolumn.Degree"), Double.class, (Object)0.0);
        }
    }

    private void updateDegreeDists(double winDegree, double woutDegree, double wdegree) {
        if (!this.inDegreeDist.containsKey(winDegree)) {
            this.inDegreeDist.put(winDegree, 0);
        }
        this.inDegreeDist.put(winDegree, this.inDegreeDist.get(winDegree) + 1);
        if (!this.outDegreeDist.containsKey(woutDegree)) {
            this.outDegreeDist.put(woutDegree, 0);
        }
        this.outDegreeDist.put(woutDegree, this.outDegreeDist.get(woutDegree) + 1);
        if (!this.degreeDist.containsKey(wdegree)) {
            this.degreeDist.put(wdegree, 0);
        }
        this.degreeDist.put(wdegree, this.degreeDist.get(wdegree) + 1);
    }

    private void updateDegreeDists(double wdegree) {
        if (!this.degreeDist.containsKey(wdegree)) {
            this.degreeDist.put(wdegree, 0);
        }
        this.degreeDist.put(wdegree, this.degreeDist.get(wdegree) + 1);
    }

    public String getReport() {
        String report;
        if (this.isDirected) {
            report = this.getDirectedReport();
        } else {
            XYSeries dSeries = ChartUtils.createXYSeries(this.degreeDist, "Degree Distribution");
            XYSeriesCollection dataset1 = new XYSeriesCollection();
            dataset1.addSeries(dSeries);
            JFreeChart chart1 = ChartFactory.createXYLineChart((String)"Degree Distribution", (String)"Value", (String)"Count", (XYDataset)dataset1, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
            chart1.removeLegend();
            ChartUtils.decorateChart(chart1);
            ChartUtils.scaleChart(chart1, dSeries, false);
            String degreeImageFile = ChartUtils.renderChart(chart1, "w-degree-distribution.png");
            DecimalFormat f = new DecimalFormat("#0.000");
            report = "<HTML> <BODY> <h1>Weighted Degree Report </h1> <hr><br> <h2> Results: </h2>Average Weighted Degree: " + f.format(this.avgWDegree) + "<br /><br />" + degreeImageFile + "</BODY></HTML>";
        }
        return report;
    }

    public String getDirectedReport() {
        XYSeries dSeries = ChartUtils.createXYSeries(this.degreeDist, "Degree Distribution");
        XYSeries idSeries = ChartUtils.createXYSeries(this.inDegreeDist, "In-Degree Distribution");
        XYSeries odSeries = ChartUtils.createXYSeries(this.outDegreeDist, "Out-Degree Distribution");
        XYSeriesCollection dataset1 = new XYSeriesCollection();
        dataset1.addSeries(dSeries);
        XYSeriesCollection dataset2 = new XYSeriesCollection();
        dataset2.addSeries(idSeries);
        XYSeriesCollection dataset3 = new XYSeriesCollection();
        dataset3.addSeries(odSeries);
        JFreeChart chart1 = ChartFactory.createXYLineChart((String)"Degree Distribution", (String)"Value", (String)"Count", (XYDataset)dataset1, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        ChartUtils.decorateChart(chart1);
        ChartUtils.scaleChart(chart1, dSeries, false);
        String degreeImageFile = ChartUtils.renderChart(chart1, "w-degree-distribution.png");
        JFreeChart chart2 = ChartFactory.createXYLineChart((String)"In-Degree Distribution", (String)"Value", (String)"Count", (XYDataset)dataset2, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        ChartUtils.decorateChart(chart2);
        ChartUtils.scaleChart(chart2, dSeries, false);
        String indegreeImageFile = ChartUtils.renderChart(chart2, "indegree-distribution.png");
        JFreeChart chart3 = ChartFactory.createXYLineChart((String)"Out-Degree Distribution", (String)"Value", (String)"Count", (XYDataset)dataset3, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        ChartUtils.decorateChart(chart3);
        ChartUtils.scaleChart(chart3, dSeries, false);
        String outdegreeImageFile = ChartUtils.renderChart(chart3, "outdegree-distribution.png");
        DecimalFormat f = new DecimalFormat("#0.000");
        String report = "<HTML> <BODY> <h1>Weighted Degree Report </h1> <hr><br> <h2> Results: </h2>Average Weighted Degree: " + f.format(this.avgWDegree) + "<br /><br />" + degreeImageFile + "<br /><br />" + indegreeImageFile + "<br /><br />" + outdegreeImageFile + "</BODY></HTML>";
        return report;
    }

    public boolean cancel() {
        this.isCanceled = true;
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progress = progressTicket;
    }
}

