/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.appearance;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.gephi.appearance.api.AppearanceController;
import org.gephi.appearance.api.AppearanceModel;
import org.gephi.appearance.api.AttributeFunction;
import org.gephi.appearance.api.Function;
import org.gephi.appearance.spi.Transformer;
import org.gephi.appearance.spi.TransformerCategory;
import org.gephi.appearance.spi.TransformerUI;
import org.gephi.desktop.appearance.AppearanceUIModel;
import org.gephi.desktop.appearance.AppearanceUIModelEvent;
import org.gephi.desktop.appearance.AppearanceUIModelListener;
import org.gephi.desktop.appearance.AutoAppyTransformer;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.ColumnObserver;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphObserver;
import org.gephi.graph.api.TableObserver;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.gephi.project.api.WorkspaceListener;
import org.openide.util.Lookup;

public class AppearanceUIController {
    protected static final String NODE_ELEMENT = "nodes";
    protected static final String EDGE_ELEMENT = "edges";
    protected static final String[] ELEMENT_CLASSES = new String[]{"nodes", "edges"};
    protected final Map<String, Map<TransformerCategory, Set<TransformerUI>>> transformers;
    protected final AppearanceController appearanceController;
    private final Set<AppearanceUIModelListener> listeners;
    private AppearanceUIModel model;
    private TableChangeObserver tableObserver;
    private GraphChangeObserver graphObserver;

    public AppearanceUIController() {
        ProjectController pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
        this.appearanceController = (AppearanceController)Lookup.getDefault().lookup(AppearanceController.class);
        pc.addWorkspaceListener(new WorkspaceListener(){

            public void initialize(Workspace workspace) {
            }

            public void select(Workspace workspace) {
                AppearanceUIModel oldModel = AppearanceUIController.this.model;
                AppearanceUIController.this.model = (AppearanceUIModel)workspace.getLookup().lookup(AppearanceUIModel.class);
                if (AppearanceUIController.this.model == null) {
                    AppearanceModel appearanceModel = AppearanceUIController.this.appearanceController.getModel(workspace);
                    AppearanceUIController.this.model = new AppearanceUIModel(AppearanceUIController.this, appearanceModel);
                    workspace.add((Object)AppearanceUIController.this.model);
                }
                AppearanceUIController.this.model.select();
                if (AppearanceUIController.this.tableObserver != null) {
                    AppearanceUIController.this.tableObserver.destroy();
                }
                if (AppearanceUIController.this.graphObserver != null) {
                    AppearanceUIController.this.graphObserver.destroy();
                    AppearanceUIController.this.graphObserver = null;
                }
                AppearanceUIController.this.tableObserver = new TableChangeObserver(workspace);
                AppearanceUIController.this.tableObserver.start();
                AppearanceUIController.this.firePropertyChangeEvent(AppearanceUIModelEvent.MODEL, oldModel, AppearanceUIController.this.model);
            }

            public void unselect(Workspace workspace) {
                if (AppearanceUIController.this.model != null) {
                    AppearanceUIController.this.model.unselect();
                }
            }

            public void close(Workspace workspace) {
            }

            public void disable() {
                AppearanceUIModel oldModel = AppearanceUIController.this.model;
                AppearanceUIController.this.model = null;
                AppearanceUIController.this.firePropertyChangeEvent(AppearanceUIModelEvent.MODEL, oldModel, AppearanceUIController.this.model);
                if (AppearanceUIController.this.tableObserver != null) {
                    AppearanceUIController.this.tableObserver.destroy();
                }
                if (AppearanceUIController.this.graphObserver != null) {
                    AppearanceUIController.this.graphObserver.destroy();
                    AppearanceUIController.this.graphObserver = null;
                }
            }
        });
        if (pc.getCurrentWorkspace() != null) {
            this.model = (AppearanceUIModel)pc.getCurrentWorkspace().getLookup().lookup(AppearanceUIModel.class);
            if (this.model == null) {
                AppearanceModel appearanceModel = this.appearanceController.getModel(pc.getCurrentWorkspace());
                this.model = new AppearanceUIModel(this, appearanceModel);
                pc.getCurrentWorkspace().add((Object)this.model);
                this.model.select();
                this.tableObserver = new TableChangeObserver(pc.getCurrentWorkspace());
                this.tableObserver.start();
            }
        }
        this.listeners = Collections.synchronizedSet(new HashSet());
        this.transformers = new HashMap<String, Map<TransformerCategory, Set<TransformerUI>>>();
        for (AppearanceModel ec : ELEMENT_CLASSES) {
            this.transformers.put((String)ec, new LinkedHashMap());
        }
        HashMap tMap = new HashMap();
        for (Transformer t : Lookup.getDefault().lookupAll(Transformer.class)) {
            tMap.put(t.getClass(), t);
        }
        for (TransformerUI ui : Lookup.getDefault().lookupAll(TransformerUI.class)) {
            Set<TransformerUI> uis;
            Transformer t = (Transformer)tMap.get(ui.getTransformerClass());
            if (t == null) continue;
            TransformerCategory c = ui.getCategory();
            if (t.isNode()) {
                uis = this.transformers.get(NODE_ELEMENT).get(c);
                if (uis == null) {
                    uis = new LinkedHashSet<TransformerUI>();
                    this.transformers.get(NODE_ELEMENT).put(c, uis);
                }
                uis.add(ui);
            }
            if (!t.isEdge()) continue;
            uis = this.transformers.get(EDGE_ELEMENT).get(c);
            if (uis == null) {
                uis = new LinkedHashSet<TransformerUI>();
                this.transformers.get(EDGE_ELEMENT).put(c, uis);
            }
            uis.add(ui);
        }
    }

    public Collection<TransformerCategory> getCategories(String elementClass) {
        return this.transformers.get(elementClass).keySet();
    }

    public Collection<TransformerUI> getTransformerUIs(String elementClass, TransformerCategory category) {
        return this.transformers.get(elementClass).get(category);
    }

    public AppearanceUIModel getModel() {
        return this.model;
    }

    public AppearanceUIModel getModel(Workspace workspace) {
        AppearanceUIModel m = (AppearanceUIModel)workspace.getLookup().lookup(AppearanceUIModel.class);
        if (m == null) {
            AppearanceController ac = (AppearanceController)Lookup.getDefault().lookup(AppearanceController.class);
            AppearanceModel appearanceModel = ac.getModel(workspace);
            m = new AppearanceUIModel(this, appearanceModel);
            workspace.add((Object)m);
        }
        return m;
    }

    public void setSelectedElementClass(String elementClass) {
        String oldValue;
        if (this.graphObserver != null) {
            this.graphObserver.destroy();
            this.graphObserver = null;
        }
        if (!elementClass.equals(NODE_ELEMENT) && !elementClass.equals(EDGE_ELEMENT)) {
            throw new RuntimeException("Element class has to be nodes or edges");
        }
        if (this.model != null && !(oldValue = this.model.getSelectedElementClass()).equals(elementClass)) {
            this.model.setSelectedElementClass(elementClass);
            Function function = this.model.getSelectedFunction();
            if (function != null) {
                this.model.refreshSelectedFunction();
                if (!function.isSimple()) {
                    this.graphObserver = new GraphChangeObserver(function.getGraph(), function instanceof AttributeFunction ? ((AttributeFunction)function).getColumn() : null);
                    this.graphObserver.start();
                }
            }
            this.firePropertyChangeEvent(AppearanceUIModelEvent.SELECTED_ELEMENT_CLASS, oldValue, elementClass);
        }
    }

    public void setSelectedCategory(TransformerCategory category) {
        TransformerCategory oldValue;
        if (this.graphObserver != null) {
            this.graphObserver.destroy();
            this.graphObserver = null;
        }
        if (this.model != null && !(oldValue = this.model.getSelectedCategory()).equals(category)) {
            this.model.setSelectedCategory(category);
            Function function = this.model.getSelectedFunction();
            if (function != null) {
                this.model.refreshSelectedFunction();
                if (!function.isSimple()) {
                    this.graphObserver = new GraphChangeObserver(function.getGraph(), function instanceof AttributeFunction ? ((AttributeFunction)function).getColumn() : null);
                    this.graphObserver.start();
                }
            }
            this.firePropertyChangeEvent(AppearanceUIModelEvent.SELECTED_CATEGORY, oldValue, category);
        }
    }

    public void setSelectedTransformerUI(TransformerUI ui) {
        TransformerUI oldValue;
        if (this.graphObserver != null) {
            this.graphObserver.destroy();
            this.graphObserver = null;
        }
        if (this.model != null && !(oldValue = this.model.getSelectedTransformerUI()).equals(ui)) {
            this.model.setAutoApply(false);
            this.model.setSelectedTransformerUI(ui);
            Function function = this.model.getSelectedFunction();
            if (function != null) {
                this.model.refreshSelectedFunction();
                if (!function.isSimple()) {
                    this.graphObserver = new GraphChangeObserver(function.getGraph(), function instanceof AttributeFunction ? ((AttributeFunction)function).getColumn() : null);
                    this.graphObserver.start();
                }
            }
            this.firePropertyChangeEvent(AppearanceUIModelEvent.SELECTED_TRANSFORMER_UI, oldValue, ui);
        }
    }

    public void setSelectedFunction(Function function) {
        Function oldValue;
        if (this.graphObserver != null) {
            this.graphObserver.destroy();
            this.graphObserver = null;
        }
        if (this.model != null && ((oldValue = this.model.getSelectedFunction()) == null && function != null || oldValue != null && function == null || function != null && oldValue != null && !oldValue.equals(function))) {
            this.model.setAutoApply(false);
            this.model.setSelectedFunction(function);
            this.firePropertyChangeEvent(AppearanceUIModelEvent.SELECTED_FUNCTION, oldValue, function);
            if (function != null && !function.isSimple()) {
                this.graphObserver = new GraphChangeObserver(function.getGraph(), function instanceof AttributeFunction ? ((AttributeFunction)function).getColumn() : null);
                this.graphObserver.start();
            }
        }
    }

    public void setAutoApply(boolean autoApply) {
        if (this.model != null) {
            this.model.setAutoApply(autoApply);
            this.firePropertyChangeEvent(AppearanceUIModelEvent.SET_AUTO_APPLY, !autoApply, autoApply);
        }
    }

    public void startAutoApply() {
        AutoAppyTransformer aat;
        if (this.model != null && (aat = this.model.getAutoAppyTransformer()) != null) {
            aat.start();
            this.firePropertyChangeEvent(AppearanceUIModelEvent.START_STOP_AUTO_APPLY, false, true);
        }
    }

    public void stopAutoApply() {
        AutoAppyTransformer aat;
        if (this.model != null && (aat = this.model.getAutoAppyTransformer()) != null) {
            aat.stop();
            this.firePropertyChangeEvent(AppearanceUIModelEvent.START_STOP_AUTO_APPLY, true, false);
        }
    }

    public AppearanceController getAppearanceController() {
        return this.appearanceController;
    }

    protected TransformerCategory getFirstCategory(String elementClass) {
        return this.transformers.get(elementClass).keySet().toArray(new TransformerCategory[0])[0];
    }

    protected TransformerUI getFirstTransformerUI(String elementClass, TransformerCategory category) {
        Map<TransformerCategory, Set<TransformerUI>> e = this.transformers.get(elementClass);
        return e.get(category).toArray(new TransformerUI[0])[0];
    }

    public void addPropertyChangeListener(AppearanceUIModelListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removePropertyChangeListener(AppearanceUIModelListener listener) {
        this.listeners.remove(listener);
    }

    protected void firePropertyChangeEvent(String propertyName, Object oldValue, Object newValue) {
        AppearanceUIModelEvent event = new AppearanceUIModelEvent(this, propertyName, oldValue, newValue);
        for (AppearanceUIModelListener listener : this.listeners) {
            listener.propertyChange(event);
        }
    }

    private class TableChangeObserver
    extends TimerTask {
        private final GraphController gc = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        private static final int INTERVAL = 500;
        private final Timer timer = new Timer("AppearanceColumnObserver", true);
        private final TableObserver nodeObserver;
        private final TableObserver edgeObserver;

        public TableChangeObserver(Workspace workspace) {
            this.nodeObserver = this.gc.getGraphModel(workspace).getNodeTable().createTableObserver(false);
            this.edgeObserver = this.gc.getGraphModel(workspace).getEdgeTable().createTableObserver(false);
        }

        @Override
        public void run() {
            if (this.nodeObserver.hasTableChanged() || this.edgeObserver.hasTableChanged()) {
                Function oldValue = AppearanceUIController.this.model.getSelectedFunction();
                AppearanceUIController.this.model.refreshSelectedFunction();
                Function newValue = AppearanceUIController.this.model.getSelectedFunction();
                AppearanceUIController.this.firePropertyChangeEvent(AppearanceUIModelEvent.SELECTED_FUNCTION, oldValue, newValue);
            }
        }

        public void start() {
            this.timer.schedule((TimerTask)this, 500L, 500L);
        }

        public void stop() {
            this.timer.cancel();
        }

        public void destroy() {
            this.stop();
            if (!this.nodeObserver.isDestroyed()) {
                this.nodeObserver.destroy();
            }
            if (!this.edgeObserver.isDestroyed()) {
                this.edgeObserver.destroy();
            }
        }
    }

    private class GraphChangeObserver
    extends TimerTask {
        private static final int INTERVAL = 2000;
        private final Timer timer = new Timer("GraphChangeObserver", true);
        private final ColumnObserver columnObserver;
        private final GraphObserver graphObserver;

        public GraphChangeObserver(Graph graph, Column column) {
            this.graphObserver = graph.getModel().createGraphObserver(graph, false);
            this.columnObserver = column != null ? column.createColumnObserver(false) : null;
        }

        @Override
        public void run() {
            boolean columnChanged;
            boolean graphChanged = this.graphObserver.hasGraphChanged();
            boolean bl = columnChanged = this.columnObserver != null ? this.columnObserver.hasColumnChanged() : false;
            if (graphChanged || columnChanged) {
                Function oldValue = AppearanceUIController.this.model.getSelectedFunction();
                AppearanceUIController.this.model.refreshSelectedFunction();
                Function newValue = AppearanceUIController.this.model.getSelectedFunction();
                AppearanceUIController.this.firePropertyChangeEvent(AppearanceUIModelEvent.SELECTED_FUNCTION, oldValue, newValue);
            }
        }

        public void start() {
            this.timer.schedule((TimerTask)this, 2000L, 2000L);
        }

        public void stop() {
            this.timer.cancel();
        }

        public void destroy() {
            this.stop();
            if (!this.graphObserver.isDestroyed()) {
                this.graphObserver.destroy();
            }
            if (this.columnObserver != null && !this.columnObserver.isDestroyed()) {
                this.columnObserver.destroy();
            }
        }
    }
}

