/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.statistics;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gephi.desktop.statistics.AvailableStatisticsChooser;
import org.gephi.desktop.statistics.StatisticsControllerUIImpl;
import org.gephi.desktop.statistics.StatisticsModelUIImpl;
import org.gephi.desktop.statistics.StatisticsPanel;
import org.gephi.desktop.statistics.api.StatisticsControllerUI;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.Workspace;
import org.gephi.project.api.WorkspaceListener;
import org.gephi.ui.utils.UIUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="StatisticsTopComponent", iconBase="org/gephi/desktop/statistics/resources/small.png", persistenceType=0)
public final class StatisticsTopComponent
extends TopComponent
implements ChangeListener {
    private transient StatisticsModelUIImpl model;
    private JButton settingsButton;
    private JPanel statisticsPanel;
    private JToolBar toolbar;

    public StatisticsTopComponent() {
        this.initComponents();
        this.initDesign();
        this.setName(NbBundle.getMessage(StatisticsTopComponent.class, (String)"CTL_StatisticsTopComponent"));
        this.putClientProperty("netbeans.winsys.tc.maximization_disabled", Boolean.TRUE);
        StatisticsControllerUI sc = (StatisticsControllerUI)Lookup.getDefault().lookup(StatisticsControllerUI.class);
        ProjectController pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
        pc.addWorkspaceListener(new WorkspaceListener(){

            public void initialize(Workspace workspace) {
            }

            public void select(Workspace workspace) {
                StatisticsModelUIImpl model = (StatisticsModelUIImpl)workspace.getLookup().lookup(StatisticsModelUIImpl.class);
                if (model == null) {
                    model = new StatisticsModelUIImpl(workspace);
                    workspace.add((Object)model);
                }
                StatisticsTopComponent.this.refreshModel(model);
            }

            public void unselect(Workspace workspace) {
            }

            public void close(Workspace workspace) {
            }

            public void disable() {
                StatisticsTopComponent.this.refreshModel(null);
            }
        });
        if (pc.getCurrentWorkspace() != null) {
            StatisticsModelUIImpl model = (StatisticsModelUIImpl)pc.getCurrentWorkspace().getLookup().lookup(StatisticsModelUIImpl.class);
            if (model == null) {
                model = new StatisticsModelUIImpl(pc.getCurrentWorkspace());
                pc.getCurrentWorkspace().add((Object)model);
            }
            this.refreshModel(model);
        } else {
            this.refreshModel(null);
        }
        this.settingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AvailableStatisticsChooser chooser = new AvailableStatisticsChooser();
                chooser.setup(StatisticsTopComponent.this.model, ((StatisticsPanel)StatisticsTopComponent.this.statisticsPanel).getCategories());
                DialogDescriptor dd = new DialogDescriptor((Object)chooser, NbBundle.getMessage(StatisticsTopComponent.class, (String)"AvailableStatisticsChooser.title"));
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd).equals(NotifyDescriptor.OK_OPTION)) {
                    chooser.unsetup();
                }
            }
        });
    }

    private void refreshModel(StatisticsModelUIImpl model) {
        if (model != null && model != this.model) {
            if (this.model != null) {
                this.model.removeChangeListener(this);
            }
            model.addChangeListener(this);
        }
        this.model = model;
        ((StatisticsControllerUIImpl)Lookup.getDefault().lookup(StatisticsControllerUIImpl.class)).setup(model);
        this.refreshEnable(model != null);
        ((StatisticsPanel)this.statisticsPanel).refreshModel(model);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.refreshModel(this.model);
    }

    private void refreshEnable(boolean enable) {
        this.statisticsPanel.setEnabled(enable);
        this.toolbar.setEnabled(enable);
        this.settingsButton.setEnabled(enable);
    }

    private void initDesign() {
        Border b = (Border)UIManager.get("Nb.Editor.Toolbar.border");
        this.toolbar.setBorder(b);
        if (UIUtils.isAquaLookAndFeel()) {
            this.toolbar.setBackground(UIManager.getColor("NbExplorerView.background"));
        }
    }

    private void initComponents() {
        this.toolbar = new JToolBar();
        this.settingsButton = new JButton();
        this.statisticsPanel = new StatisticsPanel();
        this.setLayout(new GridBagLayout());
        this.toolbar.setFloatable(false);
        this.toolbar.setRollover(true);
        Mnemonics.setLocalizedText((AbstractButton)this.settingsButton, (String)NbBundle.getMessage(StatisticsTopComponent.class, (String)"StatisticsTopComponent.settingsButton.text"));
        this.settingsButton.setFocusable(false);
        this.settingsButton.setHorizontalTextPosition(0);
        this.settingsButton.setVerticalTextPosition(3);
        this.toolbar.add(this.settingsButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.add(this.toolbar, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this.statisticsPanel, gridBagConstraints);
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }
}

