/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.sew;

import tim.prune.data.Coordinate;
import tim.prune.data.DataPoint;

public class SegmentEnd
implements Comparable<SegmentEnd> {
    private SegmentEnd _otherEnd = null;
    private Coordinate _longitude = null;
    private Coordinate _latitude = null;
    private int _pointIndex = 0;
    private boolean _active = true;

    public SegmentEnd(DataPoint dataPoint, int n) {
        this._longitude = dataPoint.getLongitude();
        this._latitude = dataPoint.getLatitude();
        this._pointIndex = n;
        this._active = true;
    }

    public void setOtherEnd(SegmentEnd segmentEnd) {
        this._otherEnd = segmentEnd;
    }

    public SegmentEnd getOtherEnd() {
        return this._otherEnd;
    }

    public boolean isStart() {
        return this._otherEnd == null || this._otherEnd._pointIndex > this._pointIndex;
    }

    public int getPointIndex() {
        return this._pointIndex;
    }

    public int getOtherPointIndex() {
        return this._otherEnd == null ? this._pointIndex : this._otherEnd._pointIndex;
    }

    public int getEarlierIndex() {
        return this.isStart() ? this._pointIndex : this._otherEnd._pointIndex;
    }

    public int getLaterIndex() {
        return this.isStart() ? this._otherEnd._pointIndex : this._pointIndex;
    }

    public SegmentEnd getEarlierEnd() {
        return this.isStart() ? this : this._otherEnd;
    }

    public SegmentEnd getLaterEnd() {
        return this.isStart() ? this._otherEnd : this;
    }

    public void reverseSegment() {
        if (this._otherEnd != null) {
            int n = this._pointIndex;
            this._pointIndex = this._otherEnd._pointIndex;
            this._otherEnd._pointIndex = n;
        }
    }

    public boolean isActive() {
        return this._active;
    }

    public void deactivate() {
        this._active = false;
    }

    public boolean atSamePointAs(SegmentEnd segmentEnd) {
        return segmentEnd != null && this._latitude.equals(segmentEnd._latitude) && this._longitude.equals(segmentEnd._longitude);
    }

    @Override
    public int compareTo(SegmentEnd segmentEnd) {
        if (segmentEnd == null) {
            return -1;
        }
        if (!this._latitude.equals(segmentEnd._latitude)) {
            return this._latitude.getDouble() < segmentEnd._latitude.getDouble() ? -1 : 1;
        }
        if (!this._longitude.equals(segmentEnd._longitude)) {
            return this._longitude.getDouble() < segmentEnd._longitude.getDouble() ? -1 : 1;
        }
        return this._pointIndex - segmentEnd._pointIndex;
    }

    public void adjustPointIndex(int n, int n2, int n3) {
        int n4;
        int n5 = n2 - n + 1;
        boolean bl = n3 > n2;
        int n6 = bl ? n2 + 1 : n3;
        int n7 = n4 = bl ? n3 - 1 : n - 1;
        if (this._pointIndex >= n6 && this._pointIndex <= n4) {
            this._pointIndex = bl ? (this._pointIndex -= n5) : (this._pointIndex += n5);
        } else if (this._pointIndex == n) {
            this._pointIndex = bl ? n3 - n5 : n3;
        } else if (this._pointIndex == n2) {
            this._pointIndex = bl ? n3 - 1 : n3 + n2 - n;
        }
    }
}

