/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.threedee;

import tim.prune.data.DataPoint;
import tim.prune.data.PointScaler;
import tim.prune.data.Track;

public class ThreeDModel {
    private Track _track = null;
    private Track _terrainTrack = null;
    private PointScaler _scaler = null;
    private double _scaleFactor = 1.0;
    private double _altFactor = 1.0;
    private double _externalScaleFactor = 1.0;
    private byte[] _pointTypes = null;
    private byte[] _pointHeights = null;
    public static final byte POINT_TYPE_WAYPOINT = 1;
    public static final byte POINT_TYPE_NORMAL_POINT = 2;
    public static final byte POINT_TYPE_SEGMENT_START = 3;

    public ThreeDModel(Track track) {
        this._track = track;
    }

    public void setTerrain(Track track) {
        this._terrainTrack = track;
    }

    public int getNumPoints() {
        if (this._track == null) {
            return 0;
        }
        return this._track.getNumPoints();
    }

    public void setAltitudeFactor(double d) {
        this._altFactor = d;
    }

    public void setModelSize(double d) {
        this._externalScaleFactor = d;
    }

    public void scale() {
        this._scaler = new PointScaler(this._track);
        this._scaler.addTerrain(this._terrainTrack);
        this._scaler.scale();
        double d = this._scaler.getAltitudeRange() * this._altFactor;
        if (d > 0.5) {
            this._altFactor = this._altFactor * 0.5 / d;
        }
        this.calculatePointTypes();
    }

    private void calculatePointTypes() {
        int n = this.getNumPoints();
        this._pointTypes = new byte[n];
        this._pointHeights = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            DataPoint dataPoint = this._track.getPoint(n2);
            this._pointTypes[n2] = dataPoint.isWaypoint() ? 1 : (dataPoint.getSegmentStart() ? 3 : 2);
            this._pointHeights[n2] = (byte)(dataPoint.getAltitude().getMetricValue() / 500.0);
            ++n2;
        }
    }

    public double getScaledHorizValue(int n) {
        return this._scaler.getHorizValue(n) * this._scaleFactor * this._externalScaleFactor;
    }

    public double getScaledVertValue(int n) {
        return this._scaler.getVertValue(n) * this._scaleFactor * this._externalScaleFactor;
    }

    public double getScaledAltValue(int n) {
        double d = this._scaler.getAltValue(n);
        if (d <= 0.0) {
            return 0.0;
        }
        return d * this._altFactor * this._externalScaleFactor;
    }

    public double getScaledTerrainHorizValue(int n) {
        return this._scaler.getTerrainHorizValue(n) * this._scaleFactor * this._externalScaleFactor;
    }

    public double getScaledTerrainVertValue(int n) {
        return this._scaler.getTerrainVertValue(n) * this._scaleFactor * this._externalScaleFactor;
    }

    public double getScaledTerrainValue(int n) {
        double d = this._scaler.getTerrainAltValue(n);
        if (d <= 0.0) {
            return 0.0;
        }
        return d * this._altFactor;
    }

    public byte getPointType(int n) {
        return this._pointTypes[n];
    }

    public byte getPointHeightCode(int n) {
        return this._pointHeights[n];
    }
}

