/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.lang.Closure;
import groovy.lang.EmptyRange;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.Range;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.IteratorClosureAdapter;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberMinus;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberMultiply;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberPlus;

public class NumberRange
extends AbstractList<Comparable>
implements Range<Comparable> {
    private final Comparable from;
    private final Comparable to;
    private final Number stepSize;
    private int size = -1;
    private Integer hashCodeCache = null;
    private final boolean reverse;
    private final boolean inclusive;

    public <T extends Number, U extends Number> NumberRange(T from, U to) {
        this(from, to, null, true);
    }

    public <T extends Number, U extends Number> NumberRange(T from, U to, boolean inclusive) {
        this(from, to, null, inclusive);
    }

    public <T extends Number, U extends Number, V extends Number> NumberRange(T from, U to, V stepSize) {
        this(from, to, stepSize, true);
    }

    public <T extends Number, U extends Number, V extends Number> NumberRange(T from, U to, V stepSize, boolean inclusive) {
        Object tempTo;
        Object tempFrom;
        if (from == null) {
            throw new IllegalArgumentException("Must specify a non-null value for the 'from' index in a Range");
        }
        if (to == null) {
            throw new IllegalArgumentException("Must specify a non-null value for the 'to' index in a Range");
        }
        this.reverse = NumberRange.areReversed(from, to);
        if (this.reverse) {
            tempFrom = to;
            tempTo = from;
        } else {
            tempFrom = from;
            tempTo = to;
        }
        if (tempFrom instanceof Short) {
            tempFrom = ((Number)tempFrom).intValue();
        } else if (tempFrom instanceof Float) {
            tempFrom = ((Number)tempFrom).doubleValue();
        }
        if (tempTo instanceof Short) {
            tempTo = ((Number)tempTo).intValue();
        } else if (tempTo instanceof Float) {
            tempTo = ((Number)tempTo).doubleValue();
        }
        if (tempFrom instanceof Integer && tempTo instanceof Long) {
            tempFrom = ((Number)tempFrom).longValue();
        } else if (tempTo instanceof Integer && tempFrom instanceof Long) {
            tempTo = ((Number)tempTo).longValue();
        }
        this.from = (Comparable)tempFrom;
        this.to = (Comparable)tempTo;
        this.stepSize = stepSize == null ? Integer.valueOf(1) : stepSize;
        this.inclusive = inclusive;
    }

    public <T extends Number> NumberRange by(T stepSize) {
        if (!Integer.valueOf(1).equals(this.stepSize)) {
            throw new IllegalStateException("by only allowed on ranges with original stepSize = 1 but found " + this.stepSize);
        }
        return new NumberRange(NumberRange.comparableNumber(this.from), NumberRange.comparableNumber(this.to), stepSize, this.inclusive);
    }

    static <T extends Number> T comparableNumber(Comparable c) {
        return (T)((Number)((Object)c));
    }

    static <T extends Number> T comparableNumber(Number n) {
        return (T)n;
    }

    private static boolean areReversed(Number from, Number to) {
        try {
            return ScriptBytecodeAdapter.compareGreaterThan(from, to);
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("Unable to create range due to incompatible types: " + from.getClass().getSimpleName() + ".." + to.getClass().getSimpleName() + " (possible missing brackets around range?)", cce);
        }
    }

    @Override
    public boolean equals(Object that) {
        return super.equals(that);
    }

    @Override
    public int hashCode() {
        if (this.hashCodeCache == null) {
            this.hashCodeCache = super.hashCode();
        }
        return this.hashCodeCache;
    }

    public boolean fastEquals(NumberRange that) {
        return that != null && this.reverse == that.reverse && this.inclusive == that.inclusive && ScriptBytecodeAdapter.compareEqual(this.from, that.from) && ScriptBytecodeAdapter.compareEqual(this.to, that.to) && ScriptBytecodeAdapter.compareEqual(this.stepSize, that.stepSize);
    }

    @Override
    public Comparable getFrom() {
        return this.from;
    }

    @Override
    public Comparable getTo() {
        return this.to;
    }

    public Comparable getStepSize() {
        return (Comparable)((Object)this.stepSize);
    }

    @Override
    public boolean isReverse() {
        return this.reverse;
    }

    @Override
    public Comparable get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + " should not be negative");
        }
        StepIterator iter = new StepIterator(this, this.stepSize);
        Comparable value = (Comparable)iter.next();
        for (int i = 0; i < index; ++i) {
            if (!iter.hasNext()) {
                throw new IndexOutOfBoundsException("Index: " + index + " is too big for range: " + this);
            }
            value = (Comparable)iter.next();
        }
        return value;
    }

    @Override
    public boolean containsWithinBounds(Object value) {
        int result = ScriptBytecodeAdapter.compareTo(this.from, value);
        return result == 0 || result < 0 && ScriptBytecodeAdapter.compareTo(this.to, value) >= 0;
    }

    private void setSize(int size) {
        throw new UnsupportedOperationException("size must not be changed");
    }

    @Override
    public int size() {
        if (this.size == -1) {
            this.calcSize(this.from, this.to, this.stepSize);
        }
        return this.size;
    }

    void calcSize(Comparable from, Comparable to, Number stepSize) {
        int tempsize = 0;
        boolean shortcut = false;
        if (this.isIntegral(stepSize)) {
            BigInteger sizeNum;
            BigInteger toNum;
            Number toTemp;
            Number fromNum;
            if ((from instanceof Integer || from instanceof Long) && (to instanceof Integer || to instanceof Long)) {
                fromNum = new BigInteger(from.toString());
                toTemp = new BigInteger(to.toString());
                toNum = this.inclusive ? toTemp : ((BigInteger)toTemp).subtract(BigInteger.ONE);
                sizeNum = new BigDecimal(toNum.subtract((BigInteger)fromNum)).divide(new BigDecimal(stepSize.longValue()), 1).toBigInteger().add(BigInteger.ONE);
                tempsize = sizeNum.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) == -1 ? sizeNum.intValue() : Integer.MAX_VALUE;
                shortcut = true;
            } else if ((from instanceof BigDecimal || from instanceof BigInteger) && to instanceof Number || (to instanceof BigDecimal || to instanceof BigInteger) && from instanceof Number) {
                fromNum = new BigDecimal(from.toString());
                toTemp = new BigDecimal(to.toString());
                toNum = this.inclusive ? toTemp : ((BigDecimal)toTemp).subtract(new BigDecimal("1.0"));
                sizeNum = ((BigDecimal)((Object)toNum)).subtract((BigDecimal)fromNum).divide(new BigDecimal(stepSize.longValue()), 1).toBigInteger().add(BigInteger.ONE);
                tempsize = sizeNum.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) == -1 ? sizeNum.intValue() : Integer.MAX_VALUE;
                shortcut = true;
            }
        }
        if (!shortcut) {
            StepIterator iter = new StepIterator(this, stepSize);
            while (iter.hasNext() && ++tempsize >= 0) {
                iter.next();
            }
            if (tempsize < 0) {
                tempsize = Integer.MAX_VALUE;
            }
        }
        this.size = tempsize;
    }

    private boolean isIntegral(Number stepSize) {
        BigDecimal tempStepSize = new BigDecimal(stepSize.toString());
        return tempStepSize.equals(new BigDecimal(tempStepSize.toBigInteger()));
    }

    @Override
    public List<Comparable> subList(int fromIndex, int toIndex) {
        int i;
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex == toIndex) {
            return new EmptyRange<Comparable>(this.from);
        }
        StepIterator iter = new StepIterator(this, this.stepSize);
        Comparable value = (Comparable)iter.next();
        for (i = 0; i < fromIndex; ++i) {
            if (!iter.hasNext()) {
                throw new IndexOutOfBoundsException("Index: " + i + " is too big for range: " + this);
            }
            value = (Comparable)iter.next();
        }
        Comparable fromValue = value;
        while (i < toIndex - 1) {
            if (!iter.hasNext()) {
                throw new IndexOutOfBoundsException("Index: " + i + " is too big for range: " + this);
            }
            value = (Comparable)iter.next();
            ++i;
        }
        Comparable toValue = value;
        return new NumberRange(NumberRange.comparableNumber(fromValue), NumberRange.comparableNumber(toValue), NumberRange.comparableNumber(this.stepSize), true);
    }

    @Override
    public String toString() {
        return this.getToString(this.to.toString(), this.from.toString());
    }

    @Override
    public String inspect() {
        return this.getToString(InvokerHelper.inspect(this.to), InvokerHelper.inspect(this.from));
    }

    private String getToString(String toText, String fromText) {
        String sep = this.inclusive ? ".." : "..<";
        String base = this.reverse ? "" + toText + sep + fromText : "" + fromText + sep + toText;
        return Integer.valueOf(1).equals(this.stepSize) ? base : base + ".by(" + this.stepSize + ")";
    }

    @Override
    public boolean contains(Object value) {
        if (value == null) {
            return false;
        }
        StepIterator it = new StepIterator(this, this.stepSize);
        while (it.hasNext()) {
            if (!ScriptBytecodeAdapter.compareEqual(value, it.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void step(int numSteps, Closure closure) {
        if (numSteps == 0 && ScriptBytecodeAdapter.compareTo(this.from, this.to) == 0) {
            return;
        }
        StepIterator iter = new StepIterator(this, NumberNumberMultiply.multiply(numSteps, this.stepSize));
        while (iter.hasNext()) {
            closure.call((Object)iter.next());
        }
    }

    @Override
    public Iterator<Comparable> iterator() {
        return new StepIterator(this, this.stepSize);
    }

    @Override
    public List<Comparable> step(int numSteps) {
        IteratorClosureAdapter adapter = new IteratorClosureAdapter(this);
        this.step(numSteps, adapter);
        return adapter.asList();
    }

    private Comparable increment(Object value, Number step) {
        return (Comparable)((Object)NumberNumberPlus.plus((Number)value, step));
    }

    private Comparable decrement(Object value, Number step) {
        return (Comparable)((Object)NumberNumberMinus.minus((Number)value, step));
    }

    private class StepIterator
    implements Iterator<Comparable> {
        private final NumberRange range;
        private final Number step;
        private final boolean isAscending;
        private boolean isNextFetched = false;
        private Comparable next = null;

        StepIterator(NumberRange range, Number step) {
            if (ScriptBytecodeAdapter.compareEqual(step, 0) && ScriptBytecodeAdapter.compareNotEqual(range.getFrom(), range.getTo())) {
                throw new GroovyRuntimeException("Infinite loop detected due to step size of 0");
            }
            this.range = range;
            if (ScriptBytecodeAdapter.compareLessThan(step, 0)) {
                this.step = NumberNumberMultiply.multiply(step, -1);
                this.isAscending = range.isReverse();
            } else {
                this.step = step;
                this.isAscending = !range.isReverse();
            }
        }

        @Override
        public boolean hasNext() {
            this.fetchNextIfNeeded();
            return this.next != null && (this.isAscending ? (this.range.inclusive ? ScriptBytecodeAdapter.compareLessThanEqual(this.next, this.range.getTo()) : ScriptBytecodeAdapter.compareLessThan(this.next, this.range.getTo())) : (this.range.inclusive ? ScriptBytecodeAdapter.compareGreaterThanEqual(this.next, this.range.getFrom()) : ScriptBytecodeAdapter.compareGreaterThan(this.next, this.range.getFrom())));
        }

        @Override
        public Comparable next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.fetchNextIfNeeded();
            this.isNextFetched = false;
            return this.next;
        }

        private void fetchNextIfNeeded() {
            if (!this.isNextFetched) {
                this.isNextFetched = true;
                this.next = this.next == null ? (this.isAscending ? this.range.getFrom() : this.range.getTo()) : (this.isAscending ? NumberRange.this.increment(this.next, this.step) : NumberRange.this.decrement(this.next, this.step));
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

