/*
 * Decompiled with CFR 0.152.
 */
package org.grails.plugins.core;

import grails.config.ConfigProperties;
import grails.core.GrailsApplication;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.event.ApplicationEventListener;
import io.micronaut.context.event.ShutdownEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;

@Factory
public class CoreConfiguration
implements ApplicationEventListener<ShutdownEvent> {
    private final GrailsApplication grailsApplication;
    private ConfigurableApplicationContext childContext;

    public CoreConfiguration(GrailsApplication grailsApplication) {
        this.grailsApplication = grailsApplication;
    }

    @Bean(value={"classLoader"})
    @Primary
    ClassLoader classLoader() {
        return this.grailsApplication.getClassLoader();
    }

    @Bean(value={"grailsConfigProperties"})
    @Primary
    ConfigProperties configProperties() {
        return new ConfigProperties(this.grailsApplication.getConfig());
    }

    public void setChildContext(ConfigurableApplicationContext childContext) {
        this.childContext = childContext;
    }

    public ConfigurableApplicationContext getChildContext() {
        return this.childContext;
    }

    public void onApplicationEvent(ShutdownEvent event) {
        if (this.childContext != null) {
            this.childContext.close();
        }
    }
}

