/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.liquibase;

import java.io.IOException;
import liquibase.servicelocator.DefaultPackageScanClassResolver;
import org.apache.commons.logging.Log;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.util.ClassUtils;

public class SpringPackageScanClassResolver
extends DefaultPackageScanClassResolver {
    private final Log logger;

    public SpringPackageScanClassResolver(Log logger) {
        this.logger = logger;
    }

    protected void findAllClasses(String packageName, ClassLoader loader) {
        CachingMetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory(loader);
        try {
            Resource[] resources;
            for (Resource resource : resources = this.scan(loader, packageName)) {
                Class<?> clazz = this.loadClass(loader, (MetadataReaderFactory)metadataReaderFactory, resource);
                if (clazz == null) continue;
                this.addFoundClass(clazz);
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private Resource[] scan(ClassLoader loader, String packageName) throws IOException {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(loader);
        String pattern = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)packageName) + "/**/*.class";
        return resolver.getResources(pattern);
    }

    private Class<?> loadClass(ClassLoader loader, MetadataReaderFactory readerFactory, Resource resource) {
        try {
            MetadataReader reader = readerFactory.getMetadataReader(resource);
            return ClassUtils.forName((String)reader.getClassMetadata().getClassName(), (ClassLoader)loader);
        }
        catch (ClassNotFoundException | LinkageError ex) {
            this.handleFailure(resource, ex);
            return null;
        }
        catch (Throwable ex) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("Unexpected failure when loading class resource " + resource), ex);
            }
            return null;
        }
    }

    private void handleFailure(Resource resource, Throwable ex) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Ignoring candidate class resource " + resource + " due to " + ex));
        }
    }
}

