/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.obr.xml;

import java.text.ParseException;
import org.apache.ivy.osgi.core.BundleInfo;
import org.apache.ivy.osgi.core.BundleRequirement;
import org.apache.ivy.osgi.filter.AndFilter;
import org.apache.ivy.osgi.filter.CompareFilter;
import org.apache.ivy.osgi.filter.NotFilter;
import org.apache.ivy.osgi.filter.OSGiFilter;
import org.apache.ivy.osgi.obr.xml.Requirement;
import org.apache.ivy.osgi.obr.xml.UnsupportedFilterException;
import org.apache.ivy.osgi.util.Version;
import org.apache.ivy.osgi.util.VersionRange;

public class RequirementAdapter {
    private Version startVersion = null;
    private boolean startExclusive = false;
    private Version endVersion = null;
    private boolean endExclusive = false;
    private String type = null;
    private String name = null;

    public static void adapt(BundleInfo info, Requirement requirement) throws UnsupportedFilterException, ParseException {
        RequirementAdapter adapter = new RequirementAdapter();
        adapter.extractFilter(requirement.getFilter());
        adapter.adapt(info, requirement.isOptional());
    }

    private void extractFilter(OSGiFilter filter) throws UnsupportedFilterException, ParseException {
        if (filter instanceof AndFilter) {
            AndFilter andFilter = (AndFilter)filter;
            for (OSGiFilter subFilter : andFilter.getSubFilters()) {
                this.extractFilter(subFilter);
            }
        } else if (filter instanceof CompareFilter) {
            CompareFilter compareFilter = (CompareFilter)filter;
            this.parseCompareFilter(compareFilter, false);
        } else if (filter instanceof NotFilter) {
            NotFilter notFilter = (NotFilter)filter;
            if (notFilter.getSubFilter() instanceof CompareFilter) {
                CompareFilter compareFilter = (CompareFilter)notFilter.getSubFilter();
                this.parseCompareFilter(compareFilter, true);
            }
        } else {
            throw new UnsupportedFilterException("Unsupported filter: " + filter.getClass().getName());
        }
    }

    private void adapt(BundleInfo info, boolean optional) throws ParseException {
        String resolution;
        VersionRange range = this.getVersionRange();
        String string = resolution = optional ? "optional" : null;
        if (this.type == null) {
            throw new ParseException("No requirement actually specified", 0);
        }
        BundleRequirement requirement = new BundleRequirement(this.type, this.name, range, resolution);
        info.addRequirement(requirement);
        if ("ee".equals(this.type)) {
            info.addExecutionEnvironment(this.name);
        }
    }

    private VersionRange getVersionRange() {
        VersionRange range = null;
        if (this.startVersion != null || this.endVersion != null) {
            range = new VersionRange(this.startExclusive, this.startVersion, this.endExclusive, this.endVersion);
        }
        return range;
    }

    private void parseCompareFilter(CompareFilter compareFilter, boolean not) throws UnsupportedFilterException, ParseException {
        String att = compareFilter.getLeftValue();
        if ("package".equals(att) || "bundle".equals(att) || "ee".equals(att) || "symbolicname".equals(att) || "service".equals(att)) {
            if (not) {
                throw new UnsupportedFilterException("Not filter on requirement comparaison is not supported");
            }
            if (this.type != null) {
                throw new UnsupportedFilterException("Multiple requirement type are not supported");
            }
            this.type = "symbolicname".equals(att) ? "bundle" : att;
            if (compareFilter.getOperator() != CompareFilter.Operator.EQUALS) {
                throw new UnsupportedFilterException("Filtering is only supported with the operator '='");
            }
            this.name = compareFilter.getRightValue();
        } else if ("version".equals(att)) {
            Version version;
            String v = compareFilter.getRightValue();
            try {
                version = new Version(v);
            }
            catch (ParseException e) {
                throw new ParseException("Ill formed version: " + v, 0);
            }
            CompareFilter.Operator operator = compareFilter.getOperator();
            if (not) {
                if (operator == CompareFilter.Operator.EQUALS) {
                    throw new UnsupportedFilterException("Not filter on equals comparaison is not supported");
                }
                if (operator == CompareFilter.Operator.GREATER_OR_EQUAL) {
                    operator = CompareFilter.Operator.LOWER_THAN;
                } else if (operator == CompareFilter.Operator.GREATER_THAN) {
                    operator = CompareFilter.Operator.LOWER_OR_EQUAL;
                } else if (operator == CompareFilter.Operator.LOWER_OR_EQUAL) {
                    operator = CompareFilter.Operator.GREATER_THAN;
                } else if (operator == CompareFilter.Operator.LOWER_THAN) {
                    operator = CompareFilter.Operator.GREATER_OR_EQUAL;
                }
            }
            if (operator == CompareFilter.Operator.EQUALS) {
                if (this.startVersion != null || this.endVersion != null) {
                    throw new UnsupportedFilterException("Multiple version matching is not supported");
                }
                this.startVersion = version;
                this.startExclusive = false;
                this.endVersion = version;
                this.endExclusive = false;
            } else if (operator == CompareFilter.Operator.GREATER_OR_EQUAL) {
                if (this.startVersion != null) {
                    throw new UnsupportedFilterException("Multiple version matching is not supported");
                }
                this.startVersion = version;
                this.startExclusive = false;
            } else if (operator == CompareFilter.Operator.GREATER_THAN) {
                if (this.startVersion != null) {
                    throw new UnsupportedFilterException("Multiple version matching is not supported");
                }
                this.startVersion = version;
                this.startExclusive = true;
            } else if (operator == CompareFilter.Operator.LOWER_OR_EQUAL) {
                if (this.endVersion != null) {
                    throw new UnsupportedFilterException("Multiple version matching is not supported");
                }
                this.endVersion = version;
                this.endExclusive = false;
            } else if (operator == CompareFilter.Operator.LOWER_THAN) {
                if (this.endVersion != null) {
                    throw new UnsupportedFilterException("Multiple version matching is not supported");
                }
                this.endVersion = version;
                this.endExclusive = true;
            }
        } else {
            throw new UnsupportedFilterException("Unsupported attribute: " + att);
        }
    }
}

