/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.extension;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.io.TempDir;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.ReflectionUtils;

class TempDirectory
implements BeforeAllCallback,
BeforeEachCallback,
ParameterResolver {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{TempDirectory.class});
    private static final String KEY = "temp.dir";
    private static final String TEMP_DIR_PREFIX = "junit";

    TempDirectory() {
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        this.injectFields(context, null, ReflectionUtils::isStatic);
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.injectFields(context, context.getRequiredTestInstance(), ReflectionUtils::isNotStatic);
    }

    private void injectFields(ExtensionContext context, Object testInstance, Predicate<Field> predicate) {
        AnnotationUtils.findAnnotatedFields((Class)context.getRequiredTestClass(), TempDir.class, predicate).forEach(field -> {
            this.assertValidFieldCandidate((Field)field);
            try {
                ((Field)ReflectionUtils.makeAccessible((AccessibleObject)field)).set(testInstance, this.getPathOrFile(field.getType(), context));
            }
            catch (Throwable t) {
                ExceptionUtils.throwAsUncheckedException((Throwable)t);
            }
        });
    }

    private void assertValidFieldCandidate(Field field) {
        this.assertSupportedType("field", field.getType());
        if (ReflectionUtils.isPrivate((Member)field)) {
            throw new ExtensionConfigurationException("@TempDir field [" + field + "] must not be private.");
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        boolean annotated = parameterContext.isAnnotated(TempDir.class);
        if (annotated && parameterContext.getDeclaringExecutable() instanceof Constructor) {
            throw new ParameterResolutionException("@TempDir is not supported on constructor parameters. Please use field injection instead.");
        }
        return annotated;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Class<?> parameterType = parameterContext.getParameter().getType();
        this.assertSupportedType("parameter", parameterType);
        return this.getPathOrFile(parameterType, extensionContext);
    }

    private void assertSupportedType(String target, Class<?> type) {
        if (type != Path.class && type != File.class) {
            throw new ExtensionConfigurationException("Can only resolve @TempDir " + target + " of type " + Path.class.getName() + " or " + File.class.getName() + " but was: " + type.getName());
        }
    }

    private Object getPathOrFile(Class<?> type, ExtensionContext extensionContext) {
        Path path = ((CloseablePath)extensionContext.getStore(NAMESPACE).getOrComputeIfAbsent((Object)KEY, key -> TempDirectory.createTempDir(), CloseablePath.class)).get();
        return type == Path.class ? path : path.toFile();
    }

    private static CloseablePath createTempDir() {
        try {
            return new CloseablePath(Files.createTempDirectory(TEMP_DIR_PREFIX, new FileAttribute[0]));
        }
        catch (Exception ex) {
            throw new ExtensionConfigurationException("Failed to create default temp directory", (Throwable)ex);
        }
    }

    private static class CloseablePath
    implements ExtensionContext.Store.CloseableResource {
        private final Path dir;

        CloseablePath(Path dir) {
            this.dir = dir;
        }

        Path get() {
            return this.dir;
        }

        public void close() throws IOException {
            SortedMap<Path, IOException> failures = this.deleteAllFilesAndDirectories();
            if (!failures.isEmpty()) {
                throw this.createIOExceptionWithAttachedFailures(failures);
            }
        }

        private SortedMap<Path, IOException> deleteAllFilesAndDirectories() throws IOException {
            final TreeMap<Path, IOException> failures = new TreeMap<Path, IOException>();
            Files.walkFileTree(this.dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) {
                    return this.deleteAndContinue(file);
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    return this.deleteAndContinue(dir);
                }

                private FileVisitResult deleteAndContinue(Path path) {
                    try {
                        Files.delete(path);
                    }
                    catch (IOException ex) {
                        failures.put(path, ex);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            return failures;
        }

        private IOException createIOExceptionWithAttachedFailures(SortedMap<Path, IOException> failures) {
            String joinedPaths = failures.keySet().stream().peek(this::tryToDeleteOnExit).map(this::relativizeSafely).map(String::valueOf).collect(Collectors.joining(", "));
            IOException exception = new IOException("Failed to delete temp directory " + this.dir.toAbsolutePath() + ". The following paths could not be deleted (see suppressed exceptions for details): " + joinedPaths);
            failures.values().forEach(exception::addSuppressed);
            return exception;
        }

        private void tryToDeleteOnExit(Path path) {
            try {
                path.toFile().deleteOnExit();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }

        private Path relativizeSafely(Path path) {
            try {
                return this.dir.relativize(path);
            }
            catch (IllegalArgumentException e) {
                return path;
            }
        }
    }
}

