/*
 * Decompiled with CFR 0.152.
 */
package org.GNOME.Accessibility;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.lang.ref.WeakReference;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleExtendedComponent;
import javax.accessibility.AccessibleKeyBinding;
import javax.swing.KeyStroke;
import org.GNOME.Accessibility.AtkUtil;

public class AtkAction {
    WeakReference<AccessibleContext> _ac;
    WeakReference<AccessibleAction> _acc_action;
    WeakReference<AccessibleExtendedComponent> _acc_ext_component;
    String[] descriptions;
    int nactions;

    public AtkAction(AccessibleContext accessibleContext) {
        this._ac = new WeakReference<AccessibleContext>(accessibleContext);
        AccessibleAction accessibleAction = accessibleContext.getAccessibleAction();
        this._acc_action = new WeakReference<AccessibleAction>(accessibleAction);
        this.nactions = accessibleAction.getAccessibleActionCount();
        this.descriptions = new String[this.nactions];
        AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
        if (accessibleComponent instanceof AccessibleExtendedComponent) {
            this._acc_ext_component = new WeakReference<AccessibleExtendedComponent>((AccessibleExtendedComponent)accessibleComponent);
        }
    }

    public static AtkAction createAtkAction(AccessibleContext accessibleContext) {
        return AtkUtil.invokeInSwing(() -> new AtkAction(accessibleContext), null);
    }

    public boolean do_action(int n) {
        AccessibleAction accessibleAction = (AccessibleAction)this._acc_action.get();
        if (accessibleAction == null) {
            return false;
        }
        AtkUtil.invokeInSwing(() -> accessibleAction.doAccessibleAction(n));
        return true;
    }

    public int get_n_actions() {
        return this.nactions;
    }

    public String get_description(int n) {
        AccessibleAction accessibleAction = (AccessibleAction)this._acc_action.get();
        if (accessibleAction == null) {
            return null;
        }
        if (n >= this.nactions) {
            return null;
        }
        if (this.descriptions[n] != null) {
            return this.descriptions[n];
        }
        this.descriptions[n] = AtkUtil.invokeInSwing(() -> accessibleAction.getAccessibleActionDescription(n), "");
        return this.descriptions[n];
    }

    public boolean setDescription(int n, String string) {
        if (n >= this.nactions) {
            return false;
        }
        this.descriptions[n] = string;
        return true;
    }

    public String getLocalizedName(int n) {
        AccessibleContext accessibleContext = (AccessibleContext)this._ac.get();
        if (accessibleContext == null) {
            return null;
        }
        AccessibleAction accessibleAction = (AccessibleAction)this._acc_action.get();
        if (accessibleAction == null) {
            return null;
        }
        if (n >= this.nactions) {
            return null;
        }
        if (this.descriptions[n] != null) {
            return this.descriptions[n];
        }
        return AtkUtil.invokeInSwing(() -> {
            this.descriptions[n] = accessibleAction.getAccessibleActionDescription(n);
            if (this.descriptions[n] != null) {
                return this.descriptions[n];
            }
            String string = accessibleContext.getAccessibleName();
            if (string != null) {
                return string;
            }
            this.descriptions[n] = "";
            return this.descriptions[n];
        }, null);
    }

    private String convertModString(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        String[] stringArray = string.split("\\+");
        String string2 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = string2 + "<" + stringArray[i] + ">";
        }
        return string2;
    }

    public String get_keybinding(int n) {
        AccessibleKeyBinding accessibleKeyBinding;
        AccessibleExtendedComponent accessibleExtendedComponent = (AccessibleExtendedComponent)this._acc_ext_component.get();
        if (this._acc_ext_component == null) {
            return "";
        }
        if (n > 0) {
            return "";
        }
        if (accessibleExtendedComponent != null && (accessibleKeyBinding = accessibleExtendedComponent.getAccessibleKeyBinding()) != null && accessibleKeyBinding.getAccessibleKeyBindingCount() > 0) {
            int n2;
            String string = "";
            for (n2 = 0; n2 < accessibleKeyBinding.getAccessibleKeyBindingCount() && n2 < 3; ++n2) {
                String string2;
                KeyStroke[] keyStrokeArray;
                Object object = accessibleKeyBinding.getAccessibleKeyBinding(n2);
                if (n2 > 0) {
                    string = string + ";";
                }
                if (object instanceof KeyStroke) {
                    keyStrokeArray = (KeyStroke[])object;
                    String string3 = InputEvent.getModifiersExText(keyStrokeArray.getModifiers());
                    string2 = KeyEvent.getKeyText(keyStrokeArray.getKeyCode());
                    if (string2 == null) continue;
                    if (string3 != null && string3.length() > 0) {
                        string = string + this.convertModString(string3) + string2;
                        continue;
                    }
                    string = string + string2;
                    continue;
                }
                if (!(object instanceof KeyStroke[])) continue;
                keyStrokeArray = (KeyStroke[])object;
                for (int i = 0; i < keyStrokeArray.length; ++i) {
                    string2 = InputEvent.getModifiersExText(keyStrokeArray[i].getModifiers());
                    String string4 = KeyEvent.getKeyText(keyStrokeArray[i].getKeyCode());
                    if (i > 0) {
                        string = string + ":";
                    }
                    if (string4 == null) continue;
                    string = string2 != null && string2.length() > 0 ? string + this.convertModString(string2) + string4 : string + string4;
                }
            }
            if (n2 < 2) {
                string = string + ";";
            }
            if (n2 < 3) {
                string = string + ";";
            }
            return string;
        }
        return "";
    }
}

