/*
 * Decompiled with CFR 0.152.
 */
package org.GNOME.Accessibility;

import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleExtendedTable;
import javax.accessibility.AccessibleHypertext;
import javax.accessibility.AccessibleRelation;
import javax.accessibility.AccessibleRelationSet;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleTable;
import javax.accessibility.AccessibleText;
import org.GNOME.Accessibility.AtkUtil;

public class AtkObject {
    public static final int INTERFACE_ACTION = 1;
    public static final int INTERFACE_COMPONENT = 2;
    public static final int INTERFACE_DOCUMENT = 4;
    public static final int INTERFACE_EDITABLE_TEXT = 8;
    public static final int INTERFACE_HYPERLINK = 16;
    public static final int INTERFACE_HYPERTEXT = 32;
    public static final int INTERFACE_IMAGE = 64;
    public static final int INTERFACE_SELECTION = 128;
    public static final int INTERFACE_STREAMABLE_CONTENT = 256;
    public static final int INTERFACE_TABLE = 512;
    public static final int INTERFACE_TABLE_CELL = 1024;
    public static final int INTERFACE_TEXT = 2048;
    public static final int INTERFACE_VALUE = 4096;

    public static int getTFlagFromObj(Object object) {
        return AtkUtil.invokeInSwing(() -> {
            AccessibleContext accessibleContext;
            Accessible accessible;
            AccessibleTable accessibleTable;
            AccessibleText accessibleText;
            AccessibleContext accessibleContext2;
            int n = 0;
            if (object instanceof AccessibleContext) {
                accessibleContext2 = (AccessibleContext)object;
            } else if (object instanceof Accessible) {
                accessibleContext2 = ((Accessible)object).getAccessibleContext();
            } else {
                return n;
            }
            if (accessibleContext2.getAccessibleAction() != null) {
                n |= 1;
            }
            if (accessibleContext2.getAccessibleComponent() != null) {
                n |= 2;
            }
            if ((accessibleText = accessibleContext2.getAccessibleText()) != null) {
                n |= 0x800;
                if (accessibleText instanceof AccessibleHypertext) {
                    n |= 0x20;
                }
                if (accessibleContext2.getAccessibleEditableText() != null) {
                    n |= 8;
                }
            }
            if (accessibleContext2.getAccessibleIcon() != null) {
                n |= 0x40;
            }
            if (accessibleContext2.getAccessibleSelection() != null) {
                n |= 0x80;
            }
            if ((accessibleTable = accessibleContext2.getAccessibleTable()) != null) {
                n |= 0x200;
            }
            if ((accessible = accessibleContext2.getAccessibleParent()) != null && (accessibleContext = accessible.getAccessibleContext()) != null && (accessibleTable = accessibleContext.getAccessibleTable()) != null && accessibleTable instanceof AccessibleExtendedTable) {
                n |= 0x400;
            }
            if (accessibleContext2.getAccessibleValue() != null) {
                n |= 0x1000;
            }
            return n;
        }, 0);
    }

    public static AccessibleContext getAccessibleParent(AccessibleContext accessibleContext) {
        return AtkUtil.invokeInSwing(() -> {
            Accessible accessible = accessibleContext.getAccessibleParent();
            if (accessible != null) {
                return accessible.getAccessibleContext();
            }
            return null;
        }, null);
    }

    public static void setAccessibleParent(AccessibleContext accessibleContext, AccessibleContext accessibleContext2) {
        AtkUtil.invokeInSwing(() -> {
            if (accessibleContext2 instanceof Accessible) {
                Accessible accessible = (Accessible)((Object)accessibleContext2);
                accessibleContext.setAccessibleParent(accessible);
            }
        });
    }

    public static String getAccessibleName(AccessibleContext accessibleContext) {
        return AtkUtil.invokeInSwing(() -> accessibleContext.getAccessibleName(), "");
    }

    public static void setAccessibleName(AccessibleContext accessibleContext, String string) {
        AtkUtil.invokeInSwing(() -> accessibleContext.setAccessibleName(string));
    }

    public static String getAccessibleDescription(AccessibleContext accessibleContext) {
        return AtkUtil.invokeInSwing(() -> accessibleContext.getAccessibleDescription(), "");
    }

    public static void setAccessibleDescription(AccessibleContext accessibleContext, String string) {
        AtkUtil.invokeInSwing(() -> accessibleContext.setAccessibleDescription(string));
    }

    public static int getAccessibleChildrenCount(AccessibleContext accessibleContext) {
        return AtkUtil.invokeInSwing(() -> accessibleContext.getAccessibleChildrenCount(), 0);
    }

    public static int getAccessibleIndexInParent(AccessibleContext accessibleContext) {
        return AtkUtil.invokeInSwing(() -> accessibleContext.getAccessibleIndexInParent(), -1);
    }

    public static AccessibleRole getAccessibleRole(AccessibleContext accessibleContext) {
        return AtkUtil.invokeInSwing(() -> accessibleContext.getAccessibleRole(), AccessibleRole.UNKNOWN);
    }

    public static boolean equalsIgnoreCaseLocaleWithRole(AccessibleRole accessibleRole) {
        String string = accessibleRole.toDisplayString(Locale.US);
        return string.equalsIgnoreCase("paragraph");
    }

    public static AccessibleState[] getArrayAccessibleState(AccessibleContext accessibleContext) {
        return AtkUtil.invokeInSwing(() -> {
            AccessibleStateSet accessibleStateSet = accessibleContext.getAccessibleStateSet();
            if (accessibleStateSet == null) {
                return null;
            }
            return accessibleStateSet.toArray();
        }, null);
    }

    public static String getLocale(AccessibleContext accessibleContext) {
        return AtkUtil.invokeInSwing(() -> {
            Locale locale = accessibleContext.getLocale();
            String string = locale.getLanguage();
            String string2 = locale.getCountry();
            String string3 = locale.getScript();
            String string4 = locale.getVariant();
            if (string2.length() != 0) {
                string = string + "_" + string2;
            }
            if (string3.length() != 0) {
                string = string + "@" + string3;
            }
            if (string4.length() != 0) {
                string = string + "@" + string4;
            }
            return string;
        }, null);
    }

    public static WrapKeyAndTarget[] getArrayAccessibleRelation(AccessibleContext accessibleContext) {
        WrapKeyAndTarget[] wrapKeyAndTargetArray = new WrapKeyAndTarget[]{};
        return AtkUtil.invokeInSwing(() -> {
            AccessibleRelationSet accessibleRelationSet = accessibleContext.getAccessibleRelationSet();
            if (accessibleRelationSet == null) {
                return wrapKeyAndTargetArray;
            }
            AccessibleRelation[] accessibleRelationArray = accessibleRelationSet.toArray();
            WrapKeyAndTarget[] wrapKeyAndTargetArray2 = new WrapKeyAndTarget[accessibleRelationArray.length];
            for (int i = 0; i < accessibleRelationArray.length; ++i) {
                String string = accessibleRelationArray[i].getKey();
                Object[] objectArray = accessibleRelationArray[i].getTarget();
                AccessibleContext[] accessibleContextArray = new AccessibleContext[objectArray.length];
                for (int j = 0; j < objectArray.length; ++j) {
                    accessibleContextArray[i] = objectArray[i] instanceof Accessible ? ((Accessible)objectArray[i]).getAccessibleContext() : null;
                }
                wrapKeyAndTargetArray2[i] = new WrapKeyAndTarget(string, accessibleContextArray);
            }
            return wrapKeyAndTargetArray2;
        }, wrapKeyAndTargetArray);
    }

    public static AccessibleContext getAccessibleChild(AccessibleContext accessibleContext, int n) {
        return AtkUtil.invokeInSwing(() -> {
            Accessible accessible = accessibleContext.getAccessibleChild(n);
            if (accessible == null) {
                return null;
            }
            return accessible.getAccessibleContext();
        }, null);
    }

    public static int hashCode(AccessibleContext accessibleContext) {
        return AtkUtil.invokeInSwing(() -> accessibleContext.hashCode(), 0);
    }

    public static class WrapKeyAndTarget {
        public String key;
        public AccessibleContext[] relations;

        public WrapKeyAndTarget(String string, AccessibleContext[] accessibleContextArray) {
            this.key = string;
            this.relations = accessibleContextArray;
        }
    }
}

