/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.extensions;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.extensions.ExtensionAttachment;
import org.apache.fop.render.pdf.extensions.PDFActionExtension;
import org.apache.fop.render.pdf.extensions.PDFCatalogExtension;
import org.apache.fop.render.pdf.extensions.PDFCollectionEntryElement;
import org.apache.fop.render.pdf.extensions.PDFCollectionEntryExtension;
import org.apache.fop.render.pdf.extensions.PDFDictionaryAttachment;
import org.apache.fop.render.pdf.extensions.PDFDictionaryExtension;
import org.apache.fop.render.pdf.extensions.PDFDictionaryType;
import org.apache.fop.render.pdf.extensions.PDFDocumentInformationExtension;
import org.apache.fop.render.pdf.extensions.PDFLayerExtension;
import org.apache.fop.render.pdf.extensions.PDFNavigatorExtension;
import org.apache.fop.render.pdf.extensions.PDFObjectType;
import org.apache.fop.render.pdf.extensions.PDFPageExtension;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public class PDFDictionaryElement
extends PDFCollectionEntryElement {
    public static final String ATT_ID = "id";

    PDFDictionaryElement(FONode parent, PDFDictionaryType type) {
        super(parent, PDFObjectType.Dictionary, PDFDictionaryElement.createExtension(type));
    }

    private static PDFDictionaryExtension createExtension(PDFDictionaryType type) {
        if (type == PDFDictionaryType.Action) {
            return new PDFActionExtension();
        }
        if (type == PDFDictionaryType.Catalog) {
            return new PDFCatalogExtension();
        }
        if (type == PDFDictionaryType.Layer) {
            return new PDFLayerExtension();
        }
        if (type == PDFDictionaryType.Navigator) {
            return new PDFNavigatorExtension();
        }
        if (type == PDFDictionaryType.Page) {
            return new PDFPageExtension();
        }
        if (type == PDFDictionaryType.Info) {
            return new PDFDocumentInformationExtension();
        }
        return new PDFDictionaryExtension(type);
    }

    public PDFDictionaryExtension getDictionaryExtension() {
        PDFCollectionEntryExtension extension = this.getExtension();
        assert (extension instanceof PDFDictionaryExtension);
        return (PDFDictionaryExtension)extension;
    }

    @Override
    public void processNode(String elementName, Locator locator, Attributes attlist, PropertyList propertyList) throws FOPException {
        String id;
        PDFDictionaryExtension extension = this.getDictionaryExtension();
        if (extension.usesIDAttribute() && (id = attlist.getValue(ATT_ID)) != null) {
            extension.setProperty(ATT_ID, id);
        }
        if (extension.getDictionaryType() == PDFDictionaryType.Dictionary) {
            String key = attlist.getValue("key");
            if (key == null) {
                if (this.parent instanceof PDFDictionaryElement) {
                    this.missingPropertyError("key");
                }
            } else if (key.length() == 0) {
                this.invalidPropertyValueError("key", key, null);
            } else {
                extension.setKey(key);
            }
        }
    }

    @Override
    public void startOfNode() throws FOPException {
        super.startOfNode();
        String localName = this.getLocalName();
        if (!(localName.equals("action") || localName.equals("catalog") || localName.equals("layer") || localName.equals("navigator") || localName.equals("page") || localName.equals("info") || localName.equals("vt") || localName.equals("pagepiece"))) {
            if (localName.equals("dictionary")) {
                if (!PDFDictionaryType.hasValueOfElementName(this.parent.getLocalName()) && !PDFObjectType.Array.elementName().equals(this.parent.getLocalName())) {
                    this.invalidChildError(this.getLocator(), this.parent.getName(), this.getNamespaceURI(), this.getName(), null);
                }
            } else {
                throw new IllegalStateException("unknown name: " + localName);
            }
        }
    }

    protected void addChildNode(FONode child) throws FOPException {
        PDFDictionaryExtension extension = this.getDictionaryExtension();
        if (child instanceof PDFDictionaryElement) {
            PDFDictionaryExtension entry = ((PDFDictionaryElement)child).getDictionaryExtension();
            if (entry.getDictionaryType() == PDFDictionaryType.Dictionary) {
                extension.addEntry(entry);
            }
        } else if (child instanceof PDFCollectionEntryElement) {
            PDFCollectionEntryExtension entry = ((PDFCollectionEntryElement)child).getExtension();
            extension.addEntry(entry);
        }
    }

    @Override
    public void endOfNode() throws FOPException {
        super.endOfNode();
    }

    @Override
    public String getLocalName() {
        PDFDictionaryExtension extension = this.getDictionaryExtension();
        return extension.getDictionaryType().elementName();
    }

    @Override
    protected ExtensionAttachment instantiateExtensionAttachment() {
        return new PDFDictionaryAttachment(this.getDictionaryExtension());
    }
}

