/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.gui.ColorWellButton;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.syntax.DefaultTokenHandler;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.jedit.syntax.Token;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.util.GenericGUIUtilities;
import org.gjt.sp.util.SyntaxUtilities;

public class StyleEditor
extends EnhancedDialog
implements ActionListener {
    private JCheckBox italics;
    private JCheckBox bold;
    private JCheckBox fgColorCheckBox;
    private ColorWellButton fgColor;
    private JCheckBox bgColorCheckBox;
    private ColorWellButton bgColor;
    private JButton ok;
    private JButton cancel;
    private boolean okClicked;

    public static void invokeForCaret(JEditTextArea jEditTextArea) {
        JEditBuffer jEditBuffer = jEditTextArea.getBuffer();
        int n = jEditTextArea.getCaretLine();
        int n2 = jEditBuffer.getLineStartOffset(n);
        int n3 = jEditTextArea.getCaretPosition();
        DefaultTokenHandler defaultTokenHandler = new DefaultTokenHandler();
        jEditBuffer.markTokens(n, defaultTokenHandler);
        Token token = defaultTokenHandler.getTokens();
        while (token.id != 127) {
            int n4 = n2 + token.length;
            if (n2 <= n3 && n4 > n3) break;
            n2 = n4;
            token = token.next;
        }
        if (token.id == 127 || token.id % 19 == 0) {
            JOptionPane.showMessageDialog(jEditTextArea.getView(), jEdit.getProperty("syntax-style-no-token.message"), jEdit.getProperty("syntax-style-no-token.title"), -1);
            return;
        }
        String string = Token.tokenToString(token.id);
        String string2 = "view.style." + string.toLowerCase();
        Font font = new JLabel().getFont();
        SyntaxStyle syntaxStyle = SyntaxUtilities.parseStyle(jEdit.getProperty(string2), font.getFamily(), font.getSize(), true);
        SyntaxStyle syntaxStyle2 = new StyleEditor(jEditTextArea.getView(), syntaxStyle, string).getStyle();
        if (syntaxStyle2 != null) {
            jEdit.setProperty(string2, GUIUtilities.getStyleString(syntaxStyle2));
            jEdit.propertiesChanged();
        }
    }

    public StyleEditor(JDialog jDialog, SyntaxStyle syntaxStyle, String string) {
        super(jDialog, jEdit.getProperty("style-editor.title"), true);
        this.initialize(jDialog, syntaxStyle, string);
    }

    public StyleEditor(JFrame jFrame, SyntaxStyle syntaxStyle, String string) {
        super(jFrame, jEdit.getProperty("style-editor.title"), true);
        this.initialize(jFrame, syntaxStyle, string);
    }

    private void initialize(Component component, SyntaxStyle syntaxStyle, String string) {
        JPanel jPanel = new JPanel(new BorderLayout(12, 12));
        jPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.setContentPane(jPanel);
        JPanel jPanel2 = new JPanel(new GridLayout(5, 2, 12, 12));
        jPanel2.add(new JLabel(jEdit.getProperty("style-editor.tokenType")));
        jPanel2.add(new JLabel(string));
        this.italics = new JCheckBox(jEdit.getProperty("style-editor.italics"));
        this.italics.setSelected(syntaxStyle.getFont().isItalic());
        jPanel2.add(this.italics);
        jPanel2.add(new JLabel());
        this.bold = new JCheckBox(jEdit.getProperty("style-editor.bold"));
        this.bold.setSelected(syntaxStyle.getFont().isBold());
        jPanel2.add(this.bold);
        jPanel2.add(new JLabel());
        Color color = syntaxStyle.getForegroundColor();
        if (color == null) {
            color = jEdit.getActiveView().getForeground();
        }
        this.fgColorCheckBox = new JCheckBox(jEdit.getProperty("style-editor.fgColor"));
        this.fgColorCheckBox.setSelected(color != null);
        this.fgColorCheckBox.addActionListener(this);
        jPanel2.add(this.fgColorCheckBox);
        this.fgColor = new ColorWellButton(color);
        this.fgColor.setEnabled(color != null);
        jPanel2.add(this.fgColor);
        Color color2 = syntaxStyle.getBackgroundColor();
        if (color2 == null) {
            color2 = jEdit.getActiveView().getBackground();
        }
        this.bgColorCheckBox = new JCheckBox(jEdit.getProperty("style-editor.bgColor"));
        this.bgColorCheckBox.setSelected(color2 != null);
        this.bgColorCheckBox.addActionListener(this);
        jPanel2.add(this.bgColorCheckBox);
        this.bgColor = new ColorWellButton(color2);
        this.bgColor.setEnabled(color2 != null);
        jPanel2.add(this.bgColor);
        jPanel.add("Center", jPanel2);
        Box box = new Box(0);
        box.setBorder(BorderFactory.createEmptyBorder(17, 0, 0, 0));
        this.ok = new JButton(jEdit.getProperty("common.ok"));
        this.getRootPane().setDefaultButton(this.ok);
        this.ok.addActionListener(this);
        this.cancel = new JButton(jEdit.getProperty("common.cancel"));
        this.cancel.addActionListener(this);
        GenericGUIUtilities.makeSameSize(this.ok, this.cancel);
        box.add(Box.createGlue());
        box.add(this.ok);
        box.add(Box.createHorizontalStrut(6));
        box.add(this.cancel);
        jPanel.add("South", box);
        this.pack();
        this.setLocationRelativeTo(component);
        this.setResizable(false);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.ok) {
            this.ok();
        } else if (object == this.cancel) {
            this.cancel();
        } else if (object == this.fgColorCheckBox) {
            this.fgColor.setEnabled(this.fgColorCheckBox.isSelected());
        } else if (object == this.bgColorCheckBox) {
            this.bgColor.setEnabled(this.bgColorCheckBox.isSelected());
        }
    }

    @Override
    public void ok() {
        this.okClicked = true;
        this.dispose();
    }

    @Override
    public void cancel() {
        this.dispose();
    }

    public SyntaxStyle getStyle() {
        if (!this.okClicked) {
            return null;
        }
        Color color = this.fgColorCheckBox.isSelected() ? this.fgColor.getSelectedColor() : null;
        Color color2 = this.bgColorCheckBox.isSelected() ? this.bgColor.getSelectedColor() : null;
        Font font = new JLabel().getFont();
        return new SyntaxStyle(color, color2, new Font(font.getFamily(), (this.italics.isSelected() ? 2 : 0) | (this.bold.isSelected() ? 1 : 0), font.getSize()));
    }
}

