/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.pluginmgr.MirrorListHandler;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.ProgressObserver;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class MirrorList {
    private String xml;
    private final List<Mirror> mirrors = new ArrayList<Mirror>();

    public MirrorList(boolean bl, ProgressObserver progressObserver) throws Exception {
        Mirror mirror = new Mirror();
        mirror.id = "NONE";
        mirror.continent = "";
        mirror.country = "";
        mirror.location = "";
        mirror.description = "";
        this.mirrors.add(mirror);
        String string = jEdit.getProperty("plugin-manager.mirror-url");
        MirrorListHandler mirrorListHandler = new MirrorListHandler(this, string);
        if (bl) {
            Log.log(5, this, "Loading mirror list from internet");
            this.downloadXml(string);
        } else {
            Log.log(5, this, "Loading mirror list from cache");
            this.readXml();
        }
        if (this.xml == null) {
            return;
        }
        progressObserver.setValue(1L);
        BufferedReader bufferedReader = new BufferedReader(new StringReader(this.xml));
        InputSource inputSource = new InputSource(bufferedReader);
        inputSource.setSystemId("jedit.jar");
        XMLReader xMLReader = XMLReaderFactory.createXMLReader();
        xMLReader.setContentHandler(mirrorListHandler);
        xMLReader.setDTDHandler(mirrorListHandler);
        xMLReader.setEntityResolver(mirrorListHandler);
        xMLReader.setErrorHandler(mirrorListHandler);
        xMLReader.parse(inputSource);
        progressObserver.setValue(2L);
    }

    public String getXml() {
        return this.xml;
    }

    public List<Mirror> getMirrors() {
        return this.mirrors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readXml() throws IOException {
        String string = jEdit.getSettingsDirectory();
        if (string == null) {
            return;
        }
        File file = new File(MiscUtilities.constructPath(string, "mirrorList.xml"));
        if (!file.exists()) {
            return;
        }
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            IOUtilities.copyStream(null, bufferedInputStream, byteArrayOutputStream, false);
            this.xml = byteArrayOutputStream.toString();
        }
        catch (Throwable throwable) {
            IOUtilities.closeQuietly(bufferedInputStream);
            throw throwable;
        }
        IOUtilities.closeQuietly(bufferedInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadXml(String string) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = new URL(string).openStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            IOUtilities.copyStream(null, inputStream, byteArrayOutputStream, false);
            this.xml = byteArrayOutputStream.toString();
        }
        catch (Throwable throwable) {
            IOUtilities.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtilities.closeQuietly(inputStream);
    }

    void add(Mirror mirror) {
        this.mirrors.add(mirror);
    }

    void finished() {
        Collections.sort(this.mirrors, new MirrorCompare());
    }

    private static class MirrorCompare
    implements Comparator<Mirror> {
        private MirrorCompare() {
        }

        @Override
        public int compare(Mirror mirror, Mirror mirror2) {
            int n = mirror.continent.compareToIgnoreCase(mirror2.continent);
            if (n == 0 && (n = mirror.country.compareToIgnoreCase(mirror2.country)) == 0 && (n = mirror.location.compareToIgnoreCase(mirror2.location)) == 0) {
                return mirror.description.compareToIgnoreCase(mirror2.description);
            }
            return n;
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof MirrorCompare;
        }
    }

    public static class Mirror {
        public static final String NONE = "NONE";
        public String id;
        public String description;
        public String location;
        public String country;
        public String continent;
    }
}

