/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.textarea.TextAreaMouseHandler;

public class GenericGUIUtilities {
    public static String prettifyMenuLabel(String string) {
        int n = string.indexOf(36);
        if (n != -1) {
            string = string.substring(0, n).concat(string.substring(n + 1));
        }
        return string;
    }

    public static void setAutoMnemonic(AbstractButton abstractButton) {
        char c;
        String string = abstractButton.getText();
        int n = string.indexOf(36);
        if (n != -1 && string.length() - n > 1) {
            c = Character.toLowerCase(string.charAt(n + 1));
            string = string.substring(0, n).concat(string.substring(++n));
        } else {
            c = '\u0000';
        }
        if (c != '\u0000') {
            abstractButton.setMnemonic(c);
            abstractButton.setText(string);
        }
    }

    public static void adjustForScreenBounds(Rectangle rectangle) {
        Rectangle rectangle2 = OperatingSystem.getScreenBounds(rectangle);
        if (rectangle.width > rectangle2.width) {
            rectangle.width = rectangle2.width;
        }
        if (rectangle.x < rectangle2.x) {
            rectangle.x = rectangle2.x;
        }
        if (rectangle.x + rectangle.width > rectangle2.x + rectangle2.width) {
            rectangle.x = rectangle2.x + rectangle2.width - rectangle.width;
        }
        if (rectangle.height > rectangle2.height) {
            rectangle.height = rectangle2.height;
        }
        if (rectangle.y < rectangle2.y) {
            rectangle.y = rectangle2.y;
        }
        if (rectangle.y + rectangle.height > rectangle2.y + rectangle2.height) {
            rectangle.y = rectangle2.y + rectangle2.height - rectangle.height;
        }
    }

    public static void requestFocus(final Window window, final Component component) {
        window.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent windowEvent) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        component.requestFocusInWindow();
                    }
                });
                window.removeWindowFocusListener(this);
            }
        });
    }

    public static boolean isPopupTrigger(MouseEvent mouseEvent) {
        return TextAreaMouseHandler.isRightButton(mouseEvent.getModifiers());
    }

    public static boolean isMiddleButton(int n) {
        return TextAreaMouseHandler.isMiddleButton(n);
    }

    public static boolean isRightButton(int n) {
        return TextAreaMouseHandler.isRightButton(n);
    }

    public static Rectangle getScreenBounds() {
        Rectangle rectangle = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        if (graphicsDeviceArray.length > 1) {
            for (GraphicsDevice graphicsDevice : graphicsDeviceArray) {
                for (GraphicsConfiguration graphicsConfiguration : graphicsDevice.getConfigurations()) {
                    rectangle = rectangle.union(graphicsConfiguration.getBounds());
                }
            }
        }
        return rectangle;
    }

    public static void showPopupMenu(JPopupMenu jPopupMenu, Component component, int n, int n2) {
        GenericGUIUtilities.showPopupMenu(jPopupMenu, component, n, n2, true);
    }

    public static void showPopupMenu(JPopupMenu jPopupMenu, Component component, int n, int n2, boolean bl) {
        Component component2;
        int n3 = 0;
        int n4 = 0;
        int n5 = bl ? 1 : 0;
        for (component2 = component; !(component2 instanceof Window) && component2 != null; component2 = component2.getParent()) {
            n3 += component2.getX();
            n4 += component2.getY();
        }
        if (component2 != null) {
            Dimension dimension = jPopupMenu.getPreferredSize();
            Rectangle rectangle = GenericGUIUtilities.getScreenBounds();
            n = n + n3 + dimension.width + component2.getX() > rectangle.width && n + n3 + component2.getX() >= dimension.width ? (bl ? (n -= dimension.width + n5) : component2.getWidth() - dimension.width - n3 + n5) : (n += n5);
            n2 = n2 + n4 + dimension.height + component2.getY() > rectangle.height && n2 + n4 + component2.getY() >= dimension.height ? (bl ? component2.getHeight() - dimension.height - n4 + n5 : -dimension.height - 1) : (n2 += n5);
            jPopupMenu.show(component, n, n2);
        } else {
            jPopupMenu.show(component, n + n5, n2 + n5);
        }
    }

    public static boolean isAncestorOf(Component component, Component component2) {
        while (component2 != null) {
            if (component == component2) {
                return true;
            }
            component2 = component2.getParent();
        }
        return false;
    }

    public static JDialog getParentDialog(Component component) {
        return (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, component);
    }

    public static void setEnabledRecursively(Container container, boolean bl) {
        for (Component component : container.getComponents()) {
            if (component instanceof Container) {
                GenericGUIUtilities.setEnabledRecursively((Container)component, bl);
                continue;
            }
            component.setEnabled(bl);
        }
        container.setEnabled(bl);
    }

    public static void setButtonContentMargin(AbstractButton abstractButton, Insets insets) {
        UIDefaults uIDefaults = new UIDefaults();
        uIDefaults.put("Button.contentMargins", insets);
        uIDefaults.put("ToggleButton.contentMargins", insets);
        abstractButton.putClientProperty("Nimbus.Overrides", uIDefaults);
    }

    public static void makeSameSize(Component ... componentArray) {
        if (componentArray == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        for (Component component : componentArray) {
            if (component == null) continue;
            n = Math.max(n, component.getPreferredSize().width);
            n2 = Math.max(n2, component.getPreferredSize().height);
        }
        Dimension dimension = new Dimension(n, n2);
        for (Component component : componentArray) {
            if (component == null) continue;
            component.setPreferredSize(dimension);
        }
    }

    public static Dimension defaultTableCellSize() {
        JLabel jLabel = new JLabel("miniminiminiminiminiminiminiminiminimini");
        UIDefaults uIDefaults = UIManager.getDefaults();
        Object object = uIDefaults.get("Table.font");
        if (object instanceof Font) {
            jLabel.setFont((Font)object);
        }
        return jLabel.getPreferredSize();
    }

    public static int defaultColumnWidth() {
        return GenericGUIUtilities.defaultTableCellSize().width;
    }

    public static int defaultRowHeight() {
        return GenericGUIUtilities.defaultTableCellSize().height;
    }
}

