/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;

public class QuickNotepadToolPanel
extends JPanel {
    private QuickNotepad pad;
    private JLabel label;

    public QuickNotepadToolPanel(QuickNotepad qnpad) {
        this.setLayout(new BoxLayout(this, 0));
        this.pad = qnpad;
        Box labelBox = new Box(1);
        labelBox.add(Box.createGlue());
        this.label = new JLabel(this.pad.getFilename());
        this.label.setVisible(jEdit.getProperty((String)"options.quicknotepad.show-filepath").equals("true"));
        labelBox.add(this.label);
        labelBox.add(Box.createGlue());
        this.add(labelBox);
        this.add(Box.createGlue());
        this.add(this.makeCustomButton("quicknotepad.choose-file", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QuickNotepadToolPanel.this.pad.chooseFile();
            }
        }));
        this.add(this.makeCustomButton("quicknotepad.save-file", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QuickNotepadToolPanel.this.pad.saveFile();
            }
        }));
        this.add(this.makeCustomButton("quicknotepad.copy-to-buffer", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QuickNotepadToolPanel.this.pad.copyToBuffer();
            }
        }));
    }

    void propertiesChanged() {
        this.label.setText(this.pad.getFilename());
        this.label.setVisible(jEdit.getProperty((String)"options.quicknotepad.show-filepath").equals("true"));
    }

    private AbstractButton makeCustomButton(String name, ActionListener listener) {
        String toolTip = jEdit.getProperty((String)name.concat(".label"));
        RolloverButton b = new RolloverButton(GUIUtilities.loadIcon((String)jEdit.getProperty((String)(name + ".icon"))));
        if (listener != null) {
            b.addActionListener(listener);
            b.setEnabled(true);
        } else {
            b.setEnabled(false);
        }
        b.setToolTipText(toolTip);
        return b;
    }
}

