/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M4;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.V3;
import org.jmol.api.AtomIndexIterator;
import org.jmol.api.Interface;
import org.jmol.api.SmilesMatcherInterface;
import org.jmol.api.SymmetryInterface;
import org.jmol.c.PAL;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.script.SV;
import org.jmol.shape.AtomShape;
import org.jmol.shapespecial.Polyhedron;
import org.jmol.util.BSUtil;
import org.jmol.util.C;
import org.jmol.util.Logger;
import org.jmol.util.MeshCapper;
import org.jmol.util.Normix;

public class Polyhedra
extends AtomShape
implements Comparator<Object[]> {
    private static final float DEFAULT_FACECENTEROFFSET = 0.25f;
    private static final int EDGES_NONE = 0;
    public static final int EDGES_ALL = 1;
    public static final int EDGES_FRONT = 2;
    public static final int EDGES_ONLY = 3;
    private static final int MAX_VERTICES = 250;
    private static final int FACE_COUNT_MAX = 247;
    private static final int MAX_OTHER = 498;
    private P3[] otherAtoms = new P3[498];
    private V3[] normalsT = new V3[251];
    private int[][] planesT = AU.newInt2(250);
    private static final P3 randomPoint = P3.new3(3141.0f, 2718.0f, 1414.0f);
    private static final int MODE_BONDING = 1;
    private static final int MODE_POINTS = 2;
    private static final int MODE_RADIUS = 3;
    private static final int MODE_BITSET = 4;
    private static final int MODE_UNITCELL = 5;
    private static final int MODE_INFO = 6;
    private static final float DEFAULT_PLANAR_PARAM = 0.98f;
    private static final float CONVEX_HULL_MAX = 0.05f;
    public int polyhedronCount;
    public Polyhedron[] polyhedrons = new Polyhedron[32];
    public int drawEdges;
    private float radius;
    private float radiusMin;
    private float pointScale;
    private int nVertices;
    float faceCenterOffset;
    boolean isCollapsed;
    boolean isFull;
    private boolean iHaveCenterBitSet;
    private boolean bondedOnly;
    private boolean haveBitSetVertices;
    private BS centers;
    private String thisID;
    private P3 center;
    private BS bsVertices;
    private BS bsVertexCount;
    private boolean useUnitCell;
    private int nPoints;
    private float planarParam;
    private Map<String, Object> info;
    private float distanceRef;
    private int modelIndex;
    private boolean isAuto;
    private int[][] explicitFaces;
    private BS bsPolys = new BS();
    private final V3 vAB = new V3();
    private final V3 vAC = new V3();
    private final V3 vBC = new V3();
    private static float MAX_DISTANCE_TO_PLANE = 0.1f;

    @Override
    public int compare(Object[] a, Object[] b) {
        float db;
        float da = a[0] == null ? Float.MAX_VALUE : ((Float)a[0]).floatValue();
        float f = db = b[0] == null ? Float.MAX_VALUE : ((Float)b[0]).floatValue();
        return da < db ? -1 : (da > db ? 1 : 0);
    }

    @Override
    public void setProperty(String propertyName, Object value, BS bs) {
        if (this.thisID != null) {
            bs = new BS();
        }
        if ("init" == propertyName) {
            this.faceCenterOffset = 0.25f;
            this.planarParam = Float.NaN;
            this.pointScale = 0.0f;
            this.radiusMin = 0.0f;
            this.radius = 0.0f;
            this.nPoints = 0;
            this.nVertices = 0;
            this.modelIndex = -1;
            this.bsVertices = null;
            this.thisID = null;
            this.center = null;
            this.centers = null;
            this.info = null;
            this.bsVertexCount = new BS();
            this.haveBitSetVertices = false;
            this.isAuto = false;
            this.useUnitCell = false;
            this.iHaveCenterBitSet = false;
            this.isFull = false;
            this.isCollapsed = false;
            this.bondedOnly = false;
            if (Boolean.TRUE == value) {
                this.drawEdges = 0;
            }
            return;
        }
        if ("definedFaces" == propertyName) {
            this.setDefinedFaces((P3[])((Object[])value)[1], (int[][])((Object[])value)[0]);
            return;
        }
        if ("generate" == propertyName) {
            if (!this.iHaveCenterBitSet && bs != null && !bs.isEmpty()) {
                this.centers = bs;
                this.iHaveCenterBitSet = true;
            }
            this.deletePolyhedra();
            this.buildPolyhedra();
            return;
        }
        if ("thisID" == propertyName) {
            this.thisID = (String)value;
            return;
        }
        if ("center" == propertyName) {
            this.center = (P3)value;
            return;
        }
        if ("offset" == propertyName) {
            if (this.thisID != null) {
                this.offsetPolyhedra((P3)value);
            }
            return;
        }
        if ("scale" == propertyName) {
            if (this.thisID != null) {
                this.scalePolyhedra(((Float)value).floatValue());
            }
            return;
        }
        if ("model" == propertyName) {
            this.modelIndex = (Integer)value;
            return;
        }
        if ("collapsed" == propertyName) {
            this.isCollapsed = true;
            return;
        }
        if ("full" == propertyName) {
            this.isFull = true;
            return;
        }
        if ("nVertices" == propertyName) {
            int n = (Integer)value;
            if (n < 0) {
                if (-n >= this.nVertices) {
                    this.bsVertexCount.setBits(this.nVertices, 1 - n);
                    this.nVertices = -n;
                }
            } else {
                this.nVertices = n;
                this.bsVertexCount.set(this.nVertices);
            }
            return;
        }
        if ("centers" == propertyName) {
            this.centers = (BS)value;
            this.iHaveCenterBitSet = true;
            return;
        }
        if ("unitCell" == propertyName) {
            this.useUnitCell = true;
            return;
        }
        if ("to" == propertyName) {
            this.bsVertices = (BS)value;
            return;
        }
        if ("toBitSet" == propertyName) {
            this.bsVertices = (BS)value;
            this.haveBitSetVertices = true;
            return;
        }
        if ("toVertices" == propertyName) {
            P3[] points = (P3[])value;
            int i = this.nPoints = Math.min(points.length, 250);
            while (--i >= 0) {
                this.otherAtoms[i] = points[i];
            }
            return;
        }
        if ("faceCenterOffset" == propertyName) {
            this.faceCenterOffset = ((Float)value).floatValue();
            return;
        }
        if ("distanceFactor" == propertyName) {
            return;
        }
        if ("planarParam" == propertyName) {
            this.planarParam = ((Float)value).floatValue();
            return;
        }
        if ("bonds" == propertyName) {
            this.bondedOnly = true;
            return;
        }
        if ("info" == propertyName) {
            this.info = (Map)value;
            this.centers = this.info.containsKey("center") ? null : BSUtil.newAndSetBit(((SV)this.info.get((Object)"atomIndex")).intValue);
            this.iHaveCenterBitSet = this.centers != null;
            return;
        }
        if ("delete" == propertyName) {
            if (!this.iHaveCenterBitSet) {
                this.centers = bs;
            }
            this.deletePolyhedra();
            return;
        }
        if ("on" == propertyName) {
            if (!this.iHaveCenterBitSet) {
                this.centers = bs;
            }
            this.setVisible(true);
            return;
        }
        if ("off" == propertyName) {
            if (!this.iHaveCenterBitSet) {
                this.centers = bs;
            }
            this.setVisible(false);
            return;
        }
        if ("noedges" == propertyName) {
            this.drawEdges = 0;
            return;
        }
        if ("edges" == propertyName) {
            this.drawEdges = 1;
            return;
        }
        if ("edgesOnly" == propertyName) {
            this.drawEdges = 3;
            return;
        }
        if ("frontedges" == propertyName) {
            this.drawEdges = 2;
            return;
        }
        if (propertyName.indexOf("color") == 0) {
            bs = "colorThis" == propertyName && this.iHaveCenterBitSet ? this.centers : this.andBitSet(bs);
            boolean isPhase = "colorPhase" == propertyName;
            Object cvalue = isPhase ? ((Object[])value)[1] : value;
            short colixEdge = isPhase ? C.getColix((Integer)((Object[])value)[0]) : (short)0;
            short colix = C.getColixO(isPhase ? cvalue : value);
            BS bs1 = this.findPolyBS(bs);
            int i = bs1.nextSetBit(0);
            while (i >= 0) {
                Polyhedron p = this.polyhedrons[i];
                if (p.id == null) {
                    p.colixEdge = colixEdge;
                } else {
                    p.colixEdge = colixEdge;
                    p.colix = colix;
                }
                i = bs1.nextSetBit(i + 1);
            }
            if (this.thisID != null) {
                return;
            }
            value = cvalue;
            propertyName = "color";
        }
        if (propertyName.indexOf("translucency") == 0) {
            boolean isTranslucent = value.equals("translucent");
            if (this.thisID != null) {
                BS bs1 = this.findPolyBS(bs);
                int i = bs1.nextSetBit(0);
                while (i >= 0) {
                    Polyhedron p = this.polyhedrons[i];
                    p.colix = C.getColixTranslucent3(p.colix, isTranslucent, this.translucentLevel);
                    if (p.colixEdge != 0) {
                        p.colixEdge = C.getColixTranslucent3(p.colixEdge, isTranslucent, this.translucentLevel);
                    }
                    i = bs1.nextSetBit(i + 1);
                }
                return;
            }
            BS bS = bs = "translucentThis".equals(value) && this.iHaveCenterBitSet ? this.centers : this.andBitSet(bs);
            if (value.equals("translucentThis")) {
                value = "translucent";
            }
        }
        if ("radius" == propertyName) {
            float v = ((Float)value).floatValue();
            if (v <= 0.0f) {
                this.isAuto = true;
                v = v == 0.0f ? 6.0f : -v;
            }
            this.radius = v;
            return;
        }
        if ("radius1" == propertyName) {
            this.radiusMin = this.radius;
            this.radius = ((Float)value).floatValue();
            return;
        }
        if ("points" == propertyName) {
            this.pointScale = ((Float)value).floatValue();
            this.pointsPolyhedra(bs, this.pointScale);
            return;
        }
        if (propertyName == "deleteModelAtoms") {
            int modelIndex = ((int[])((Object[])value)[2])[0];
            int i = this.polyhedronCount;
            while (--i >= 0) {
                Polyhedron p = this.polyhedrons[i];
                p.info = null;
                if (p.modelIndex > modelIndex) {
                    --p.modelIndex;
                    continue;
                }
                if (p.modelIndex != modelIndex) continue;
                --this.polyhedronCount;
                this.polyhedrons = (Polyhedron[])AU.deleteElements(this.polyhedrons, i, 1);
            }
        }
        this.setPropAS(propertyName, value, bs);
    }

    private void setDefinedFaces(P3[] points, int[][] faces) {
        BS bsUsed = new BS();
        int i = faces.length;
        while (--i >= 0) {
            int[] face = faces[i];
            int j = face.length;
            while (--j >= 0) {
                bsUsed.set(face[j]);
            }
        }
        BS bsNot = BSUtil.newBitSet2(0, bsUsed.length());
        bsNot.andNot(bsUsed);
        int nNot = bsNot.cardinality();
        if (nNot > 0) {
            int i2;
            int np = points.length;
            int[] mapOldToNew = new int[np];
            int[] mapNewToOld = new int[np];
            int n = 0;
            for (int i3 = 0; i3 < np; ++i3) {
                if (bsNot.get(i3)) continue;
                mapNewToOld[n] = i3;
                mapOldToNew[i3] = n++;
            }
            P3[] pnew = new P3[n];
            for (i2 = 0; i2 < n; ++i2) {
                pnew[i2] = points[mapNewToOld[i2]];
            }
            points = pnew;
            i2 = faces.length;
            while (--i2 >= 0) {
                int[] face = faces[i2];
                int j = face.length;
                while (--j >= 0) {
                    face[j] = mapOldToNew[face[j]];
                }
            }
        }
        int n = this.nPoints = points.length;
        this.center = new P3();
        this.otherAtoms = new P3[n + 1];
        if (n > 0) {
            this.otherAtoms[n] = this.center;
            for (int i4 = 0; i4 < n; ++i4) {
                this.otherAtoms[i4] = points[i4];
                this.center.add(this.otherAtoms[i4]);
            }
            this.center.scale(1.0f / (float)n);
        }
        this.explicitFaces = faces;
    }

    private void pointsPolyhedra(BS bs, float pointScale) {
        bs = this.findPolyBS(this.thisID == null ? bs : null);
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            this.polyhedrons[i].pointScale = pointScale;
            i = bs.nextSetBit(i + 1);
        }
    }

    private void scalePolyhedra(float scale) {
        BS bs = this.findPolyBS(null);
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            this.polyhedrons[i].scale = scale;
            i = bs.nextSetBit(i + 1);
        }
    }

    private void offsetPolyhedra(P3 value) {
        BS bs = this.findPolyBS(null);
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            this.polyhedrons[i].setOffset(P3.newP(value));
            i = bs.nextSetBit(i + 1);
        }
    }

    @Override
    public int getIndexFromName(String id) {
        if (id != null) {
            int i = this.polyhedronCount;
            while (--i >= 0) {
                if (!id.equalsIgnoreCase(this.polyhedrons[i].id)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public Object getProperty(String property, int i) {
        Map<String, Object> info = this.polyhedrons[i].getInfo(this.vwr, property);
        return property.equalsIgnoreCase("info") ? info : info.get(property);
    }

    @Override
    public boolean getPropertyData(String property, Object[] data) {
        String id;
        int iatom = data[0] instanceof Integer ? (Integer)data[0] : Integer.MIN_VALUE;
        String string = id = data[0] instanceof String ? (String)data[0] : null;
        if (property == "index") {
            int i = this.getIndexFromName(id);
            if (i >= 0) {
                data[1] = i;
            }
            return i >= 0;
        }
        if (property == "checkID") {
            return this.checkID(id);
        }
        if (property == "getAtomsWithin") {
            Polyhedron p = this.findPoly(id, iatom, true);
            if (p == null) {
                return false;
            }
            data[2] = this.getAtomsWithin(p, ((Float)data[1]).floatValue());
            return true;
        }
        if (property == "info") {
            Polyhedron p = this.findPoly(id, iatom, true);
            if (p == null) {
                return false;
            }
            data[1] = p.getInfo(this.vwr, "info");
            return true;
        }
        if (property == "points") {
            Polyhedron p = this.findPoly(id, iatom, false);
            if (p == null) {
                return false;
            }
            data[1] = p.vertices;
            return true;
        }
        if (property == "symmetry") {
            BS bsSelected = (BS)data[2];
            String s = "";
            for (int i = 0; i < this.polyhedronCount; ++i) {
                Polyhedron p = this.polyhedrons[i];
                if (p.id == null ? id != null || bsSelected != null && !bsSelected.get(p.centralAtom.i) : id != null && !PT.isLike(p.id, id)) continue;
                s = s + (i + 1) + "\t" + p.getSymmetry(this.vwr, true) + "\n";
            }
            data[1] = s;
            return true;
        }
        if (property == "move") {
            M4 mat = (M4)data[1];
            if (mat == null) {
                return false;
            }
            BS bsMoved = (BS)data[0];
            BS bs = this.findPolyBS(bsMoved);
            int i = bs.nextSetBit(0);
            while (i >= 0) {
                this.polyhedrons[i].move(mat, bsMoved);
                i = bs.nextSetBit(i + 1);
            }
            return true;
        }
        if (property == "getCenters") {
            int nv;
            SmilesMatcherInterface sm;
            String smiles = (String)data[1];
            BS bsSelected = (BS)data[2];
            SmilesMatcherInterface smilesMatcherInterface = sm = smiles == null ? null : this.vwr.getSmilesMatcher();
            if (sm != null) {
                smiles = sm.cleanSmiles(smiles);
            }
            int n = nv = smiles != null ? PT.countChar(smiles, '*') : iatom;
            if (nv == 0) {
                nv = Integer.MIN_VALUE;
            }
            BS bs = new BS();
            if (smiles == null || sm != null) {
                int i = this.polyhedronCount;
                while (--i >= 0) {
                    Polyhedron p = this.polyhedrons[i];
                    if (p.id != null || nv != (nv > 0 ? p.nVertices : (nv > Integer.MIN_VALUE ? -p.faces.length : nv))) continue;
                    iatom = p.centralAtom.i;
                    if (bsSelected != null && !bsSelected.get(iatom)) continue;
                    if (smiles == null) {
                        bs.set(iatom);
                        continue;
                    }
                    p.getSymmetry(this.vwr, false);
                    String smiles0 = p.polySmiles;
                    try {
                        if (sm.areEqual(smiles, smiles0) <= 0) continue;
                        bs.set(iatom);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            data[1] = bs;
            return true;
        }
        if (property == "allInfo") {
            Lst<Map<String, Object>> info = new Lst<Map<String, Object>>();
            int i = this.polyhedronCount;
            while (--i >= 0) {
                info.addLast(this.polyhedrons[i].getInfo(this.vwr, "info"));
            }
            data[1] = info;
            return true;
        }
        return this.getPropShape(property, data);
    }

    private BS getAtomsWithin(Polyhedron p, float offset) {
        P3 center;
        int[][] faces = p.faces;
        P3[] vertices = p.vertices;
        P3 p3 = center = p.center == null ? p.centralAtom : p.center;
        if (p.planes == null) {
            V3 vNorm = new V3();
            V3 vAB = new V3();
            p.planes = new P4[faces.length];
            int iface = faces.length;
            while (--iface >= 0) {
                P4 plane = p.planes[iface] = new P4();
                Measure.getPlaneThroughPoints(vertices[faces[iface][0]], vertices[faces[iface][1]], vertices[faces[iface][2]], vNorm, vAB, plane);
            }
        }
        float maxDistance = 0.0f;
        int i = p.nVertices;
        while (--i >= 0) {
            float d = vertices[i].distance(center);
            if (!(d > maxDistance)) continue;
            maxDistance = d;
        }
        BS bsAtoms = BSUtil.copy(this.vwr.getAtomsNearPt(maxDistance + offset, center));
        Atom[] atoms = this.vwr.ms.at;
        int i2 = bsAtoms.nextSetBit(0);
        while (i2 >= 0) {
            int f = faces.length;
            while (--f >= 0) {
                System.out.println(Measure.distanceToPlane(p.planes[f], atoms[i2]));
                if (!(Measure.distanceToPlane(p.planes[f], atoms[i2]) > offset + 0.001f)) continue;
                bsAtoms.clear(i2);
                break;
            }
            i2 = bsAtoms.nextSetBit(i2 + 1);
        }
        return bsAtoms;
    }

    private boolean checkID(String thisID) {
        this.thisID = thisID;
        return this.findPolyBS(null).cardinality() > 0;
    }

    private Polyhedron findPoly(String id, int iatom, boolean allowCollapsed) {
        int i = this.polyhedronCount;
        while (--i >= 0) {
            Polyhedron p = this.polyhedrons[i];
            if (!(p.id == null ? p.centralAtom.i == iatom : p.id.equalsIgnoreCase(id))) continue;
            return allowCollapsed || !this.polyhedrons[i].collapsed ? this.polyhedrons[i] : null;
        }
        return null;
    }

    private BS findPolyBS(BS bsCenters) {
        BS bs = this.bsPolys;
        bs.clearAll();
        int i = this.polyhedronCount;
        while (--i >= 0) {
            Polyhedron p = this.polyhedrons[i];
            if (!(p.id == null ? bsCenters != null && bsCenters.get(p.centralAtom.i) : this.isMatch(p.id))) continue;
            bs.set(i);
        }
        return bs;
    }

    private boolean isMatch(String id) {
        return this.thisID != null && PT.isMatch(id.toLowerCase(), this.thisID.toLowerCase(), true, true);
    }

    @Override
    public Object getShapeDetail() {
        Lst<Map<String, Object>> lst = new Lst<Map<String, Object>>();
        for (int i = 0; i < this.polyhedronCount; ++i) {
            lst.addLast(this.polyhedrons[i].getInfo(this.vwr, "info"));
        }
        return lst;
    }

    private BS andBitSet(BS bs) {
        BS bsCenters = new BS();
        int i = this.polyhedronCount;
        while (--i >= 0) {
            Polyhedron p = this.polyhedrons[i];
            if (p.id != null) continue;
            bsCenters.set(p.centralAtom.i);
        }
        bsCenters.and(bs);
        return bsCenters;
    }

    private void deletePolyhedra() {
        int i;
        int newCount = 0;
        byte pid = PAL.pidOf(null);
        BS bs = this.findPolyBS(this.centers);
        for (i = 0; i < this.polyhedronCount; ++i) {
            Polyhedron p = this.polyhedrons[i];
            if (bs.get(i)) {
                if (this.colixes == null || p.id != null) continue;
                this.setColixAndPalette((short)0, pid, p.centralAtom.i);
                continue;
            }
            this.polyhedrons[newCount++] = p;
        }
        for (i = newCount; i < this.polyhedronCount; ++i) {
            this.polyhedrons[i] = null;
        }
        this.polyhedronCount = newCount;
    }

    private void setVisible(boolean visible) {
        BS bs = this.findPolyBS(this.centers);
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            Polyhedron p = this.polyhedrons[i];
            p.visible = visible;
            if (p.centralAtom != null) {
                this.atoms[p.centralAtom.i].setShapeVisibility(this.vf, visible);
            }
            i = bs.nextSetBit(i + 1);
        }
    }

    private void buildPolyhedra() {
        boolean useBondAlgorithm;
        Polyhedron p = null;
        if (this.thisID != null) {
            if (PT.isWild(this.thisID)) {
                return;
            }
            if (this.center != null) {
                if (this.nPoints == 0) {
                    this.setPointsFromBitset();
                }
                p = this.validatePolyhedron(this.center, this.nPoints);
            }
        } else if (this.info != null && this.info.containsKey("id")) {
            Object o = this.info.get("id");
            this.thisID = o instanceof SV ? ((SV)o).asString() : o.toString();
            p = new Polyhedron().setInfo(this.vwr, this.info, this.vwr.ms.at);
        }
        if (p != null) {
            this.addPolyhedron(p);
            return;
        }
        boolean bl = useBondAlgorithm = this.radius == 0.0f || this.bondedOnly;
        int buildMode = this.info != null ? 6 : (this.nPoints > 0 ? 2 : (this.haveBitSetVertices ? 4 : (this.useUnitCell ? 5 : (useBondAlgorithm ? 1 : 3))));
        AtomIndexIterator iter = buildMode == 3 ? this.ms.getSelectedAtomIterator(null, false, false, false, false) : null;
        int i = this.centers.nextSetBit(0);
        while (i >= 0) {
            Atom atom = this.atoms[i];
            p = null;
            switch (buildMode) {
                case 4: {
                    p = this.constructBitSetPolyhedron(atom);
                    break;
                }
                case 5: {
                    p = this.constructUnitCellPolygon(atom, useBondAlgorithm);
                    break;
                }
                case 1: {
                    p = this.constructBondsPolyhedron(atom, 0);
                    break;
                }
                case 3: {
                    this.vwr.setIteratorForAtom(iter, i, this.radius);
                    p = this.constructRadiusPolyhedron(atom, iter);
                    break;
                }
                case 6: {
                    p = new Polyhedron().setInfo(this.vwr, this.info, this.vwr.ms.at);
                    break;
                }
                case 2: {
                    p = this.validatePolyhedron(atom, this.nPoints);
                }
            }
            if (p != null) {
                this.addPolyhedron(p);
            }
            if (this.haveBitSetVertices) break;
            i = this.centers.nextSetBit(i + 1);
        }
        if (iter != null) {
            iter.release();
        }
    }

    private void setPointsFromBitset() {
        if (this.bsVertices != null) {
            int i = this.bsVertices.nextSetBit(0);
            while (i >= 0 && this.nPoints < 250) {
                this.otherAtoms[this.nPoints++] = this.atoms[i];
                i = this.bsVertices.nextSetBit(i + 1);
            }
        }
    }

    private void addPolyhedron(Polyhedron p) {
        if (this.polyhedronCount == this.polyhedrons.length) {
            this.polyhedrons = (Polyhedron[])AU.doubleLength(this.polyhedrons);
        }
        this.polyhedrons[this.polyhedronCount++] = p;
    }

    private Polyhedron constructBondsPolyhedron(Atom atom, int otherAtomCount) {
        this.distanceRef = 0.0f;
        if (otherAtomCount == 0) {
            Bond[] bonds = atom.bonds;
            if (bonds == null) {
                return null;
            }
            float r2 = this.radius * this.radius;
            float r1 = this.radiusMin * this.radiusMin;
            int i = bonds.length;
            while (--i >= 0) {
                float r;
                Bond bond = bonds[i];
                if (!bond.isCovalent()) continue;
                Atom other = bond.getOtherAtom(atom);
                if (this.bsVertices != null && !this.bsVertices.get(other.i) || this.radius > 0.0f && ((r = other.distanceSquared(atom)) > r2 || r < r1)) continue;
                this.otherAtoms[otherAtomCount++] = other;
                if (otherAtomCount < 250) continue;
                return null;
            }
        }
        if (this.isAuto) {
            otherAtomCount = this.setGap(atom, otherAtomCount);
        }
        return otherAtomCount < 3 || this.nVertices > 0 && !this.bsVertexCount.get(otherAtomCount) ? null : this.validatePolyhedron(atom, otherAtomCount);
    }

    private Polyhedron constructUnitCellPolygon(Atom atom, boolean useBondAlgorithm) {
        SymmetryInterface unitcell = this.vwr.ms.getUnitCellForAtom(atom.i);
        if (unitcell == null) {
            return null;
        }
        BS bsAtoms = BSUtil.copy(this.vwr.getModelUndeletedAtomsBitSet(atom.mi));
        if (this.bsVertices != null) {
            bsAtoms.and(this.bsVertices);
        }
        if (bsAtoms.isEmpty()) {
            return null;
        }
        AtomIndexIterator iter = unitcell.getIterator(this.vwr, atom, this.atoms, bsAtoms, useBondAlgorithm ? 5.0f : this.radius);
        if (!useBondAlgorithm) {
            return this.constructRadiusPolyhedron(atom, iter);
        }
        float myBondingRadius = atom.getBondingRadius();
        if (myBondingRadius == 0.0f) {
            return null;
        }
        float bondTolerance = this.vwr.getFloat(0x22000004);
        float minBondDistance = this.radiusMin == 0.0f ? this.vwr.getFloat(570425364) : this.radiusMin;
        float minBondDistance2 = minBondDistance * minBondDistance;
        int otherAtomCount = 0;
        block0: while (iter.hasNext()) {
            P3 pt;
            float distance2;
            Atom other = this.atoms[iter.next()];
            float otherRadius = other.getBondingRadius();
            if (!this.vwr.ms.isBondable(myBondingRadius, otherRadius, distance2 = atom.distanceSquared(pt = iter.getPosition()), minBondDistance2, bondTolerance)) continue;
            for (int i = 0; i < otherAtomCount; ++i) {
                if (this.otherAtoms[i].distanceSquared(pt) < 0.01f) continue block0;
            }
            this.otherAtoms[otherAtomCount++] = pt;
            if (otherAtomCount < 250) continue;
            return null;
        }
        return this.constructBondsPolyhedron(atom, otherAtomCount);
    }

    private Polyhedron constructBitSetPolyhedron(Atom atom) {
        this.bsVertices.clear(atom.i);
        if (this.bsVertices.cardinality() >= 250) {
            return null;
        }
        int otherAtomCount = 0;
        this.distanceRef = 0.0f;
        int i = this.bsVertices.nextSetBit(0);
        while (i >= 0) {
            this.otherAtoms[otherAtomCount++] = this.atoms[i];
            i = this.bsVertices.nextSetBit(i + 1);
        }
        return this.validatePolyhedron(atom, otherAtomCount);
    }

    private Polyhedron constructRadiusPolyhedron(Atom atom, AtomIndexIterator iter) {
        int otherAtomCount = 0;
        this.distanceRef = this.radius;
        float r2 = this.radius * this.radius;
        float r2min = this.radiusMin * this.radiusMin;
        block0: while (iter.hasNext()) {
            Atom other = this.atoms[iter.next()];
            P3 pt = iter.getPosition();
            if (pt == null) {
                pt = other;
                if (this.bsVertices != null && !this.bsVertices.get(other.i)) continue;
            }
            float r = atom.distanceSquared(pt);
            if (other.altloc != atom.altloc && other.altloc != '\u0000' && atom.altloc != '\u0000' || r > r2 || r < r2min) continue;
            if (otherAtomCount == 250) break;
            for (int i = 0; i < otherAtomCount; ++i) {
                if (this.otherAtoms[i].distanceSquared(pt) < 0.01f) continue block0;
            }
            this.otherAtoms[otherAtomCount++] = pt;
        }
        if (this.isAuto) {
            otherAtomCount = this.setGap(atom, otherAtomCount);
        }
        return otherAtomCount < 3 || this.nVertices > 0 && !this.bsVertexCount.get(otherAtomCount) ? null : this.validatePolyhedron(atom, otherAtomCount);
    }

    private int setGap(P3 atom, int otherAtomCount) {
        if (otherAtomCount < 4) {
            return otherAtomCount;
        }
        Object[][] dist = new Object[250][2];
        for (int i = 0; i < otherAtomCount; ++i) {
            P3 p3 = this.otherAtoms[i];
            dist[i][1] = p3;
            dist[i][0] = Float.valueOf(atom.distance(p3));
        }
        Arrays.sort(dist, this);
        float maxGap = 0.0f;
        int iMax = 0;
        int n = otherAtomCount;
        float dlast = ((Float)dist[0][0]).floatValue();
        this.otherAtoms[0] = (P3)dist[0][1];
        for (int i = 1; i < n; ++i) {
            float d = ((Float)dist[i][0]).floatValue();
            float gap = d - dlast;
            this.otherAtoms[i] = (P3)dist[i][1];
            if (Logger.debugging) {
                Logger.info("polyhedron d=" + d + " " + this.otherAtoms[i]);
            }
            if (gap > maxGap) {
                if (Logger.debugging) {
                    Logger.info("polyhedron maxGap=" + gap + " for i=" + i + " d=" + d + " " + this.otherAtoms[i]);
                }
                maxGap = gap;
                iMax = i;
            }
            dlast = d;
        }
        return iMax == 0 ? otherAtomCount : iMax;
    }

    private Polyhedron validatePolyhedron(P3 atomOrPt, int vertexCount) {
        int[][] triangles;
        V3[] normals;
        int[][] faceTriangles;
        P3[] points = this.otherAtoms;
        int[][] faces = this.explicitFaces;
        boolean collapsed = this.isCollapsed;
        int triangleCount = 0;
        BS bsCenterPlanes = new BS();
        if (faces != null) {
            collapsed = false;
            faceTriangles = AU.newInt2(faces.length);
            normals = new V3[faces.length];
            int i = faces.length;
            while (--i >= 0) {
                faces[i] = this.fixExplicitFaceWinding(faces[i], i, points, normals);
            }
            triangles = ((MeshCapper)Interface.getInterface("org.jmol.util.MeshCapper", this.vwr, "script")).set(null).triangulateFaces(faces, points, faceTriangles);
            triangleCount = triangles.length;
        } else {
            int i;
            this.nPoints = vertexCount + 1;
            int ni = vertexCount - 2;
            int nj = vertexCount - 1;
            float planarParam = Float.isNaN(this.planarParam) ? 0.98f : this.planarParam;
            points[vertexCount] = atomOrPt;
            P3 ptAve = P3.newP(atomOrPt);
            for (int i2 = 0; i2 < vertexCount; ++i2) {
                ptAve.add(points[i2]);
            }
            ptAve.scale(1.0f / (float)(vertexCount + 1));
            P3 ptRef = P3.newP(ptAve);
            BS bsThroughCenter = new BS();
            if (this.thisID == null) {
                int pt = 0;
                for (int i3 = 0; i3 < ni; ++i3) {
                    for (int j = i3 + 1; j < nj; ++j) {
                        int k = j + 1;
                        while (k < vertexCount) {
                            if (this.isPlanar(points[i3], points[j], points[k], ptRef)) {
                                bsThroughCenter.set(pt);
                            }
                            ++k;
                            ++pt;
                        }
                    }
                }
            }
            triangles = this.planesT;
            P4 pTemp = new P4();
            V3 nTemp = new V3();
            float offset = this.faceCenterOffset;
            int fmax = 247;
            int vmax = 250;
            BS bsTemp = Normix.newVertexBitSet();
            normals = this.normalsT;
            Hashtable<Integer, Object[]> htNormMap = new Hashtable<Integer, Object[]>();
            Hashtable<String, Object> htEdgeMap = new Hashtable<String, Object>();
            Lst<int[]> lstRejected = this.isFull ? new Lst<int[]>() : null;
            Object[] edgeTest = new Object[3];
            V3 vAC = this.vAC;
            int pt = 0;
            for (i = 0; i < ni; ++i) {
                for (int j = i + 1; j < nj; ++j) {
                    int k = j + 1;
                    while (k < vertexCount) {
                        if (triangleCount >= fmax) {
                            Logger.error("Polyhedron error: maximum face(" + fmax + ") -- reduce RADIUS");
                            return null;
                        }
                        if (this.nPoints >= vmax) {
                            Logger.error("Polyhedron error: maximum vertex count(" + vmax + ") -- reduce RADIUS");
                            return null;
                        }
                        boolean isThroughCenter = bsThroughCenter.get(pt);
                        P3 rpt = isThroughCenter ? randomPoint : ptAve;
                        V3 normal = new V3();
                        boolean isWindingOK = Measure.getNormalFromCenter(rpt, points[i], points[j], points[k], !isThroughCenter, normal, vAC);
                        int[] t = new int[]{isWindingOK ? i : j, isWindingOK ? j : i, k, -7};
                        float err = this.checkFacet(points, vertexCount, t, triangleCount, normal, pTemp, nTemp, vAC, htNormMap, htEdgeMap, planarParam, bsTemp, edgeTest);
                        if (err != 0.0f) {
                            if (this.isFull && err != Float.MAX_VALUE && err < 0.5f) {
                                t[3] = (int)(err * 100.0f);
                                lstRejected.addLast(t);
                            }
                        } else {
                            normals[triangleCount] = normal;
                            triangles[triangleCount] = t;
                            if (isThroughCenter) {
                                bsCenterPlanes.set(triangleCount++);
                            } else if (collapsed) {
                                points[this.nPoints] = new P3();
                                points[this.nPoints].scaleAdd2(offset, normal, atomOrPt);
                                ptRef.setT(points[this.nPoints]);
                                this.addFacet(i, j, k, ptRef, points, normals, triangles, triangleCount++, this.nPoints, isWindingOK, vAC);
                                this.addFacet(k, i, j, ptRef, points, normals, triangles, triangleCount++, this.nPoints, isWindingOK, vAC);
                                this.addFacet(j, k, i, ptRef, points, normals, triangles, triangleCount++, this.nPoints, isWindingOK, vAC);
                                ++this.nPoints;
                            } else {
                                ++triangleCount;
                            }
                        }
                        ++k;
                        ++pt;
                    }
                }
            }
            --this.nPoints;
            if (Logger.debugging) {
                Logger.info("Polyhedron planeCount=" + triangleCount + " nPoints=" + this.nPoints);
                for (i = 0; i < triangleCount; ++i) {
                    Logger.info("Polyhedron " + PT.toJSON("face[" + i + "]", triangles[i]));
                }
            }
            faces = this.getFaces(triangles, triangleCount, htNormMap);
            faceTriangles = this.getFaceTriangles(faces.length, htNormMap, triangleCount);
        }
        return new Polyhedron().set(this.thisID, this.modelIndex, atomOrPt, points, this.nPoints, vertexCount, triangles, triangleCount, faces, faceTriangles, normals, bsCenterPlanes, collapsed, this.distanceRef, this.pointScale);
    }

    private int[] fixExplicitFaceWinding(int[] face, int ipt, P3[] points, V3[] normals) {
        int n = face.length;
        int nlast = n - 2;
        for (int i = 0; i < nlast; ++i) {
            P3 a = points[face[i]];
            P3 b = points[face[(i + 1) % n]];
            P3 c = points[face[(i + 2) % n]];
            if (!(Measure.computeAngleABC(a, b, c, true) < 178.0f)) continue;
            normals[ipt] = new V3();
            if (Measure.getNormalFromCenter(this.center, a, b, c, true, normals[ipt], this.vAC)) break;
            face = AU.arrayCopyRangeRevI(face, 0, -1);
            break;
        }
        return face;
    }

    private int[][] getFaceTriangles(int n, Map<Integer, Object[]> htNormMap, int triangleCount) {
        int[][] faceTriangles = AU.newInt2(n);
        if (triangleCount == n) {
            int i = triangleCount;
            while (--i >= 0) {
                faceTriangles[i] = new int[]{i};
            }
            return faceTriangles;
        }
        int i = 0;
        for (Map.Entry<Integer, Object[]> e : htNormMap.entrySet()) {
            Object[] eo = e.getValue();
            if (eo[2] != null && eo[2] != e.getKey()) continue;
            Lst lst = (Lst)e.getValue()[1];
            n = lst.size();
            int[] a = new int[n];
            int j = n;
            while (--j >= 0) {
                a[j] = (Integer)lst.get(j);
            }
            faceTriangles[i++] = a;
        }
        return faceTriangles;
    }

    private void addFacet(int i, int j, int k, P3 ptRef, P3[] points, V3[] normals, int[][] faces, int planeCount, int nRef, boolean isWindingOK, V3 vTemp) {
        V3 normal = new V3();
        int ii = isWindingOK ? i : j;
        int jj = isWindingOK ? j : i;
        Measure.getNormalFromCenter(points[k], ptRef, points[ii], points[jj], false, normal, vTemp);
        normals[planeCount] = normal;
        faces[planeCount] = new int[]{nRef, ii, jj, -2};
    }

    private float checkFacet(P3[] points, int nPoints, int[] t, int index, V3 norm, P4 pTemp, V3 vNorm, V3 vAC, Map<Integer, Object[]> htNormMap, Map<String, Object> htEdgeMap, float planarParam, BS bsTemp, Object[] edgeTest) {
        int i;
        int i0 = t[0];
        Measure.getPlaneThroughPoints(points[i0], points[t[1]], points[t[2]], vNorm, vAC, pTemp);
        P3 pt = points[i0];
        for (int j = 0; j < nPoints; ++j) {
            if (j == i0) continue;
            vAC.sub2(points[j], pt);
            vAC.normalize();
            float v = vAC.dot(vNorm);
            if (v > 0.05f) {
                return v;
            }
            if (!Logger.debugging) continue;
            Logger.info("checkFacet " + j + " " + v + " " + PT.toJSON(null, t));
        }
        Integer normix = Normix.getNormixV(norm, bsTemp);
        Object[] o = htNormMap.get(normix);
        if (o == null) {
            V3[] norms = Normix.getVertexVectors();
            for (Map.Entry<Integer, Object[]> e : htNormMap.entrySet()) {
                Integer n = e.getKey();
                if (!(norms[n].dot(norm) > planarParam)) continue;
                o = e.getValue();
                o[2] = n;
                htNormMap.put(normix, o);
                break;
            }
            if (o == null) {
                o = new Object[]{new Lst(), new Lst(), normix};
                htNormMap.put(normix, o);
            }
        }
        normix = (Integer)o[2];
        Lst faceEdgeList = (Lst)o[0];
        Lst faceTriList = (Lst)o[1];
        for (i = 0; i < 3; ++i) {
            edgeTest[i] = this.addEdge(faceEdgeList, htEdgeMap, normix, t, i, points);
            if (edgeTest[i] != null) continue;
            return Float.MAX_VALUE;
        }
        for (i = 0; i < 3; ++i) {
            Object oo = edgeTest[i];
            if (oo == Boolean.TRUE) continue;
            Object[] oe = (Object[])oo;
            faceEdgeList.addLast((int[])oe[2]);
            htEdgeMap.put((String)oe[3], oe);
        }
        faceTriList.addLast(index);
        return 0.0f;
    }

    private Object addEdge(Lst<int[]> faceEdgeList, Map<String, Object> htEdgeMap, Integer normix, int[] p1, int i, P3[] points) {
        int pt = p1[i];
        int pt1 = p1[(i + 1) % 3];
        String s1 = "_" + pt1;
        String s = "_" + pt;
        String edge = normix + s + s1;
        if (htEdgeMap.containsKey(edge)) {
            return null;
        }
        String edge0 = normix + s1 + s;
        Object o = htEdgeMap.get(edge0);
        if (o == null) {
            P3 coord2 = points[pt1];
            P3 coord1 = points[pt];
            this.vAB.sub2(coord2, coord1);
            int j = faceEdgeList.size();
            while (--j >= 0) {
                int[] e = (int[])faceEdgeList.get(j);
                P3 c1 = points[e[0]];
                P3 c2 = points[e[1]];
                if (c1 == coord1 || c1 == coord2 || c2 == coord1 || c2 == coord2 || !this.testDiff(c1, c2, coord1, coord2) || !this.testDiff(coord1, coord2, c1, c2)) continue;
                return null;
            }
            return new Object[]{p1, i, new int[]{pt, pt1, 0}, edge};
        }
        int[] p10 = (int[])((Object[])o)[0];
        if (p10 == null) {
            return null;
        }
        int i0 = (Integer)((Object[])o)[1];
        p10[3] = -(-p10[3] ^ 1 << i0);
        p1[3] = -(-p1[3] ^ 1 << i);
        int[] b = (int[])((Object[])o)[2];
        int j = faceEdgeList.size();
        while (--j >= 0) {
            int[] f = (int[])faceEdgeList.get(j);
            if (f[0] != b[0] || f[1] != b[1]) continue;
            f[2] = -1;
            break;
        }
        htEdgeMap.put(edge, new Object[]{null});
        htEdgeMap.put(edge0, new Object[]{null});
        return Boolean.TRUE;
    }

    private boolean testDiff(P3 a1, P3 b1, P3 a2, P3 b2) {
        this.vAB.sub2(b1, a1);
        this.vAC.sub2(a2, a1);
        this.vAC.cross(this.vAC, this.vAB);
        this.vBC.sub2(b2, a1);
        this.vBC.cross(this.vBC, this.vAB);
        return this.vBC.dot(this.vAC) < 0.0f;
    }

    private boolean isPlanar(P3 pt1, P3 pt2, P3 pt3, P3 ptX) {
        V3 norm = new V3();
        float w = Measure.getNormalThroughPoints(pt1, pt2, pt3, norm, this.vAB);
        float d = Measure.distanceToPlaneV(norm, w, ptX);
        return Math.abs(d) < MAX_DISTANCE_TO_PLANE;
    }

    private int[][] getFaces(int[][] triangles, int triangleCount, Map<Integer, Object[]> htNormMap) {
        int n = 0;
        for (Map.Entry<Integer, Object[]> e : htNormMap.entrySet()) {
            Object[] eo = e.getValue();
            if (eo[2] != e.getKey()) continue;
            ++n;
        }
        int[][] faces = AU.newInt2(n);
        if (triangleCount == n) {
            int i = triangleCount;
            while (--i >= 0) {
                faces[i] = AU.arrayCopyI(triangles[i], 3);
            }
            return faces;
        }
        int fpt = 0;
        for (Map.Entry<Integer, Object[]> e : htNormMap.entrySet()) {
            Object[] eo = e.getValue();
            if (eo[2] != null && eo[2] != e.getKey()) continue;
            Lst faceEdgeList = (Lst)e.getValue()[0];
            n = faceEdgeList.size();
            int nOK = 0;
            int i = faceEdgeList.size();
            while (--i >= 0) {
                if (((int[])faceEdgeList.get(i))[2] < 0) continue;
                ++nOK;
            }
            int n2 = fpt++;
            int[] nArray = new int[nOK];
            faces[n2] = nArray;
            int[] face = nArray;
            if (n < 2) continue;
            int[] edge = null;
            int pt = 0;
            do {
                edge = (int[])faceEdgeList.get(pt);
            } while (pt++ < nOK && edge[2] == -1);
            face[0] = edge[0];
            face[1] = edge[1];
            pt = 2;
            int i0 = 1;
            int pt0 = -1;
            block5: while (pt < nOK && pt0 != pt) {
                pt0 = pt;
                for (int i2 = i0; i2 < n; ++i2) {
                    edge = (int[])faceEdgeList.get(i2);
                    if (edge[2] == -1 || edge[0] != face[pt - 1]) continue;
                    face[pt++] = edge[1];
                    if (i2 != i0) continue block5;
                    ++i0;
                    continue block5;
                }
            }
        }
        return faces;
    }

    @Override
    public void setModelVisibilityFlags(BS bsModels) {
        int i = this.polyhedronCount;
        while (--i >= 0) {
            Polyhedron p = this.polyhedrons[i];
            if (p.id == null) {
                int ia = p.centralAtom.i;
                if (this.ms.at[ia].isDeleted()) {
                    p.isValid = false;
                }
                p.visibilityFlags = p.visible && bsModels.get(p.modelIndex) && !this.ms.isAtomHidden(ia) && !this.ms.at[ia].isDeleted() ? this.vf : 0;
                this.atoms[ia].setShapeVisibility(this.vf, p.visibilityFlags != 0);
                continue;
            }
            p.visibilityFlags = p.visible && (p.modelIndex < 0 || bsModels.get(p.modelIndex)) ? this.vf : 0;
        }
    }

    @Override
    public String getShapeState() {
        if (this.polyhedronCount == 0) {
            return "";
        }
        SB s = new SB();
        for (int i = 0; i < this.polyhedronCount; ++i) {
            if (!this.polyhedrons[i].isValid) continue;
            s.append(this.polyhedrons[i].getState(this.vwr));
        }
        if (this.drawEdges == 2) {
            Polyhedra.appendCmd(s, "polyhedra frontedges");
        } else if (this.drawEdges == 1) {
            Polyhedra.appendCmd(s, "polyhedra edges");
        } else if (this.drawEdges == 3) {
            Polyhedra.appendCmd(s, "polyhedra edgesOnly");
        }
        s.append(this.vwr.getStateCreator().getAtomShapeState(this));
        for (int i = 0; i < this.polyhedronCount; ++i) {
            int ia;
            Polyhedron p = this.polyhedrons[i];
            if (!p.isValid || p.id != null || p.colixEdge == 0 || !this.bsColixSet.get(ia = p.centralAtom.i)) continue;
            Polyhedra.appendCmd(s, "select ({" + ia + "}); color polyhedra " + (C.isColixTranslucent(this.colixes[ia]) ? "translucent " : "") + C.getHexCode(this.colixes[ia]) + " " + C.getHexCode(p.colixEdge));
        }
        return s.toString();
    }
}

