/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.surfacetool;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.net.URL;
import java.util.Hashtable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.ListCellRenderer;
import javax.swing.WindowConstants;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jmol.api.JmolViewer;
import org.jmol.i18n.GT;
import org.openscience.jmol.app.HistoryFile;
import org.openscience.jmol.app.surfacetool.SurfaceStatus;
import org.openscience.jmol.app.surfacetool.SurfaceTool;

class SurfaceToolGUI
extends JPanel
implements WindowConstants,
WindowListener,
WindowFocusListener,
ChangeListener,
ActionListener,
ListSelectionListener {
    private HistoryFile historyFile;
    private String histWinName;
    private JFrame slicerFrame;
    private SurfaceTool slicer;
    private JPanel tabPanel;
    private JPanel objectsPanel;
    private JPanel topPanel;
    private JPanel angleUnitsPanel;
    private JComboBox<String> angleUnitsList;
    private JPanel originPanel;
    private JRadioButton viewCenterButton;
    private JRadioButton absoluteButton;
    private JCheckBox capCheck;
    private JPanel capPlanesPanel;
    private JPanel ghostPanel;
    private JCheckBox ghostCheck;
    private JCheckBox boundaryPlaneCheck;
    private JPanel sliderPanel;
    private JPanel normAnglePanel;
    private JSlider angleXYSlider;
    private JSlider angleZSlider;
    private JPanel positionThicknessPanel;
    private JSlider positionSlider;
    private JSlider thicknessSlider;
    private ButtonGroup whichOrigin;
    private JScrollPane surfaceScrollPane;
    private JList<SurfaceStatus> surfaceList;

    SurfaceToolGUI(JmolViewer vwr, HistoryFile hfile, String winName, SurfaceTool slicer) {
        super(new BorderLayout());
        this.historyFile = hfile;
        this.histWinName = winName;
        this.slicer = slicer;
        if (this.slicerFrame != null) {
            this.slicerFrame.setVisible(true);
            this.slicerFrame.toFront();
        } else {
            this.slicerFrame = new JFrame(GT.$("SurfaceTool"));
            this.slicerFrame.setDefaultCloseOperation(2);
            String imageName = "org/openscience/jmol/app/images/icon.png";
            URL imageUrl = this.getClass().getClassLoader().getResource(imageName);
            ImageIcon jmolIcon = new ImageIcon(imageUrl);
            this.slicerFrame.setIconImage(jmolIcon.getImage());
            this.slicerFrame.addWindowFocusListener(this);
            this.slicerFrame.addWindowListener(this);
            this.setOpaque(true);
            this.tabPanel = new JPanel(new BorderLayout());
            this.topPanel = new JPanel(new GridLayout(1, 0));
            this.whichOrigin = new ButtonGroup();
            this.originPanel = new JPanel(new GridLayout(0, 1));
            if (slicer.getUseMolecular()) {
                this.viewCenterButton = new JRadioButton(GT.$("View Center"), false);
                this.absoluteButton = new JRadioButton(GT.$("Absolute"), true);
            } else {
                this.viewCenterButton = new JRadioButton(GT.$("View Center"), true);
                this.absoluteButton = new JRadioButton(GT.$("Absolute"), false);
            }
            this.viewCenterButton.addActionListener(this);
            this.absoluteButton.addActionListener(this);
            this.whichOrigin.add(this.viewCenterButton);
            this.whichOrigin.add(this.absoluteButton);
            this.originPanel.add(this.viewCenterButton);
            this.originPanel.add(this.absoluteButton);
            this.originPanel.setBorder(BorderFactory.createTitledBorder(GT.$("Origin")));
            this.capPlanesPanel = new JPanel(new GridLayout(0, 1));
            this.capCheck = new JCheckBox(GT.$("Cap"));
            this.capCheck.setToolTipText(GT.$("Caps slice with opaque surfaces.\nIgnores MOs and surfaces with interior layers."));
            this.capCheck.setSelected(slicer.getCapOn());
            this.capCheck.addActionListener(this);
            this.capPlanesPanel.add(this.capCheck);
            this.boundaryPlaneCheck = new JCheckBox(GT.$("Slice Planes"));
            this.boundaryPlaneCheck.setToolTipText(GT.$("Shows planes at slicing surfaces."));
            this.boundaryPlaneCheck.setSelected(false);
            slicer.showSliceBoundaryPlanes(false);
            this.boundaryPlaneCheck.addActionListener(this);
            this.capPlanesPanel.add(this.boundaryPlaneCheck);
            this.ghostPanel = new JPanel(new GridLayout(0, 1));
            this.ghostCheck = new JCheckBox(GT.$("Ghost On"));
            this.ghostCheck.setSelected(slicer.getGhostOn());
            this.ghostCheck.addActionListener(this);
            this.ghostCheck.setToolTipText(GT.$("Shows an unsliced \"ghost\"."));
            this.ghostPanel.add(this.ghostCheck);
            this.topPanel.add(this.originPanel);
            this.topPanel.add(this.capPlanesPanel);
            this.topPanel.add(this.ghostPanel);
            this.topPanel.setSize(200, 40);
            this.sliderPanel = new JPanel(new GridLayout(0, 1));
            this.normAnglePanel = new JPanel(new GridLayout(0, 1));
            this.angleUnitsPanel = new JPanel(new BorderLayout());
            JLabel space = new JLabel("   ");
            this.angleUnitsPanel.add((Component)space, "West");
            String[] angleUnits = slicer.getAngleUnitsList();
            this.angleUnitsList = new JComboBox<String>(angleUnits);
            this.angleUnitsList.setSelectedIndex(slicer.getAngleUnits());
            this.angleUnitsList.addActionListener(this);
            this.angleUnitsPanel.add(this.angleUnitsList, "East");
            JPanel labelAndUnits = new JPanel(new GridLayout(1, 0));
            JLabel sliderLabel = new JLabel(GT.$("Angle from X-axis in XY plane"), 0);
            sliderLabel.setAlignmentX(0.5f);
            labelAndUnits.add(sliderLabel);
            labelAndUnits.add(this.angleUnitsPanel);
            this.normAnglePanel.add(labelAndUnits);
            this.angleXYSlider = new JSlider(0, 180, 0);
            this.angleXYSlider.setMajorTickSpacing(30);
            this.angleXYSlider.setPaintTicks(true);
            this.angleXYSlider.addChangeListener(this);
            this.normAnglePanel.add(this.angleXYSlider);
            JLabel sliderLabel2 = new JLabel(GT.$("Angle from Z-axis"), 0);
            sliderLabel2.setAlignmentX(0.5f);
            this.normAnglePanel.add(sliderLabel2);
            this.angleZSlider = new JSlider(0, 180, 0);
            this.angleZSlider.setMajorTickSpacing(30);
            this.angleZSlider.setPaintTicks(true);
            this.angleZSlider.addChangeListener(this);
            this.updateAngleSliders();
            this.normAnglePanel.add(this.angleZSlider);
            this.normAnglePanel.setBorder(BorderFactory.createTitledBorder(GT.$("Direction vector of normal to slice")));
            this.sliderPanel.add(this.normAnglePanel);
            this.positionThicknessPanel = new JPanel(new GridLayout(0, 1));
            JLabel sliderLabel3 = new JLabel(GT.$("Distance of slice from origin"), 0);
            sliderLabel3.setAlignmentX(0.5f);
            this.positionThicknessPanel.add(sliderLabel3);
            int tempPos = (int)(180.0f * (slicer.getSlicePosition() - slicer.getPositionMin()) / slicer.getThicknessMax());
            this.positionSlider = new JSlider(0, 180, tempPos);
            this.positionSlider.setMajorTickSpacing(30);
            this.positionSlider.setPaintTicks(true);
            this.positionSlider.addChangeListener(this);
            this.updatePositionSlider();
            this.positionThicknessPanel.add(this.positionSlider);
            JLabel sliderLabel4 = new JLabel(GT.$("Thickness of slice"), 0);
            sliderLabel4.setAlignmentX(0.5f);
            this.positionThicknessPanel.add(sliderLabel4);
            this.thicknessSlider = new JSlider(0, 180, (int)(180.0f * slicer.getSliceThickness() / slicer.getThicknessMax()));
            this.thicknessSlider.setMajorTickSpacing(30);
            this.thicknessSlider.setPaintTicks(true);
            this.thicknessSlider.addChangeListener(this);
            this.updateThicknessSlider();
            this.positionThicknessPanel.add(this.thicknessSlider);
            this.sliderPanel.add(this.positionThicknessPanel);
            this.tabPanel.add((Component)this.topPanel, "North");
            this.tabPanel.add((Component)this.sliderPanel, "South");
            this.objectsPanel = new JPanel();
            this.objectsPanel.setBorder(BorderFactory.createTitledBorder(GT.$("Select Surface(s)")));
            this.surfaceList = new JList(new DefaultListModel());
            this.surfaceList.setCellRenderer(new SurfaceListCellRenderer());
            this.surfaceList.addListSelectionListener(this);
            this.updateSurfaceList();
            this.surfaceScrollPane = new JScrollPane(this.surfaceList);
            this.surfaceScrollPane.setPreferredSize(new Dimension(120, 300));
            this.objectsPanel.add(this.surfaceScrollPane);
            this.add((Component)this.tabPanel, "West");
            this.add((Component)this.objectsPanel, "East");
            this.slicerFrame.setContentPane(this);
            this.slicerFrame.addWindowListener(this);
            this.historyFile.repositionWindow(winName, this.slicerFrame, 200, 300, true);
            this.slicerFrame.pack();
            this.slicerFrame.setVisible(true);
            this.saveHistory();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean isOn;
        if (e.getSource() == this.angleUnitsList) {
            this.slicer.setAngleUnits(this.angleUnitsList.getSelectedIndex());
            this.updateAngleSliders();
        }
        if (e.getSource() == this.viewCenterButton || e.getSource() == this.absoluteButton) {
            if (this.absoluteButton.isSelected() && !this.slicer.getUseMolecular()) {
                this.slicer.setUseMolecular(true);
                this.slicer.setSurfaceToolParam();
                this.updatePositionSlider();
            }
            if (this.viewCenterButton.isSelected() && this.slicer.getUseMolecular()) {
                this.slicer.setUseMolecular(false);
                this.slicer.setSurfaceToolParam();
                this.updatePositionSlider();
            }
        }
        if (e.getSource() == this.ghostCheck) {
            isOn = this.ghostCheck.isSelected();
            this.slicer.setGhostOn(isOn);
            if (isOn) {
                this.slicer.setCapOn(false);
                this.capCheck.setSelected(false);
            }
            this.sliceSelected();
        }
        if (e.getSource() == this.boundaryPlaneCheck) {
            this.slicer.showSliceBoundaryPlanes(this.boundaryPlaneCheck.isSelected());
        }
        if (e.getSource() == this.capCheck) {
            isOn = this.capCheck.isSelected();
            this.slicer.setCapOn(isOn);
            if (isOn) {
                this.slicer.setGhostOn(false);
                this.ghostCheck.setSelected(false);
            }
            this.sliceSelected();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSlider source = (JSlider)e.getSource();
        if (source == this.angleXYSlider || source == this.angleZSlider) {
            float tempAngleZ = (float)(Math.PI * (double)this.angleZSlider.getValue() / 180.0);
            float tempAngleXY = (float)(Math.PI * (double)this.angleXYSlider.getValue() / 180.0);
            this.slicer.setSliceAnglefromZ(tempAngleZ);
            this.slicer.setSliceAngleXY(tempAngleXY);
            if (!source.getValueIsAdjusting()) {
                this.sliceSelected();
            }
        }
        if (source == this.positionSlider || source == this.thicknessSlider) {
            float tempThickness = (float)this.thicknessSlider.getValue() * this.slicer.getThicknessMax() / 180.0f;
            float tempPos = (float)this.positionSlider.getValue() * this.slicer.getThicknessMax() / 180.0f + this.slicer.getPositionMin();
            this.slicer.setSliceThickness(tempThickness);
            this.slicer.setSlicePosition(tempPos);
            if (!source.getValueIsAdjusting()) {
                this.sliceSelected();
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        JList whichList = (JList)e.getSource();
        if (whichList.isSelectionEmpty()) {
            return;
        }
        int[] selected = whichList.getSelectedIndices();
        if (selected != null) {
            int lastIndex = selected[selected.length - 1];
            List<SurfaceStatus> surfaces = this.slicer.getSurfaces();
            SurfaceStatus lastSurface = surfaces.get(lastIndex);
            if (lastSurface.beenSliced) {
                this.slicer.setSlice(lastSurface.slice.angleXY, lastSurface.slice.anglefromZ, lastSurface.slice.position, lastSurface.slice.thickness);
                this.slicer.setCapOn(lastSurface.capOn);
                this.capCheck.setSelected(lastSurface.capOn);
                this.slicer.setGhostOn(lastSurface.ghostOn);
                this.ghostCheck.setSelected(lastSurface.ghostOn);
                this.updateAngleSliders();
                this.updatePositionSlider();
                this.updateThicknessSlider();
            }
            this.sliceSelected();
        }
    }

    private void sliceSelected() {
        if (this.surfaceList == null) {
            return;
        }
        int[] whichSelected = this.surfaceList.getSelectedIndices();
        if (whichSelected == null || whichSelected.length == 0) {
            return;
        }
        for (int i = 0; i < whichSelected.length; ++i) {
            List<SurfaceStatus> surfaces = this.slicer.getSurfaces();
            int k = whichSelected[i];
            this.slicer.sliceObject(surfaces.get((int)k).id, surfaces.get((int)k).kind);
            surfaces.get((int)k).beenSliced = true;
            surfaces.get((int)k).capOn = this.slicer.getCapOn();
            surfaces.get((int)k).ghostOn = this.slicer.getGhostOn();
            surfaces.get((int)k).slice.setSlice(this.slicer.getSliceAngleXY(), this.slicer.getAnglefromZ(), this.slicer.getSlicePosition(), this.slicer.getSliceThickness(), this.slicer.getCenter(), this.slicer.getBoxVec(), this.slicer.getUseMolecular());
        }
    }

    private void updatePositionSlider() {
        Hashtable<Integer, JLabel> positionLabels = new Hashtable<Integer, JLabel>();
        String temp = "";
        for (int i = 0; i < 7; ++i) {
            float tempVal = (float)((double)this.slicer.getPositionMin() + (double)i * 0.16666666666 * (double)this.slicer.getThicknessMax());
            if ((double)Math.abs(tempVal) < 0.001) {
                tempVal = 0.0f;
            }
            if ((temp = "" + tempVal).length() > 5) {
                temp = tempVal < 0.0f ? temp.substring(0, 5) : temp.substring(0, 4);
            }
            positionLabels.put(i * 30, new JLabel(temp));
        }
        this.positionSlider.setLabelTable(positionLabels);
        this.positionSlider.setPaintLabels(true);
        int tempPos = (int)(180.0f * (this.slicer.getSlicePosition() - this.slicer.getPositionMin()) / this.slicer.getThicknessMax());
        this.positionSlider.setValue(tempPos);
    }

    private void updateThicknessSlider() {
        Hashtable<Integer, JLabel> thicknessLabels = new Hashtable<Integer, JLabel>();
        String temp = "";
        for (int i = 0; i < 7; ++i) {
            float tempVal = (float)((double)i * 0.16666666666 * (double)this.slicer.getThicknessMax());
            temp = "" + tempVal;
            if (temp.length() > 5) {
                temp = temp.substring(0, 4);
            }
            thicknessLabels.put(i * 30, new JLabel(temp));
        }
        this.thicknessSlider.setLabelTable(thicknessLabels);
        this.thicknessSlider.setPaintLabels(true);
        int tempPos = (int)(180.0f * this.slicer.getSliceThickness() / this.slicer.getThicknessMax());
        this.thicknessSlider.setValue(tempPos);
    }

    private void updateAngleSliders() {
        Hashtable<Integer, JLabel> angleLabels = new Hashtable<Integer, JLabel>();
        angleLabels.put(0, new JLabel("0"));
        switch (this.slicer.getAngleUnits()) {
            case 0: {
                angleLabels.put(30, new JLabel("30"));
                angleLabels.put(60, new JLabel("60"));
                angleLabels.put(90, new JLabel("90"));
                angleLabels.put(120, new JLabel("120"));
                angleLabels.put(150, new JLabel("150"));
                angleLabels.put(180, new JLabel("180"));
                break;
            }
            case 1: {
                angleLabels.put(30, new JLabel("0.52"));
                angleLabels.put(60, new JLabel("1.05"));
                angleLabels.put(90, new JLabel("1.75"));
                angleLabels.put(120, new JLabel("2.09"));
                angleLabels.put(150, new JLabel("2.62"));
                angleLabels.put(180, new JLabel("3.14"));
                break;
            }
            case 2: {
                angleLabels.put(30, new JLabel("33.3"));
                angleLabels.put(60, new JLabel("66.7"));
                angleLabels.put(90, new JLabel("100"));
                angleLabels.put(120, new JLabel("133"));
                angleLabels.put(150, new JLabel("167"));
                angleLabels.put(180, new JLabel("200"));
                break;
            }
            case 3: {
                angleLabels.put(30, new JLabel("1/12"));
                angleLabels.put(60, new JLabel("1/6"));
                angleLabels.put(90, new JLabel("1/4"));
                angleLabels.put(120, new JLabel("1/3"));
                angleLabels.put(150, new JLabel("5/12"));
                angleLabels.put(180, new JLabel("1/2"));
                break;
            }
            case 4: {
                String piStr = "\u03c0";
                angleLabels.put(30, new JLabel(piStr + "/6"));
                angleLabels.put(60, new JLabel(piStr + "/3"));
                angleLabels.put(90, new JLabel(piStr + "/2"));
                angleLabels.put(120, new JLabel("2" + piStr + "/3"));
                angleLabels.put(150, new JLabel("5" + piStr + "/6"));
                angleLabels.put(180, new JLabel(piStr));
            }
        }
        this.angleXYSlider.setLabelTable(angleLabels);
        this.angleXYSlider.setPaintLabels(true);
        this.angleZSlider.setLabelTable(angleLabels);
        this.angleZSlider.setPaintLabels(true);
        int tempAngle = (int)((double)(180.0f * this.slicer.getSliceAngleXY()) / Math.PI);
        this.angleXYSlider.setValue(tempAngle);
        tempAngle = (int)((double)(180.0f * this.slicer.getAnglefromZ()) / Math.PI);
        this.angleZSlider.setValue(tempAngle);
    }

    void updateSurfaceList() {
        DefaultListModel listModel = (DefaultListModel)this.surfaceList.getModel();
        listModel.removeAllElements();
        int size = this.slicer.getSurfaces().size();
        for (int i = 0; i < size; ++i) {
            listModel.addElement(this.slicer.getSurfaces().get(i));
        }
    }

    void saveHistory() {
        if (this.historyFile == null) {
            return;
        }
        this.historyFile.addWindowInfo(this.histWinName, this.slicerFrame, null);
    }

    SurfaceToolGUI(LayoutManager layout) {
        super(layout);
    }

    SurfaceToolGUI(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
    }

    SurfaceToolGUI(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    JFrame getFrame() {
        return this.slicerFrame;
    }

    void toFront() {
        this.slicer.toFrontOrGotFocus();
        this.updateAngleSliders();
        this.updatePositionSlider();
        this.updateThicknessSlider();
        this.updateSurfaceList();
        this.slicerFrame.setVisible(true);
        this.slicerFrame.toFront();
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
        this.slicer.toFrontOrGotFocus();
        this.updateAngleSliders();
        this.updatePositionSlider();
        this.updateThicknessSlider();
        this.updateSurfaceList();
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
        this.slicer.toFrontOrGotFocus();
        this.updateAngleSliders();
        this.updatePositionSlider();
        this.updateThicknessSlider();
        this.updateSurfaceList();
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
        this.slicer.toFrontOrGotFocus();
        this.updateAngleSliders();
        this.updatePositionSlider();
        this.updateThicknessSlider();
        this.updateSurfaceList();
    }

    @Override
    public void windowActivated(WindowEvent e) {
        this.slicer.toFrontOrGotFocus();
        this.updateAngleSliders();
        this.updatePositionSlider();
        this.updateThicknessSlider();
        this.updateSurfaceList();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    class SurfaceListCellRenderer
    extends JLabel
    implements ListCellRenderer<Object> {
        SurfaceListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(" " + ((SurfaceStatus)value).id);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(new Color(((SurfaceStatus)value).color));
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(new Color(((SurfaceStatus)value).color));
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }
}

