/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.engine.memory;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.control.CompositeCache;
import org.apache.commons.jcs3.engine.control.group.GroupAttrName;
import org.apache.commons.jcs3.engine.memory.AbstractMemoryCache;
import org.apache.commons.jcs3.engine.memory.util.MemoryElementDescriptor;
import org.apache.commons.jcs3.engine.stats.StatElement;
import org.apache.commons.jcs3.engine.stats.behavior.IStatElement;
import org.apache.commons.jcs3.engine.stats.behavior.IStats;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;
import org.apache.commons.jcs3.utils.struct.DoubleLinkedList;

public abstract class AbstractDoubleLinkedListMemoryCache<K, V>
extends AbstractMemoryCache<K, V> {
    private static final Log log = LogManager.getLog(AbstractDoubleLinkedListMemoryCache.class);
    protected DoubleLinkedList<MemoryElementDescriptor<K, V>> list;

    @Override
    public void initialize(CompositeCache<K, V> hub) {
        super.initialize(hub);
        this.list = new DoubleLinkedList();
        log.info("initialized MemoryCache for {0}", () -> this.getCacheName());
    }

    @Override
    public ConcurrentMap<K, MemoryElementDescriptor<K, V>> createMap() {
        return new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void update(ICacheElement<K, V> ce) throws IOException {
        this.putCnt.incrementAndGet();
        this.lock.lock();
        try {
            MemoryElementDescriptor<K, V> newNode = this.adjustListForUpdate(ce);
            K key = newNode.getCacheElement().getKey();
            MemoryElementDescriptor<K, V> oldNode = this.map.put(key, newNode);
            if (oldNode != null && key.equals(oldNode.getCacheElement().getKey())) {
                this.list.remove(oldNode);
            }
        }
        finally {
            this.lock.unlock();
        }
        this.spoolIfNeeded();
    }

    protected abstract MemoryElementDescriptor<K, V> adjustListForUpdate(ICacheElement<K, V> var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spoolIfNeeded() throws Error {
        int size = this.map.size();
        if (size <= this.getCacheAttributes().getMaxObjects()) {
            return;
        }
        log.debug("In memory limit reached, spooling");
        int chunkSizeCorrected = Math.min(size, this.chunkSize);
        log.debug("About to spool to disk cache, map size: {0}, max objects: {1}, maximum items to spool: {2}", () -> size, () -> this.getCacheAttributes().getMaxObjects(), () -> chunkSizeCorrected);
        this.lock.lock();
        try {
            ICacheElement<K, V> lastElement;
            for (int i = 0; i < chunkSizeCorrected && (lastElement = this.spoolLastElement()) != null; ++i) {
            }
            if (log.isDebugEnabled() && this.map.size() != this.list.size()) {
                log.debug("update: After spool, size mismatch: map.size() = {0}, linked list size = {1}", this.map.size(), this.list.size());
            }
        }
        finally {
            this.lock.unlock();
        }
        log.debug("update: After spool map size: {0} linked list size = {1}", () -> this.map.size(), () -> this.list.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int freeElements(int numberToFree) throws IOException {
        int freed;
        this.lock.lock();
        try {
            for (freed = 0; freed < numberToFree; ++freed) {
                ICacheElement<K, V> element = this.spoolLastElement();
                if (element != null) continue;
                break;
            }
        }
        finally {
            this.lock.unlock();
        }
        return freed;
    }

    private ICacheElement<K, V> spoolLastElement() throws Error {
        ICacheElement<K, V> toSpool = null;
        MemoryElementDescriptor<K, V> last = this.list.getLast();
        if (last != null) {
            toSpool = last.getCacheElement();
            if (toSpool != null) {
                this.getCompositeCache().spoolToDisk(toSpool);
                if (this.map.remove(toSpool.getKey()) == null) {
                    log.warn("update: remove failed for key: {0}", toSpool.getKey());
                    if (log.isTraceEnabled()) {
                        this.verifyCache();
                    }
                }
            } else {
                throw new Error("update: last.ce is null!");
            }
            this.list.remove(last);
        }
        return toSpool;
    }

    @Override
    public ICacheElement<K, V> get(K key) throws IOException {
        ICacheElement ce = super.get(key);
        if (log.isTraceEnabled()) {
            this.verifyCache();
        }
        return ce;
    }

    protected abstract void adjustListForGet(MemoryElementDescriptor<K, V> var1);

    @Override
    protected void lockedGetElement(MemoryElementDescriptor<K, V> me) {
        this.adjustListForGet(me);
    }

    @Override
    protected void lockedRemoveElement(MemoryElementDescriptor<K, V> me) {
        this.list.remove(me);
    }

    @Override
    protected void lockedRemoveAll() {
        this.list.removeAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MemoryElementDescriptor<K, V> addFirst(ICacheElement<K, V> ce) {
        this.lock.lock();
        try {
            MemoryElementDescriptor<K, V> me = new MemoryElementDescriptor<K, V>(ce);
            this.list.addFirst(me);
            if (log.isTraceEnabled()) {
                this.verifyCache(ce.getKey());
            }
            MemoryElementDescriptor<K, V> memoryElementDescriptor = me;
            return memoryElementDescriptor;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MemoryElementDescriptor<K, V> addLast(ICacheElement<K, V> ce) {
        this.lock.lock();
        try {
            MemoryElementDescriptor<K, V> me = new MemoryElementDescriptor<K, V>(ce);
            this.list.addLast(me);
            if (log.isTraceEnabled()) {
                this.verifyCache(ce.getKey());
            }
            MemoryElementDescriptor<K, V> memoryElementDescriptor = me;
            return memoryElementDescriptor;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void dumpCacheEntries() {
        log.trace("dumpingCacheEntries");
        MemoryElementDescriptor me = this.list.getFirst();
        while (me != null) {
            log.trace("dumpCacheEntries> key={0}, val={1}", me.getCacheElement().getKey(), me.getCacheElement().getVal());
            me = (MemoryElementDescriptor)me.next;
        }
    }

    private void verifyCache() {
        boolean found = false;
        log.trace("verifycache[{0}]: map contains {1} elements, linked list contains {2} elements", this.getCacheName(), this.map.size(), this.list.size());
        log.trace("verifycache: checking linked list by key ");
        MemoryElementDescriptor li = this.list.getFirst();
        while (li != null) {
            K key = li.getCacheElement().getKey();
            if (!this.map.containsKey(key)) {
                log.error("verifycache[{0}]: map does not contain key : {1}", this.getCacheName(), key);
                log.error("key class={0}", key.getClass());
                log.error("key hashcode={0}", key.hashCode());
                log.error("key toString={0}", key.toString());
                if (key instanceof GroupAttrName) {
                    GroupAttrName name = (GroupAttrName)key;
                    log.error("GroupID hashcode={0}", name.groupId.hashCode());
                    log.error("GroupID.class={0}", name.groupId.getClass());
                    log.error("AttrName hashcode={0}", name.attrName.hashCode());
                    log.error("AttrName.class={0}", name.attrName.getClass());
                }
                this.dumpMap();
            } else if (this.map.get(key) == null) {
                log.error("verifycache[{0}]: linked list retrieval returned null for key: {1}", this.getCacheName(), key);
            }
            li = (MemoryElementDescriptor)li.next;
        }
        log.trace("verifycache: checking linked list by value ");
        li = this.list.getFirst();
        while (li != null) {
            if (!this.map.containsValue(li)) {
                log.error("verifycache[{0}]: map does not contain value: {1}", this.getCacheName(), li);
                this.dumpMap();
            }
            li = (MemoryElementDescriptor)li.next;
        }
        log.trace("verifycache: checking via keysets!");
        for (Object val : this.map.keySet()) {
            found = false;
            MemoryElementDescriptor li2 = this.list.getFirst();
            while (li2 != null) {
                if (val.equals(li2.getCacheElement().getKey())) {
                    found = true;
                    break;
                }
                li2 = (MemoryElementDescriptor)li2.next;
            }
            if (found) continue;
            log.error("verifycache[{0}]: key not found in list : {1}", this.getCacheName(), val);
            this.dumpCacheEntries();
            if (this.map.containsKey(val)) {
                log.error("verifycache: map contains key");
                continue;
            }
            log.error("verifycache: map does NOT contain key, what the HECK!");
        }
    }

    private void verifyCache(K key) {
        boolean found = false;
        MemoryElementDescriptor li = this.list.getFirst();
        while (li != null) {
            if (li.getCacheElement().getKey() == key) {
                found = true;
                log.trace("verifycache(key) key match: {0}", key);
                break;
            }
            li = (MemoryElementDescriptor)li.next;
        }
        if (!found) {
            log.error("verifycache(key)[{0}], couldn't find key! : {1}", this.getCacheName(), key);
        }
    }

    @Override
    public IStats getStatistics() {
        IStats stats = super.getStatistics();
        stats.setTypeName("Memory Cache");
        List<IStatElement<?>> elems = stats.getStatElements();
        elems.add(new StatElement<Integer>("List Size", this.list.size()));
        return stats;
    }
}

