/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.log;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.IllegalFormatException;
import java.util.function.Supplier;

public class MessageFormatter {
    private final String messagePattern;
    private transient Object[] parameters;
    private transient String formattedMessage;
    private transient Throwable throwable;

    public MessageFormatter(String messagePattern, Object ... parameters) {
        int length;
        this.messagePattern = messagePattern;
        this.parameters = parameters;
        int n = length = parameters == null ? 0 : parameters.length;
        if (length > 0 && parameters[length - 1] instanceof Throwable) {
            this.throwable = (Throwable)parameters[length - 1];
        }
    }

    public MessageFormatter(String messagePattern, Supplier<?> ... paramSuppliers) {
        int length;
        this.messagePattern = messagePattern;
        this.parameters = Arrays.stream(paramSuppliers).map(s -> s.get()).toArray();
        int n = length = this.parameters == null ? 0 : this.parameters.length;
        if (length > 0 && this.parameters[length - 1] instanceof Throwable) {
            this.throwable = (Throwable)this.parameters[length - 1];
        }
    }

    public String getFormattedMessage() {
        if (this.formattedMessage == null) {
            this.formattedMessage = this.formatMessage(this.messagePattern, this.parameters);
        }
        return this.formattedMessage;
    }

    protected String formatMessage(String msgPattern, Object ... args) {
        try {
            MessageFormat temp = new MessageFormat(msgPattern);
            return temp.format(args);
        }
        catch (IllegalFormatException ife) {
            return msgPattern;
        }
    }

    public String toString() {
        return this.getFormattedMessage();
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public boolean hasThrowable() {
        return this.throwable != null;
    }
}

