/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.utils.discovery;

import java.util.HashSet;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;
import org.apache.commons.jcs3.utils.discovery.DiscoveredService;
import org.apache.commons.jcs3.utils.discovery.UDPDiscoveryService;

public class UDPCleanupRunner
implements Runnable {
    private static final Log log = LogManager.getLog(UDPCleanupRunner.class);
    private final UDPDiscoveryService discoveryService;
    private static final long DEFAULT_MAX_IDLE_TIME_SECONDS = 180L;
    private final long maxIdleTimeSeconds = 180L;

    public UDPCleanupRunner(UDPDiscoveryService service) {
        this.discoveryService = service;
    }

    @Override
    public void run() {
        long now = System.currentTimeMillis();
        HashSet<DiscoveredService> toRemove = new HashSet<DiscoveredService>();
        for (DiscoveredService service : this.discoveryService.getDiscoveredServices()) {
            if (now - service.getLastHearFromTime() <= 180000L) continue;
            log.info("Removing service, since we haven't heard from it in {0} seconds. service = {1}", 180L, service);
            toRemove.add(service);
        }
        for (DiscoveredService service : toRemove) {
            this.discoveryService.removeDiscoveredService(service);
        }
    }
}

