/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.geom.Path2D;
import java.util.Collection;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.actions.DownloadAlongAction;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.gpx.DownloadAlongPanel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class DownloadAlongWayAction
extends DownloadAlongAction {
    private static final String PREF_DOWNLOAD_ALONG_WAY_DISTANCE = "downloadAlongWay.distance";
    private static final String PREF_DOWNLOAD_ALONG_WAY_AREA = "downloadAlongWay.area";
    private static final String PREF_DOWNLOAD_ALONG_WAY_OSM = "downloadAlongWay.download.osm";
    private static final String PREF_DOWNLOAD_ALONG_WAY_GPS = "downloadAlongWay.download.gps";

    public DownloadAlongWayAction() {
        super(I18n.tr("Download along...", new Object[0]), "download_along_way", I18n.tr("Download OSM data along the selected ways.", new Object[0]), Shortcut.registerShortcut("file:download_along", I18n.tr("File: {0}", I18n.tr("Download Along", new Object[0])), 68, 5007), true);
    }

    @Override
    protected PleaseWaitRunnable createTask() {
        Collection selectedWays = this.getLayerManager().getActiveDataSet().getSelectedWays();
        if (selectedWays.isEmpty()) {
            JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("Please select 1 or more ways to download along", new Object[0]));
            return null;
        }
        DownloadAlongPanel panel = new DownloadAlongPanel(PREF_DOWNLOAD_ALONG_WAY_OSM, PREF_DOWNLOAD_ALONG_WAY_GPS, PREF_DOWNLOAD_ALONG_WAY_DISTANCE, PREF_DOWNLOAD_ALONG_WAY_AREA, null);
        int ret = panel.showInDownloadDialog(I18n.tr("Download from OSM along selected ways", new Object[0]), HelpUtil.ht("/Action/DownloadAlongWay"));
        if (0 != ret && 1 != ret) {
            return null;
        }
        Path2D.Double alongPath = new Path2D.Double();
        for (Way way : selectedWays) {
            boolean first = true;
            for (Node p : way.getNodes()) {
                if (first) {
                    ((Path2D)alongPath).moveTo(p.lon(), p.lat());
                    first = false;
                    continue;
                }
                ((Path2D)alongPath).lineTo(p.lon(), p.lat());
            }
        }
        return this.createCalcTask(alongPath, panel, I18n.tr("Download from OSM along selected ways", new Object[0]), 1 == ret);
    }

    @Override
    protected void updateEnabledState() {
        if (this.getLayerManager().getEditDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(this.getLayerManager().getEditDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection.stream().anyMatch(Way.class::isInstance));
    }
}

