/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.gpx;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxImageEntry;
import org.openstreetmap.josm.data.gpx.IGpxTrack;
import org.openstreetmap.josm.data.gpx.IGpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Pair;

public final class GpxImageCorrelation {
    private GpxImageCorrelation() {
    }

    public static int matchGpxTrack(List<? extends GpxImageEntry> images, GpxData selectedGpx, long offset, boolean forceTags) {
        int trkTime;
        int trkDist;
        int trkTagTime;
        int segTime;
        int segDist;
        int segTagTime;
        boolean trkInt;
        boolean trkTag;
        boolean segInt;
        boolean segTag;
        int ret = 0;
        long prevWpTime = 0L;
        WayPoint prevWp = null;
        ArrayList trks = new ArrayList();
        for (IGpxTrack trk : selectedGpx.tracks) {
            ArrayList segs = new ArrayList();
            for (IGpxTrackSegment seg : trk.getSegments()) {
                int wp;
                ArrayList<WayPoint> wps = new ArrayList<WayPoint>(seg.getWayPoints());
                if (wps.isEmpty()) continue;
                for (wp = 0; wp < wps.size() && !((WayPoint)wps.get(wp)).hasDate(); ++wp) {
                }
                if (wp == 0) {
                    segs.add(wps);
                    continue;
                }
                if (wp >= wps.size()) continue;
                segs.add(wps.subList(wp, wps.size()));
            }
            if (segs.isEmpty()) continue;
            segs.sort((o1, o2) -> {
                if (o1.isEmpty() || o2.isEmpty()) {
                    return 0;
                }
                return ((WayPoint)o1.get(0)).compareTo((WayPoint)o2.get(0));
            });
            trks.add(segs);
        }
        trks.sort((o1, o2) -> {
            if (o1.isEmpty() || ((List)o1.get(0)).isEmpty() || o2.isEmpty() || ((List)o2.get(0)).isEmpty()) {
                return 0;
            }
            return ((WayPoint)((List)o1.get(0)).get(0)).compareTo((WayPoint)((List)o2.get(0)).get(0));
        });
        if (forceTags) {
            segTag = true;
            segInt = true;
            trkTag = true;
            trkInt = true;
            segTagTime = Integer.MAX_VALUE;
            segDist = Integer.MAX_VALUE;
            segTime = Integer.MAX_VALUE;
            trkTagTime = Integer.MAX_VALUE;
            trkDist = Integer.MAX_VALUE;
            trkTime = Integer.MAX_VALUE;
        } else {
            trkInt = Config.getPref().getBoolean("geoimage.trk.int", false);
            trkTime = Config.getPref().getBoolean("geoimage.trk.int.time", false) ? Config.getPref().getInt("geoimage.trk.int.time.val", 60) : Integer.MAX_VALUE;
            trkDist = Config.getPref().getBoolean("geoimage.trk.int.dist", false) ? Config.getPref().getInt("geoimage.trk.int.dist.val", 50) : Integer.MAX_VALUE;
            trkTag = Config.getPref().getBoolean("geoimage.trk.tag", true);
            trkTagTime = Config.getPref().getBoolean("geoimage.trk.tag.time", true) ? Config.getPref().getInt("geoimage.trk.tag.time.val", 2) : Integer.MAX_VALUE;
            segInt = Config.getPref().getBoolean("geoimage.seg.int", true);
            segTime = Config.getPref().getBoolean("geoimage.seg.int.time", true) ? Config.getPref().getInt("geoimage.seg.int.time.val", 60) : Integer.MAX_VALUE;
            segDist = Config.getPref().getBoolean("geoimage.seg.int.dist", true) ? Config.getPref().getInt("geoimage.seg.int.dist.val", 50) : Integer.MAX_VALUE;
            segTag = Config.getPref().getBoolean("geoimage.seg.tag", true);
            segTagTime = Config.getPref().getBoolean("geoimage.seg.tag.time", true) ? Config.getPref().getInt("geoimage.seg.tag.time.val", 2) : Integer.MAX_VALUE;
        }
        boolean isFirst = true;
        for (int t = 0; t < trks.size(); ++t) {
            List segs = (List)trks.get(t);
            block4: for (int s = 0; s < segs.size(); ++s) {
                List wps = (List)segs.get(s);
                for (int i = 0; i < wps.size(); ++i) {
                    WayPoint curWp = (WayPoint)wps.get(i);
                    if (!curWp.hasDate()) {
                        if (i <= 0 || !((WayPoint)wps.get(i - 1)).hasDate()) continue;
                        long prevWpTimeNoOffset = ((WayPoint)wps.get(i - 1)).getTimeInMillis();
                        double totalDist = 0.0;
                        ArrayList<Pair<Double, WayPoint>> nextWps = new ArrayList<Pair<Double, WayPoint>>();
                        for (int j = i; j < wps.size(); ++j) {
                            nextWps.add(new Pair<Double, WayPoint>(totalDist += ((WayPoint)wps.get(j - 1)).getCoor().greatCircleDistance(((WayPoint)wps.get(j)).getCoor()), (WayPoint)wps.get(j)));
                            if (!((WayPoint)wps.get(j)).hasDate()) continue;
                            long timeDiff = ((WayPoint)wps.get(j)).getTimeInMillis() - prevWpTimeNoOffset;
                            for (Pair pair : nextWps) {
                                ((WayPoint)pair.b).setTimeInMillis((long)((double)prevWpTimeNoOffset + (double)timeDiff * ((Double)pair.a / totalDist)));
                            }
                            break;
                        }
                        if (!curWp.hasDate()) continue block4;
                    }
                    long curWpTime = curWp.getTimeInMillis() + offset;
                    boolean interpolate = true;
                    int tagTime = 0;
                    if (i == 0) {
                        if (s == 0) {
                            if (!trkInt || isFirst || prevWp == null || Math.abs(curWpTime - prevWpTime) > TimeUnit.MINUTES.toMillis(trkTime) || prevWp.getCoor().greatCircleDistance(curWp.getCoor()) > (double)trkDist) {
                                isFirst = false;
                                interpolate = false;
                                if (trkTag) {
                                    tagTime = trkTagTime;
                                }
                            }
                        } else if (!segInt || prevWp == null || Math.abs(curWpTime - prevWpTime) > TimeUnit.MINUTES.toMillis(segTime) || prevWp.getCoor().greatCircleDistance(curWp.getCoor()) > (double)segDist) {
                            interpolate = false;
                            if (segTag) {
                                tagTime = segTagTime;
                            }
                        }
                    }
                    ret += GpxImageCorrelation.matchPoints(images, prevWp, prevWpTime, curWp, curWpTime, offset, interpolate, tagTime, false);
                    prevWp = curWp;
                    prevWpTime = curWpTime;
                }
            }
        }
        if (trkTag) {
            ret += GpxImageCorrelation.matchPoints(images, prevWp, prevWpTime, prevWp, prevWpTime, offset, false, trkTagTime, true);
        }
        return ret;
    }

    static Double getElevation(WayPoint wp) {
        String value;
        if (wp != null && (value = wp.getString("ele")) != null && !value.isEmpty()) {
            try {
                return Double.valueOf(value);
            }
            catch (NumberFormatException e) {
                Logging.warn(e);
            }
        }
        return null;
    }

    private static int matchPoints(List<? extends GpxImageEntry> images, WayPoint prevWp, long prevWpTime, WayPoint curWp, long curWpTime, long offset, boolean interpolate, int tagTime, boolean isLast) {
        int ret;
        block12: {
            Double curElevation;
            Double prevElevation;
            Double speed;
            int i;
            block13: {
                ret = 0;
                i = isLast ? images.size() - 1 : GpxImageCorrelation.getLastIndexOfListBefore(images, curWpTime);
                if (i < 0) {
                    return 0;
                }
                speed = null;
                prevElevation = null;
                if (prevWp != null && interpolate) {
                    double distance = prevWp.getCoor().greatCircleDistance(curWp.getCoor());
                    if (curWpTime > prevWpTime) {
                        speed = 3600.0 * distance / (double)(curWpTime - prevWpTime);
                    }
                    prevElevation = GpxImageCorrelation.getElevation(prevWp);
                }
                curElevation = GpxImageCorrelation.getElevation(curWp);
                if (interpolate && !isLast) break block13;
                long half = Math.abs(curWpTime - prevWpTime) / 2L;
                while (i >= 0) {
                    GpxImageEntry curImg = images.get(i);
                    GpxImageEntry curTmp = curImg.getTmp();
                    long time = curImg.getExifTime().getTime();
                    if ((isLast || time <= curWpTime) && time >= prevWpTime) {
                        long tagms = TimeUnit.MINUTES.toMillis(tagTime);
                        if (curTmp.getPos() == null && (Math.abs(time - curWpTime) <= tagms || Math.abs(prevWpTime - time) <= tagms)) {
                            if (prevWp != null && time < curWpTime - half) {
                                curTmp.setPos(prevWp.getCoor());
                            } else {
                                curTmp.setPos(curWp.getCoor());
                            }
                            curTmp.setGpsTime(new Date(curImg.getExifTime().getTime() - offset));
                            curTmp.flagNewGpsData();
                            ++ret;
                        }
                        --i;
                        continue;
                    }
                    break block12;
                }
                break block12;
            }
            if (prevWp == null) break block12;
            while (i >= 0) {
                GpxImageEntry curImg = images.get(i);
                GpxImageEntry curTmp = curImg.getTmp();
                long imgTime = curImg.getExifTime().getTime();
                if (imgTime >= prevWpTime) {
                    if (curTmp.getPos() == null) {
                        double timeDiff = (double)(imgTime - prevWpTime) / (double)Math.abs(curWpTime - prevWpTime);
                        curTmp.setPos(prevWp.getCoor().interpolate(curWp.getCoor(), timeDiff));
                        curTmp.setSpeed(speed);
                        if (curElevation != null && prevElevation != null) {
                            curTmp.setElevation(prevElevation + (curElevation - prevElevation) * timeDiff);
                        }
                        curTmp.setGpsTime(new Date(curImg.getExifTime().getTime() - offset));
                        curTmp.flagNewGpsData();
                        ++ret;
                    }
                    --i;
                    continue;
                }
                break;
            }
        }
        return ret;
    }

    private static int getLastIndexOfListBefore(List<? extends GpxImageEntry> images, long searchedTime) {
        int lstSize = images.size();
        if (lstSize == 0 || searchedTime < images.get(0).getExifTime().getTime()) {
            return -1;
        }
        if (searchedTime > images.get(lstSize - 1).getExifTime().getTime()) {
            return lstSize - 1;
        }
        int startIndex = 0;
        int endIndex = lstSize - 1;
        while (endIndex - startIndex > 1) {
            int curIndex = (endIndex + startIndex) / 2;
            if (searchedTime > images.get(curIndex).getExifTime().getTime()) {
                startIndex = curIndex;
                continue;
            }
            endIndex = curIndex;
        }
        if (searchedTime < images.get(endIndex).getExifTime().getTime()) {
            return startIndex;
        }
        while (endIndex < lstSize - 1 && images.get(endIndex).getExifTime().getTime() == images.get(endIndex + 1).getExifTime().getTime()) {
            ++endIndex;
        }
        return endIndex;
    }
}

