/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.gui.conflict.tags.MultiValueDecisionType;
import org.openstreetmap.josm.gui.conflict.tags.MultiValueResolutionDecision;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class TagConflictResolverModel
extends DefaultTableModel {
    public static final String NUM_CONFLICTS_PROP = TagConflictResolverModel.class.getName() + ".numConflicts";
    private transient TagCollection tags;
    private List<String> displayedKeys;
    private final Set<String> keysWithConflicts = new HashSet<String>();
    private transient Map<String, MultiValueResolutionDecision> decisions;
    private int numConflicts = 0;
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private boolean showTagsWithConflictsOnly;
    private boolean showTagsWithMultiValuesOnly;

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    protected void setNumConflicts(int numConflicts) {
        int oldValue = this.numConflicts;
        this.numConflicts = numConflicts;
        if (oldValue != this.numConflicts) {
            this.support.firePropertyChange(NUM_CONFLICTS_PROP, oldValue, this.numConflicts);
        }
    }

    protected void refreshNumConflicts() {
        this.setNumConflicts((int)this.decisions.values().stream().filter(d -> !d.isDecided()).count());
    }

    protected void sort() {
        this.displayedKeys.sort((key1, key2) -> {
            if (this.decisions.get(key1).isDecided() && !this.decisions.get(key2).isDecided()) {
                return 1;
            }
            if (!this.decisions.get(key1).isDecided() && this.decisions.get(key2).isDecided()) {
                return -1;
            }
            return key1.compareTo((String)key2);
        });
    }

    public void rebuild() {
        this.rebuild(true);
    }

    void rebuild(boolean fireEvent) {
        if (this.tags == null) {
            return;
        }
        for (String key2 : this.tags.getKeys()) {
            MultiValueResolutionDecision decision = new MultiValueResolutionDecision(this.tags.getTagsFor(key2));
            this.decisions.putIfAbsent(key2, decision);
        }
        this.displayedKeys.clear();
        Set<String> keys = this.tags.getKeys();
        if (this.showTagsWithConflictsOnly) {
            keys.retainAll(this.keysWithConflicts);
            if (this.showTagsWithMultiValuesOnly) {
                keys.removeIf(key -> !this.decisions.get(key).canKeepAll());
            }
            for (String key3 : this.tags.getKeys()) {
                if (this.decisions.get(key3).isDecided()) continue;
                keys.add(key3);
            }
        }
        this.displayedKeys.addAll(keys);
        this.refreshNumConflicts();
        this.sort();
        if (fireEvent) {
            GuiHelper.runInEDTAndWait(this::fireTableDataChanged);
        }
    }

    public void populate(TagCollection tags, Set<String> keysWithConflicts) {
        this.populate(tags, keysWithConflicts, true);
    }

    void populate(TagCollection tags, Set<String> keysWithConflicts, boolean fireEvent) {
        CheckParameterUtil.ensureParameterNotNull(tags, "tags");
        this.tags = tags;
        this.displayedKeys = new ArrayList<String>();
        if (keysWithConflicts != null) {
            this.keysWithConflicts.addAll(keysWithConflicts);
        }
        this.decisions = new HashMap<String, MultiValueResolutionDecision>();
        this.rebuild(fireEvent);
    }

    public final String getKey(int row) {
        return this.displayedKeys.get(row);
    }

    @Override
    public int getRowCount() {
        if (this.displayedKeys == null) {
            return 0;
        }
        return this.displayedKeys.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.getDecision(row);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == 2;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        MultiValueResolutionDecision decision = this.getDecision(row);
        if (value instanceof String) {
            decision.keepOne((String)value);
        } else if (value instanceof MultiValueDecisionType) {
            MultiValueDecisionType type = (MultiValueDecisionType)((Object)value);
            switch (type) {
                case KEEP_NONE: {
                    decision.keepNone();
                    break;
                }
                case KEEP_ALL: {
                    decision.keepAll();
                    break;
                }
                case SUM_ALL_NUMERIC: {
                    decision.sumAllNumeric();
                    break;
                }
            }
        }
        GuiHelper.runInEDTAndWait(this::fireTableDataChanged);
        this.refreshNumConflicts();
    }

    public boolean isResolvedCompletely() {
        return this.numConflicts == 0;
    }

    public int getNumConflicts() {
        return this.numConflicts;
    }

    public int getNumDecisions() {
        return this.decisions == null ? 0 : this.decisions.size();
    }

    public TagCollection getResolution() {
        TagCollection tc = new TagCollection();
        for (String key : this.displayedKeys) {
            tc.add(this.decisions.get(key).getResolution());
        }
        return tc;
    }

    public TagCollection getAllResolutions() {
        TagCollection tc = new TagCollection();
        for (MultiValueResolutionDecision value : this.decisions.values()) {
            tc.add(value.getResolution());
        }
        return tc;
    }

    public MultiValueResolutionDecision getDecision(int row) {
        return this.decisions.get(this.getKey(row));
    }

    public void setShowTagsWithConflictsOnly(boolean showTagsWithConflictsOnly) {
        this.showTagsWithConflictsOnly = showTagsWithConflictsOnly;
        this.rebuild();
    }

    public void setShowTagsWithMultiValuesOnly(boolean showTagsWithMultiValuesOnly) {
        this.showTagsWithMultiValuesOnly = showTagsWithMultiValuesOnly;
        this.rebuild();
    }

    public void prepareDefaultTagDecisions() {
        this.prepareDefaultTagDecisions(true);
    }

    void prepareDefaultTagDecisions(boolean fireEvent) {
        for (MultiValueResolutionDecision decision : this.decisions.values()) {
            List<String> values = decision.getValues();
            values.remove("");
            if (values.size() != 1) continue;
            decision.keepOne(values.get(0));
        }
        this.rebuild(fireEvent);
    }

    public final Set<String> getKeysWithConflicts() {
        return new HashSet<String>(this.keysWithConflicts);
    }
}

