/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.oauth;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.openstreetmap.josm.gui.oauth.AuthorizationProcedure;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.tools.I18n;

public class AuthorizationProcedureComboBox
extends JosmComboBox<AuthorizationProcedure> {
    public AuthorizationProcedureComboBox() {
        super((E[])AuthorizationProcedure.values());
        this.setRenderer(new AuthorisationProcedureCellRenderer());
        this.setSelectedItem((Object)AuthorizationProcedure.FULLY_AUTOMATIC);
    }

    private static class AuthorisationProcedureCellRenderer
    extends JLabel
    implements ListCellRenderer<AuthorizationProcedure> {
        AuthorisationProcedureCellRenderer() {
            this.setOpaque(true);
        }

        protected void renderColors(boolean isSelected) {
            if (isSelected) {
                this.setForeground(UIManager.getColor("List.selectionForeground"));
                this.setBackground(UIManager.getColor("List.selectionBackground"));
            } else {
                this.setForeground(UIManager.getColor("List.foreground"));
                this.setBackground(UIManager.getColor("List.background"));
            }
        }

        protected void renderText(AuthorizationProcedure value) {
            switch (value) {
                case FULLY_AUTOMATIC: {
                    this.setText(I18n.tr("Fully automatic", new Object[0]));
                    break;
                }
                case SEMI_AUTOMATIC: {
                    this.setText(I18n.tr("Semi-automatic", new Object[0]));
                    break;
                }
                case MANUALLY: {
                    this.setText(I18n.tr("Manual", new Object[0]));
                }
            }
        }

        protected void renderToolTipText(AuthorizationProcedure value) {
            switch (value) {
                case FULLY_AUTOMATIC: {
                    this.setToolTipText(I18n.tr("<html>Run a fully automatic procedure to get an access token from the OSM website.<br>JOSM accesses the OSM website on behalf of the JOSM user and fully<br>automatically authorizes the user and retrieves an Access Token.</html>", new Object[0]));
                    break;
                }
                case SEMI_AUTOMATIC: {
                    this.setToolTipText(I18n.tr("<html>Run a semi-automatic procedure to get an access token from the OSM website.<br>JOSM submits the standards OAuth requests to get a Request Token and an<br>Access Token. It dispatches the user to the OSM website in an external browser<br>to authenticate itself and to accept the request token submitted by JOSM.</html>", new Object[0]));
                    break;
                }
                case MANUALLY: {
                    this.setToolTipText(I18n.tr("<html>Enter an Access Token manually if it was generated and retrieved outside<br>of JOSM.</html>", new Object[0]));
                }
            }
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends AuthorizationProcedure> list, AuthorizationProcedure procedure, int idx, boolean isSelected, boolean hasFocus) {
            this.renderColors(isSelected);
            this.renderText(procedure);
            this.renderToolTipText(procedure);
            return this;
        }
    }
}

