/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.imagery;

import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.openstreetmap.josm.data.imagery.WMSCachedTileLoader;
import org.openstreetmap.josm.gui.layer.WMSLayer;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class WMSSettingsPanel
extends JPanel {
    private static final int IMAGE_SIZE_MIN = 1;
    private static final int IMAGE_SIZE_MAX = 4096;
    private static final int THREADS_MIN = 1;
    private static final int THREADS_MAX = 30;
    private final JCheckBox autozoomActive = new JCheckBox();
    private final JSpinner spinSimConn;
    private final JSpinner tileSize;

    public WMSSettingsPanel() {
        super(new GridBagLayout());
        this.add((Component)new JLabel(I18n.tr("Auto zoom by default: ", new Object[0])), GBC.std());
        this.add(GBC.glue(5, 0), GBC.std());
        this.add((Component)this.autozoomActive, GBC.eol().fill(2));
        this.add(Box.createHorizontalGlue(), GBC.eol().fill(2));
        JLabel labelSimConn = new JLabel(I18n.tr("Simultaneous connections:", new Object[0]));
        int threadLimitValue = Utils.clamp(WMSCachedTileLoader.THREAD_LIMIT.get(), 1, 30);
        this.spinSimConn = new JSpinner(new SpinnerNumberModel(threadLimitValue, 1, 30, 1));
        labelSimConn.setLabelFor(this.spinSimConn);
        this.add((Component)labelSimConn, GBC.std());
        this.add(GBC.glue(5, 0), GBC.std());
        this.add((Component)this.spinSimConn, GBC.eol());
        JLabel labelTileSize = new JLabel(I18n.tr("Tile size:", new Object[0]));
        int tileSizeValue = Utils.clamp(WMSLayer.PROP_IMAGE_SIZE.get(), 1, 4096);
        this.tileSize = new JSpinner(new SpinnerNumberModel(tileSizeValue, 1, 4096, 128));
        labelTileSize.setLabelFor(this.tileSize);
        this.add((Component)labelTileSize, GBC.std());
        this.add(GBC.glue(5, 0), GBC.std());
        this.add((Component)this.tileSize, GBC.eol());
    }

    public void loadSettings() {
        this.autozoomActive.setSelected(WMSLayer.PROP_DEFAULT_AUTOZOOM.get());
        this.spinSimConn.setValue(WMSCachedTileLoader.THREAD_LIMIT.get());
        this.tileSize.setValue(WMSLayer.PROP_IMAGE_SIZE.get());
    }

    public boolean saveSettings() {
        WMSLayer.PROP_DEFAULT_AUTOZOOM.put(this.autozoomActive.isSelected());
        WMSCachedTileLoader.THREAD_LIMIT.put((Integer)this.spinSimConn.getModel().getValue());
        WMSLayer.PROP_IMAGE_SIZE.put((Integer)this.tileSize.getModel().getValue());
        return false;
    }
}

