/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.shortcut;

import java.awt.Component;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.DefaultTabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.shortcut.PrefJPanel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class ShortcutPreference
extends DefaultTabPreferenceSetting {
    private String defaultFilter;

    private ShortcutPreference() {
        super("shortcuts", I18n.tr("Keyboard Shortcuts", new Object[0]), I18n.tr("Changing keyboard shortcuts manually.", new Object[0]));
    }

    @Override
    public void addGui(PreferenceTabbedPane gui) {
        PreferenceTabbedPane.PreferencePanel p = gui.createPreferenceTab(this);
        PrefJPanel prefpanel = new PrefJPanel();
        p.add((Component)prefpanel, GBC.eol().fill(1));
        if (this.defaultFilter != null) {
            prefpanel.filter(this.defaultFilter);
        }
    }

    @Override
    public boolean ok() {
        return Shortcut.savePrefs();
    }

    public void setDefaultFilter(String substring) {
        this.defaultFilter = substring;
    }

    @Override
    public String getHelpContext() {
        return HelpUtil.ht("/Preferences/Shortcuts");
    }

    public static class Factory
    implements PreferenceSettingFactory {
        @Override
        public PreferenceSetting createPreferenceSetting() {
            return new ShortcutPreference();
        }
    }
}

