/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public abstract class JosmTable
extends JTable {
    private int colEnd;
    protected SelectNextColumnCellAction selectNextColumnCellAction;
    protected SelectPreviousColumnCellAction selectPreviousColumnCellAction;

    protected JosmTable(TableModel dm, TableColumnModel cm) {
        this(dm, cm, null);
    }

    protected JosmTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
    }

    protected void installCustomNavigation(int colEnd) {
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0, false), "selectNextColumnCell");
        this.colEnd = colEnd;
        this.selectNextColumnCellAction = new SelectNextColumnCellAction();
        this.selectPreviousColumnCellAction = new SelectPreviousColumnCellAction();
        this.getActionMap().put("selectNextColumnCell", this.selectNextColumnCellAction);
        this.getActionMap().put("selectPreviousColumnCell", this.selectPreviousColumnCellAction);
    }

    protected Dimension getPreferredFullWidthSize() {
        Container c;
        for (c = this.getParent(); c != null && !(c instanceof JViewport); c = c.getParent()) {
        }
        if (c != null) {
            Dimension d = super.getPreferredSize();
            d.width = c.getSize().width;
            return d;
        }
        return super.getPreferredSize();
    }

    protected class SelectPreviousColumnCellAction
    extends AbstractAction {
        protected SelectPreviousColumnCellAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int col = JosmTable.this.getSelectedColumn();
            int row = JosmTable.this.getSelectedRow();
            if (JosmTable.this.getCellEditor() != null) {
                JosmTable.this.getCellEditor().stopCellEditing();
            }
            if ((col > 0 || row > 0) && row > 0) {
                col = JosmTable.this.colEnd;
                --row;
            }
            JosmTable.this.changeSelection(row, col, false, false);
            if (JosmTable.this.editCellAt(JosmTable.this.getSelectedRow(), JosmTable.this.getSelectedColumn())) {
                JosmTable.this.getEditorComponent().requestFocusInWindow();
            }
        }
    }

    protected class SelectNextColumnCellAction
    extends AbstractAction {
        protected SelectNextColumnCellAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int col = JosmTable.this.getSelectedColumn();
            int row = JosmTable.this.getSelectedRow();
            if (JosmTable.this.getCellEditor() != null) {
                JosmTable.this.getCellEditor().stopCellEditing();
            }
            if (col == JosmTable.this.colEnd && row < JosmTable.this.getRowCount() - 1) {
                ++row;
            } else if (row < JosmTable.this.getRowCount() - 1) {
                col = JosmTable.this.colEnd;
                ++row;
            } else {
                KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                manager.focusNextComponent();
                return;
            }
            JosmTable.this.changeSelection(row, col, false, false);
            if (JosmTable.this.editCellAt(JosmTable.this.getSelectedRow(), JosmTable.this.getSelectedColumn())) {
                JosmTable.this.getEditorComponent().requestFocusInWindow();
            }
        }
    }
}

