/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.data.oauth.OAuthAccessTokenHolder;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.io.ChangesetClosedException;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.MissingOAuthAccessTokenException;
import org.openstreetmap.josm.io.OfflineAccessException;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.OsmApiInitializationException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.date.DateUtils;

public final class ExceptionUtil {
    private static final List<String> OSM_API_BLOCK_MESSAGES = Arrays.asList("You have an urgent message on the OpenStreetMap web site. You need to read the message before you will be able to save your edits.", "Your access to the API has been blocked. Please log-in to the web interface to find out more.", "Your access to the API is temporarily suspended. Please log-in to the web interface to view the Contributor Terms. You do not need to agree, but you must view them.");

    private ExceptionUtil() {
    }

    public static String explainOsmApiInitializationException(OsmApiInitializationException e) {
        Logging.error(e);
        return I18n.tr("<html>Failed to initialize communication with the OSM server {0}.<br>Check the server URL in your preferences and your internet connection.", OsmApi.getOsmApi().getServerUrl()) + "</html>";
    }

    public static String explainMissingOAuthAccessTokenException(MissingOAuthAccessTokenException e) {
        Logging.error(e);
        return I18n.tr("<html>Failed to authenticate at the OSM server ''{0}''.<br>You are using OAuth to authenticate but currently there is no<br>OAuth Access Token configured.<br>Please open the Preferences Dialog and generate or enter an Access Token.</html>", OsmApi.getOsmApi().getServerUrl());
    }

    public static Pair<OsmPrimitive, Collection<OsmPrimitive>> parsePreconditionFailed(String msg) {
        if (msg == null) {
            return null;
        }
        String ids = "(\\d+(?:,\\d+)*)";
        TreeSet<OsmPrimitive> refs = new TreeSet<OsmPrimitive>();
        Matcher m = Pattern.compile(".*Node (\\d+) is still used by relations? (\\d+(?:,\\d+)*).*").matcher(msg);
        if (m.matches()) {
            Node n = new Node(Long.parseLong(m.group(1)));
            for (String s : m.group(2).split(",", -1)) {
                refs.add(new Relation(Long.parseLong(s)));
            }
            return Pair.create(n, refs);
        }
        m = Pattern.compile(".*Node (\\d+) is still used by ways? (\\d+(?:,\\d+)*).*").matcher(msg);
        if (m.matches()) {
            Node n = new Node(Long.parseLong(m.group(1)));
            for (String s : m.group(2).split(",", -1)) {
                refs.add(new Way(Long.parseLong(s)));
            }
            return Pair.create(n, refs);
        }
        m = Pattern.compile(".*The relation (\\d+) is used in relations? (\\d+(?:,\\d+)*).*").matcher(msg);
        if (m.matches()) {
            Relation n = new Relation(Long.parseLong(m.group(1)));
            for (String s : m.group(2).split(",", -1)) {
                refs.add(new Relation(Long.parseLong(s)));
            }
            return Pair.create(n, refs);
        }
        m = Pattern.compile(".*Way (\\d+) is still used by relations? (\\d+(?:,\\d+)*).*").matcher(msg);
        if (m.matches()) {
            Way n = new Way(Long.parseLong(m.group(1)));
            for (String s : m.group(2).split(",", -1)) {
                refs.add(new Relation(Long.parseLong(s)));
            }
            return Pair.create(n, refs);
        }
        m = Pattern.compile(".*Way ([-]*\\d+) requires the nodes with id in (\\d+(?:,\\d+)*).*").matcher(msg);
        if (m.matches()) {
            OsmPrimitive n = OsmPrimitiveType.WAY.newInstance(Long.parseLong(m.group(1)), true);
            for (String s : m.group(2).split(",", -1)) {
                refs.add(new Node(Long.parseLong(s)));
            }
            return Pair.create(n, refs);
        }
        m = Pattern.compile(".*Relation ([-]*\\d+) requires the nodes with id in (\\d+(?:,\\d+)*).*").matcher(msg);
        if (m.matches()) {
            OsmPrimitive n = OsmPrimitiveType.RELATION.newInstance(Long.parseLong(m.group(1)), true);
            for (String s : m.group(2).split(",", -1)) {
                refs.add(new Node(Long.parseLong(s)));
            }
            return Pair.create(n, refs);
        }
        m = Pattern.compile(".*Relation ([-]*\\d+) requires the ways with id in (\\d+(?:,\\d+)*).*").matcher(msg);
        if (m.matches()) {
            OsmPrimitive n = OsmPrimitiveType.RELATION.newInstance(Long.parseLong(m.group(1)), true);
            for (String s : m.group(2).split(",", -1)) {
                refs.add(new Way(Long.parseLong(s)));
            }
            return Pair.create(n, refs);
        }
        return null;
    }

    public static String explainPreconditionFailed(OsmApiException e) {
        Logging.error(e);
        Pair<OsmPrimitive, Collection<OsmPrimitive>> conflict = ExceptionUtil.parsePreconditionFailed(e.getErrorHeader());
        if (conflict != null) {
            String refIdsString;
            OsmPrimitive firstRefs = (OsmPrimitive)((Collection)conflict.b).iterator().next();
            String objId = Long.toString(((OsmPrimitive)conflict.a).getUniqueId());
            Collection<Long> refIds = Utils.transform((Collection)conflict.b, AbstractPrimitive::getId);
            String string = refIdsString = refIds.size() == 1 ? refIds.iterator().next().toString() : refIds.toString();
            if (conflict.a instanceof Node) {
                if (firstRefs instanceof Way) {
                    return "<html>" + I18n.trn("<strong>Failed</strong> to delete <strong>node {0}</strong>. It is still referred to by way {1}.<br>Please load the way, remove the reference to the node, and upload again.", "<strong>Failed</strong> to delete <strong>node {0}</strong>. It is still referred to by ways {1}.<br>Please load the ways, remove the reference to the node, and upload again.", ((Collection)conflict.b).size(), objId, refIdsString) + "</html>";
                }
                if (firstRefs instanceof Relation) {
                    return "<html>" + I18n.trn("<strong>Failed</strong> to delete <strong>node {0}</strong>. It is still referred to by relation {1}.<br>Please load the relation, remove the reference to the node, and upload again.", "<strong>Failed</strong> to delete <strong>node {0}</strong>. It is still referred to by relations {1}.<br>Please load the relations, remove the reference to the node, and upload again.", ((Collection)conflict.b).size(), objId, refIdsString) + "</html>";
                }
                throw new IllegalStateException();
            }
            if (conflict.a instanceof Way) {
                if (firstRefs instanceof Node) {
                    return "<html>" + I18n.trn("<strong>Failed</strong> to upload <strong>way {0}</strong>. It refers to deleted node {1}.<br>Please load the node, remove the reference in the way, and upload again.", "<strong>Failed</strong> to upload <strong>way {0}</strong>. It refers to deleted nodes {1}.<br>Please load the nodes, remove the reference in the way, and upload again.", ((Collection)conflict.b).size(), objId, refIdsString) + "</html>";
                }
                if (firstRefs instanceof Relation) {
                    return "<html>" + I18n.trn("<strong>Failed</strong> to delete <strong>way {0}</strong>. It is still referred to by relation {1}.<br>Please load the relation, remove the reference to the way, and upload again.", "<strong>Failed</strong> to delete <strong>way {0}</strong>. It is still referred to by relations {1}.<br>Please load the relations, remove the reference to the way, and upload again.", ((Collection)conflict.b).size(), objId, refIdsString) + "</html>";
                }
                throw new IllegalStateException();
            }
            if (conflict.a instanceof Relation) {
                if (firstRefs instanceof Node) {
                    return "<html>" + I18n.trn("<strong>Failed</strong> to upload <strong>relation {0}</strong>. it refers to deleted node {1}.<br>Please load the node, remove the reference in the relation, and upload again.", "<strong>Failed</strong> to upload <strong>relation {0}</strong>. it refers to deleted nodes {1}.<br>Please load the nodes, remove the reference in the relation, and upload again.", ((Collection)conflict.b).size(), objId, refIdsString) + "</html>";
                }
                if (firstRefs instanceof Way) {
                    return "<html>" + I18n.trn("<strong>Failed</strong> to upload <strong>relation {0}</strong>. It refers to deleted way {1}.<br>Please load the way, remove the reference in the relation, and upload again.", "<strong>Failed</strong> to upload <strong>relation {0}</strong>. It refers to deleted ways {1}.<br>Please load the ways, remove the reference in the relation, and upload again.", ((Collection)conflict.b).size(), objId, refIdsString) + "</html>";
                }
                if (firstRefs instanceof Relation) {
                    return "<html>" + I18n.trn("<strong>Failed</strong> to delete <strong>relation {0}</strong>. It is still referred to by relation {1}.<br>Please load the relation, remove the reference to the relation, and upload again.", "<strong>Failed</strong> to delete <strong>relation {0}</strong>. It is still referred to by relations {1}.<br>Please load the relations, remove the reference to the relation, and upload again.", ((Collection)conflict.b).size(), objId, refIdsString) + "</html>";
                }
                throw new IllegalStateException();
            }
            throw new IllegalStateException();
        }
        return I18n.tr("<html>Uploading to the server <strong>failed</strong> because your current<br>dataset violates a precondition.<br>The error message is:<br>{0}</html>", Utils.escapeReservedCharactersHTML(e.getMessage()));
    }

    public static String explainFailedBasicAuthentication(OsmApiException e) {
        Logging.error(e);
        return I18n.tr("<html>Authentication at the OSM server with the username ''{0}'' failed.<br>Please check the username and the password in the JOSM preferences.</html>", e.getLogin() != null ? e.getLogin() : CredentialsManager.getInstance().getUsername());
    }

    public static String explainFailedOAuthAuthentication(OsmApiException e) {
        Logging.error(e);
        return I18n.tr("<html>Authentication at the OSM server with the OAuth token ''{0}'' failed.<br>Please launch the preferences dialog and retrieve another OAuth token.</html>", OAuthAccessTokenHolder.getInstance().getAccessTokenKey());
    }

    public static String explainFailedAuthorisation(OsmApiException e) {
        Logging.error(e);
        String msg = e.getDisplayMessage();
        if (msg != null && !msg.isEmpty()) {
            return I18n.tr("<html>Authorisation at the OSM server failed.<br>The server reported the following error:<br>''{0}''</html>", msg);
        }
        return I18n.tr("<html>Authorisation at the OSM server failed.<br></html>", new Object[0]);
    }

    public static String explainFailedOAuthAuthorisation(OsmApiException e) {
        Logging.error(e);
        return I18n.tr("<html>Authorisation at the OSM server with the OAuth token ''{0}'' failed.<br>The token is not authorised to access the protected resource<br>''{1}''.<br>Please launch the preferences dialog and retrieve another OAuth token.</html>", OAuthAccessTokenHolder.getInstance().getAccessTokenKey(), e.getAccessedUrl() == null ? I18n.tr("unknown", new Object[0]) : e.getAccessedUrl());
    }

    public static String explainClientTimeout(OsmApiException e) {
        Logging.error(e);
        return I18n.tr("<html>Communication with the OSM server ''{0}'' timed out. Please retry later.</html>", ExceptionUtil.getUrlFromException(e));
    }

    public static String explainGenericOsmApiException(OsmApiException e) {
        Logging.error(e);
        Object[] objectArray = new Object[3];
        objectArray[0] = ExceptionUtil.getUrlFromException(e);
        objectArray[1] = e.getResponseCode();
        objectArray[2] = Optional.ofNullable(Optional.ofNullable(e.getErrorHeader()).orElseGet(e::getErrorBody)).orElse(I18n.tr("no error message available", new Object[0]));
        return I18n.tr("<html>Communication with the OSM server ''{0}''failed. The server replied<br>the following error code and the following error message:<br><strong>Error code:<strong> {1}<br><strong>Error message (untranslated)</strong>: {2}</html>", objectArray);
    }

    public static String explainConflict(OsmApiException e) {
        Logging.error(e);
        String msg = e.getErrorHeader();
        if (msg != null) {
            Matcher m = Pattern.compile("The changeset (\\d+) was closed at (.*)").matcher(msg);
            if (m.matches()) {
                long changesetId = Long.parseLong(m.group(1));
                Date closeDate = null;
                try {
                    closeDate = DateUtils.newOsmApiDateTimeFormat().parse(m.group(2));
                }
                catch (ParseException ex) {
                    Logging.error(I18n.tr("Failed to parse date ''{0}'' replied by server.", m.group(2)));
                    Logging.error(ex);
                }
                msg = closeDate == null ? I18n.tr("<html>Closing of changeset <strong>{0}</strong> failed <br>because it has already been closed.", changesetId) : I18n.tr("<html>Closing of changeset <strong>{0}</strong> failed<br> because it has already been closed on {1}.", changesetId, DateUtils.formatDateTime(closeDate, 2, 2));
                return msg;
            }
            msg = I18n.tr("<html>The server reported that it has detected a conflict.<br>Error message (untranslated):<br>{0}</html>", msg);
        } else {
            msg = I18n.tr("<html>The server reported that it has detected a conflict.", new Object[0]);
        }
        return msg.endsWith("</html>") ? msg : msg + "</html>";
    }

    public static String explainChangesetClosedException(ChangesetClosedException e) {
        Logging.error(e);
        return I18n.tr("<html>Failed to upload to changeset <strong>{0}</strong><br>because it has already been closed on {1}.", e.getChangesetId(), e.getClosedOn() == null ? "?" : DateUtils.formatDateTime(e.getClosedOn(), 2, 2));
    }

    public static String explainGeneric(Exception e) {
        String msg = e.getMessage();
        if (msg == null || msg.trim().isEmpty()) {
            msg = e.toString();
        }
        Logging.error(e);
        return Utils.escapeReservedCharactersHTML(msg);
    }

    public static String explainSecurityException(OsmTransferException e) {
        String apiUrl = e.getUrl();
        String host = I18n.tr("unknown", new Object[0]);
        try {
            host = new URL(apiUrl).getHost();
        }
        catch (MalformedURLException ex) {
            Logging.trace(ex);
        }
        return I18n.tr("<html>Failed to open a connection to the remote server<br>''{0}''<br>for security reasons. This is most likely because you are running<br>in an applet and because you did not load your applet from ''{1}''.", apiUrl, host) + "</html>";
    }

    public static String explainNestedSocketException(OsmTransferException e) {
        Logging.error(e);
        return I18n.tr("<html>Failed to open a connection to the remote server<br>''{0}''.<br>Please check your internet connection.", e.getUrl()) + "</html>";
    }

    public static String explainNestedIOException(OsmTransferException e) {
        IOException ioe = ExceptionUtil.getNestedException(e, IOException.class);
        Logging.error(e);
        return I18n.tr("<html>Failed to upload data to or download data from<br>''{0}''<br>due to a problem with transferring data.<br>Details (untranslated): {1}</html>", e != null ? e.getUrl() : "null", ioe != null ? ioe.getMessage() : "null");
    }

    public static String explainNestedIllegalDataException(OsmTransferException e) {
        IllegalDataException ide = ExceptionUtil.getNestedException(e, IllegalDataException.class);
        Logging.error(e);
        return I18n.tr("<html>Failed to download data. Its format is either unsupported, ill-formed, and/or inconsistent.<br><br>Details (untranslated): {0}</html>", ide != null ? ide.getMessage() : "null");
    }

    public static String explainOfflineAccessException(OsmTransferException e) {
        OfflineAccessException oae = ExceptionUtil.getNestedException(e, OfflineAccessException.class);
        Logging.error(e);
        return I18n.tr("<html>Failed to download data.<br><br>Details: {0}</html>", oae != null ? oae.getMessage() : "null");
    }

    public static String explainInternalServerError(OsmTransferException e) {
        Logging.error(e);
        return I18n.tr("<html>The OSM server<br>''{0}''<br>reported an internal server error.<br>This is most likely a temporary problem. Please try again later.", e.getUrl()) + "</html>";
    }

    public static String explainBadRequest(OsmApiException e) {
        String message = I18n.tr("The OSM server ''{0}'' reported a bad request.<br>", ExceptionUtil.getUrlFromException(e));
        String errorHeader = e.getErrorHeader();
        if (errorHeader != null && (errorHeader.startsWith("The maximum bbox") || errorHeader.startsWith("You requested too many nodes"))) {
            message = message + "<br>" + I18n.tr("The area you tried to download is too big or your request was too large.<br>Either request a smaller area or use an export file provided by the OSM community.", new Object[0]);
        } else if (errorHeader != null) {
            message = message + I18n.tr("<br>Error message(untranslated): {0}", errorHeader);
        }
        Logging.error(e);
        return "<html>" + message + "</html>";
    }

    public static String explainBandwidthLimitExceeded(OsmApiException e) {
        Logging.error(e);
        return ExceptionUtil.explainGenericOsmApiException(e);
    }

    public static String explainNotFound(OsmApiException e) {
        String message = I18n.tr("The OSM server ''{0}'' does not know about an object<br>you tried to read, update, or delete. Either the respective object<br>does not exist on the server or you are using an invalid URL to access<br>it. Please carefully check the server''s address ''{0}'' for typos.", ExceptionUtil.getUrlFromException(e));
        Logging.error(e);
        return "<html>" + message + "</html>";
    }

    public static String explainNestedUnknownHostException(OsmTransferException e) {
        String apiUrl = e.getUrl();
        String host = I18n.tr("unknown", new Object[0]);
        try {
            host = new URL(apiUrl).getHost();
        }
        catch (MalformedURLException ex) {
            Logging.trace(e);
        }
        Logging.error(e);
        return I18n.tr("<html>Failed to open a connection to the remote server<br>''{0}''.<br>Host name ''{1}'' could not be resolved. <br>Please check the API URL in your preferences and your internet connection.", apiUrl, host) + "</html>";
    }

    public static <T> T getNestedException(Exception e, Class<T> nestedClass) {
        Throwable t;
        for (t = e; t != null && !nestedClass.isInstance(t); t = t.getCause()) {
        }
        if (t == null) {
            return null;
        }
        if (nestedClass.isInstance(t)) {
            return nestedClass.cast(t);
        }
        return null;
    }

    public static String explainOsmTransferException(OsmTransferException e) {
        Objects.requireNonNull(e, "e");
        if (ExceptionUtil.getNestedException(e, SecurityException.class) != null) {
            return ExceptionUtil.explainSecurityException(e);
        }
        if (ExceptionUtil.getNestedException(e, SocketException.class) != null) {
            return ExceptionUtil.explainNestedSocketException(e);
        }
        if (ExceptionUtil.getNestedException(e, UnknownHostException.class) != null) {
            return ExceptionUtil.explainNestedUnknownHostException(e);
        }
        if (ExceptionUtil.getNestedException(e, IOException.class) != null) {
            return ExceptionUtil.explainNestedIOException(e);
        }
        if (e instanceof OsmApiInitializationException) {
            return ExceptionUtil.explainOsmApiInitializationException((OsmApiInitializationException)e);
        }
        if (e instanceof ChangesetClosedException) {
            return ExceptionUtil.explainChangesetClosedException((ChangesetClosedException)e);
        }
        if (e instanceof OsmApiException) {
            OsmApiException oae = (OsmApiException)e;
            if (oae.getResponseCode() == 412) {
                return ExceptionUtil.explainPreconditionFailed(oae);
            }
            if (oae.getResponseCode() == 410) {
                return ExceptionUtil.explainGoneForUnknownPrimitive(oae);
            }
            if (oae.getResponseCode() == 500) {
                return ExceptionUtil.explainInternalServerError(oae);
            }
            if (oae.getResponseCode() == 400) {
                return ExceptionUtil.explainBadRequest(oae);
            }
            if (oae.getResponseCode() == 509) {
                return ExceptionUtil.explainBandwidthLimitExceeded(oae);
            }
        }
        return ExceptionUtil.explainGeneric(e);
    }

    public static String explainGoneForUnknownPrimitive(OsmApiException e) {
        return I18n.tr("<html>The server reports that an object is deleted.<br><strong>Uploading failed</strong> if you tried to update or delete this object.<br> <strong>Downloading failed</strong> if you tried to download this object.<br><br>The error message is:<br>{0}</html>", Utils.escapeReservedCharactersHTML(e.getMessage()));
    }

    public static String explainException(Exception e) {
        Logging.error(e);
        if (e instanceof OsmTransferException) {
            return ExceptionUtil.explainOsmTransferException((OsmTransferException)e);
        }
        return ExceptionUtil.explainGeneric(e);
    }

    public static boolean isUserBlocked(OsmApiException e) {
        return OSM_API_BLOCK_MESSAGES.contains(e.getErrorHeader());
    }

    static String getUrlFromException(OsmApiException e) {
        if (e.getAccessedUrl() != null) {
            try {
                return new URL(e.getAccessedUrl()).getHost();
            }
            catch (MalformedURLException e1) {
                Logging.warn(e1);
            }
        }
        if (e.getUrl() != null) {
            return e.getUrl();
        }
        return OsmApi.getOsmApi().getBaseUrl();
    }
}

