/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.bouncycastle.tls.PskIdentity;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class OfferedPsks {
    protected Vector identities;
    protected Vector binders;

    public OfferedPsks(Vector vector, Vector vector2) {
        if (null == vector || vector.isEmpty()) {
            throw new IllegalArgumentException("'identities' cannot be null or empty");
        }
        if (null == vector2 || vector.size() != vector2.size()) {
            throw new IllegalArgumentException("'binders' must be non-null and the same length as 'identities'");
        }
        this.identities = vector;
        this.binders = vector2;
    }

    public Vector getBinders() {
        return this.binders;
    }

    public Vector getIdentities() {
        return this.identities;
    }

    public void encode(OutputStream outputStream) throws IOException {
        Object object;
        int n;
        int n2 = 0;
        for (n = 0; n < this.identities.size(); ++n) {
            object = (PskIdentity)this.identities.elementAt(n);
            n2 += 2 + ((PskIdentity)object).getIdentity().length + 4;
        }
        TlsUtils.checkUint16(n2);
        TlsUtils.writeUint16(n2, outputStream);
        for (n = 0; n < this.identities.size(); ++n) {
            object = (PskIdentity)this.identities.elementAt(n);
            ((PskIdentity)object).encode(outputStream);
        }
        n2 = 0;
        for (n = 0; n < this.binders.size(); ++n) {
            object = (byte[])this.binders.elementAt(n);
            n2 += 1 + ((Object)object).length;
        }
        TlsUtils.checkUint16(n2);
        TlsUtils.writeUint16(n2, outputStream);
        for (n = 0; n < this.binders.size(); ++n) {
            object = (byte[])this.binders.elementAt(n);
            TlsUtils.writeOpaque8((byte[])object, outputStream);
        }
    }

    public static OfferedPsks parse(InputStream inputStream) throws IOException {
        Object object;
        Vector<PskIdentity> vector = new Vector<PskIdentity>();
        int n = TlsUtils.readUint16(inputStream);
        if (n < 7) {
            throw new TlsFatalAlert(50);
        }
        byte[] byArray = TlsUtils.readFully(n, inputStream);
        Object object2 = new ByteArrayInputStream(byArray);
        do {
            object = PskIdentity.parse((InputStream)object2);
            vector.add((PskIdentity)object);
        } while (((ByteArrayInputStream)object2).available() > 0);
        Vector<byte[]> vector2 = new Vector<byte[]>();
        int n2 = TlsUtils.readUint16(inputStream);
        if (n2 < 33) {
            throw new TlsFatalAlert(50);
        }
        object2 = TlsUtils.readFully(n2, inputStream);
        object = new ByteArrayInputStream((byte[])object2);
        do {
            byte[] byArray2 = TlsUtils.readOpaque8(inputStream, 32);
            vector2.add(byArray2);
        } while (((ByteArrayInputStream)object).available() > 0);
        return new OfferedPsks(vector, vector2);
    }
}

