/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyNameError;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.NoMethodError;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ArraySupport;

@JRubyClass(name={"NoMethodError"}, parent="NameError")
public class RubyNoMethodError
extends RubyNameError {
    private IRubyObject args;
    private static final ObjectAllocator ALLOCATOR = (runtime2, klass) -> new RubyNoMethodError(runtime2, klass);

    static RubyClass define(Ruby runtime2, RubyClass nameErrorClass) {
        RubyClass noMethodErrorClass = runtime2.defineClass("NoMethodError", nameErrorClass, ALLOCATOR);
        noMethodErrorClass.defineAnnotatedMethods(RubyNoMethodError.class);
        return noMethodErrorClass;
    }

    protected RubyNoMethodError(Ruby runtime2, RubyClass exceptionClass) {
        super(runtime2, exceptionClass, exceptionClass.getName());
        this.args = runtime2.getNil();
    }

    public RubyNoMethodError(Ruby runtime2, RubyClass exceptionClass, String message2, String name2, IRubyObject args2) {
        super(runtime2, exceptionClass, message2, name2);
        this.args = args2;
    }

    @Override
    protected RaiseException constructThrowable(String message2) {
        return new NoMethodError(message2, this);
    }

    public static RubyException newNoMethodError(IRubyObject recv2, IRubyObject message2, IRubyObject name2, IRubyObject args2) {
        RubyClass klass = (RubyClass)recv2;
        RubyException newError = (RubyException)klass.allocate();
        newError.callInit(message2, name2, args2, Block.NULL_BLOCK);
        return newError;
    }

    public static RubyException newNoMethodError(IRubyObject recv2, IRubyObject message2, IRubyObject name2, IRubyObject args2, boolean privateCall) {
        RubyClass klass = (RubyClass)recv2;
        RubyNoMethodError newError = (RubyNoMethodError)klass.allocate();
        newError.callInit(message2, name2, args2, Block.NULL_BLOCK);
        newError.privateCall = privateCall;
        return newError;
    }

    @Override
    @JRubyMethod(rest=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] args2, Block block) {
        if (args2.length > 2) {
            this.args = args2[args2.length - 1];
            args2 = ArraySupport.newCopy(args2, args2.length - 1);
        } else {
            this.args = this.getRuntime().getNil();
        }
        super.initialize(args2, block);
        return this;
    }

    @JRubyMethod
    public IRubyObject args() {
        return this.args;
    }

    @Override
    public void copySpecialInstanceVariables(IRubyObject clone2) {
        super.copySpecialInstanceVariables(clone2);
        RubyNoMethodError exception2 = (RubyNoMethodError)clone2;
        exception2.args = this.args;
    }
}

