/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.CallingConvention;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.AbstractInvoker;
import org.jruby.ext.ffi.AllocatedDirectMemoryIO;
import org.jruby.ext.ffi.Enums;
import org.jruby.ext.ffi.FreedMemoryIO;
import org.jruby.ext.ffi.InvalidMemoryIO;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.Pointer;
import org.jruby.ext.ffi.Type;
import org.jruby.ext.ffi.Util;
import org.jruby.ext.ffi.jffi.CallbackManager;
import org.jruby.ext.ffi.jffi.CodeMemoryIO;
import org.jruby.ext.ffi.jffi.MethodFactory;
import org.jruby.ext.ffi.jffi.NativeFunctionInfo;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"FFI::Function"}, parent="FFI::Pointer")
public final class Function
extends AbstractInvoker {
    private final com.kenai.jffi.Function function;
    private final NativeFunctionInfo functionInfo;
    private final IRubyObject enums;
    private final boolean saveError;
    private volatile boolean autorelease = true;

    public static RubyClass createFunctionClass(Ruby runtime2, RubyModule module) {
        RubyClass result2 = module.defineClassUnder("Function", module.getClass("Pointer"), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        result2.defineAnnotatedMethods(AbstractInvoker.class);
        result2.defineAnnotatedMethods(Function.class);
        result2.defineAnnotatedConstants(Function.class);
        return result2;
    }

    Function(Ruby runtime2, RubyClass klass, MemoryIO address2, Type returnType, Type[] parameterTypes, CallingConvention convention, IRubyObject enums, boolean saveError) {
        super(runtime2, klass, parameterTypes.length, address2);
        this.functionInfo = new NativeFunctionInfo(runtime2, returnType, parameterTypes, convention);
        this.function = new com.kenai.jffi.Function(address2.address(), this.functionInfo.jffiReturnType, this.functionInfo.jffiParameterTypes, this.functionInfo.convention, saveError);
        this.enums = enums;
        this.saveError = saveError;
        this.getSingletonClass().addMethod("call", this.createDynamicMethod(this.getSingletonClass()));
    }

    Function(Ruby runtime2, RubyClass klass, MemoryIO address2, NativeFunctionInfo functionInfo, IRubyObject enums) {
        super(runtime2, klass, functionInfo.parameterTypes.length, address2);
        this.functionInfo = functionInfo;
        this.function = new com.kenai.jffi.Function(address2.address(), functionInfo.jffiReturnType, functionInfo.jffiParameterTypes, functionInfo.convention);
        this.enums = enums;
        this.saveError = true;
        this.getSingletonClass().addMethod("call", this.createDynamicMethod(this.getSingletonClass()));
    }

    @JRubyMethod(name={"new"}, meta=true, required=2, optional=2)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        CallingConvention callConvention;
        InvalidMemoryIO fptr = null;
        RubyHash options2 = null;
        Object proc2 = null;
        int optionsIndex = 2;
        Type returnType = Util.findType(context, args2[0]);
        if (!(args2[1] instanceof RubyArray)) {
            throw context.runtime.newTypeError("Invalid parameter array " + args2[1].getMetaClass().getName() + " (expected Array)");
        }
        RubyArray paramTypes = (RubyArray)args2[1];
        Type[] parameterTypes = new Type[paramTypes.size()];
        for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
            parameterTypes[i2] = Util.findType(context, paramTypes.entry(i2));
        }
        if (args2.length > 2 && args2[2] instanceof Pointer) {
            fptr = new CodeMemoryIO(context.runtime, (Pointer)args2[2]);
            optionsIndex = 3;
        } else if (args2.length > 2 && (args2[2] instanceof RubyProc || args2[2].respondsTo("call"))) {
            proc2 = args2[2];
            optionsIndex = 3;
        } else if (block.isGiven()) {
            proc2 = block;
            optionsIndex = 2;
        } else {
            throw context.runtime.newTypeError("Invalid function address " + args2[0].getMetaClass().getName() + " (expected FFI::Pointer)");
        }
        String convention = "default";
        IRubyObject enums = null;
        boolean saveError = true;
        if (args2.length > optionsIndex && args2[optionsIndex] instanceof RubyHash) {
            IRubyObject rbSaveErrno;
            options2 = (RubyHash)args2[optionsIndex];
            IRubyObject rbConvention = options2.fastARef(context.runtime.newSymbol("convention"));
            if (rbConvention != null && !rbConvention.isNil()) {
                convention = rbConvention.asJavaString();
            }
            if ((rbSaveErrno = options2.fastARef(context.runtime.newSymbol("save_errno"))) != null && !rbSaveErrno.isNil()) {
                saveError = rbSaveErrno.isTrue();
            }
            if (!((enums = options2.fastARef(context.runtime.newSymbol("enums"))) == null || enums.isNil() || enums instanceof RubyHash || enums instanceof Enums)) {
                throw context.runtime.newTypeError("wrong type for options[:enum] " + enums.getMetaClass().getName() + " (expected Hash or Enums)");
            }
        }
        CallingConvention callingConvention = callConvention = "stdcall".equals(convention) ? CallingConvention.STDCALL : CallingConvention.DEFAULT;
        if (fptr == null && proc2 != null) {
            fptr = CallbackManager.getInstance().newClosure(context.runtime, returnType, parameterTypes, proc2, callConvention);
        }
        return new Function(context.runtime, (RubyClass)recv2, fptr, returnType, parameterTypes, callConvention, enums, saveError);
    }

    @JRubyMethod(name={"free"})
    public final IRubyObject free(ThreadContext context) {
        if (!(this.getMemoryIO() instanceof AllocatedDirectMemoryIO)) {
            throw context.runtime.newRuntimeError("cannot free non-allocated function");
        }
        ((AllocatedDirectMemoryIO)((Object)this.getMemoryIO())).free();
        this.setMemoryIO(new FreedMemoryIO(context.runtime));
        return context.nil;
    }

    @JRubyMethod(name={"autorelease="}, required=1)
    public final IRubyObject autorelease(ThreadContext context, IRubyObject release) {
        if (this.autorelease != release.isTrue() && this.getMemoryIO() instanceof AllocatedDirectMemoryIO) {
            this.autorelease = release.isTrue();
            ((AllocatedDirectMemoryIO)((Object)this.getMemoryIO())).setAutoRelease(this.autorelease);
        }
        return context.nil;
    }

    @JRubyMethod(name={"autorelease?", "autorelease"})
    public final IRubyObject autorelease_p(ThreadContext context) {
        return RubyBoolean.newBoolean(context, this.autorelease);
    }

    @Override
    public DynamicMethod createDynamicMethod(RubyModule module) {
        return MethodFactory.createDynamicMethod(this.getRuntime(), module, this.function, this.functionInfo.returnType, this.functionInfo.parameterTypes, this.functionInfo.convention, this.enums, !this.saveError);
    }
}

