/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ripper;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ripper.RipperParser;
import org.jruby.ext.ripper.RipperParserBase;
import org.jruby.ext.ripper.SyntaxException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.lexer.ByteListLexerSource;
import org.jruby.lexer.GetsLexerSource;
import org.jruby.lexer.LexerSource;
import org.jruby.lexer.LexingCommon;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyRipper
extends RubyObject {
    private RipperParserBase parser = null;
    private IRubyObject filename = null;
    private boolean parseStarted = false;
    private static int singleStateLexStateNames = 13;
    private static String[] lexStateNames = new String[]{"EXPR_BEG", "EXPR_END", "EXPR_ENDARG", "EXPR_ENDFN", "EXPR_ARG", "EXPR_CMDARG", "EXPR_MID", "EXPR_FNAME", "EXPR_DOT", "EXPR_CLASS", "EXPR_LABEL", "EXPR_LABELED", "EXPR_FITEM", "EXPR_VALUE", "EXPR_BEG_ANY", "EXPR_ARG_ANY", "EXPR_END_ANY"};
    private static int[] lexStateValues = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 1, 577, 48, 14};

    public static void initRipper(Ruby runtime2) {
        RubyClass ripper2 = runtime2.defineClass("Ripper", runtime2.getObject(), new ObjectAllocator(){

            @Override
            public IRubyObject allocate(Ruby runtime2, RubyClass klazz) {
                return new RubyRipper(runtime2, klazz);
            }
        });
        ripper2.defineConstant("SCANNER_EVENT_TABLE", RubyRipper.createScannerEventTable(runtime2, ripper2));
        ripper2.defineConstant("PARSER_EVENT_TABLE", RubyRipper.createParserEventTable(runtime2, ripper2));
        RubyRipper.defineLexStateConstants(runtime2, ripper2);
        ripper2.defineAnnotatedMethods(RubyRipper.class);
    }

    private static void defineLexStateConstants(Ruby runtime2, RubyClass ripper2) {
        for (int i2 = 0; i2 < lexStateNames.length; ++i2) {
            ripper2.defineConstant(lexStateNames[i2], runtime2.newFixnum(lexStateValues[i2]));
        }
    }

    private static IRubyObject createScannerEventTable(Ruby runtime2, RubyClass ripper2) {
        RubyHash hash2 = new RubyHash(runtime2);
        hash2.fastASet(runtime2.newSymbol("CHAR"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("__end__"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("backref"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("backtick"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("comma"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("comment"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("const"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("cvar"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("embdoc"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("embdoc_beg"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("embdoc_end"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("embexpr_beg"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("embexpr_end"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("embvar"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("float"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("gvar"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("heredoc_beg"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("heredoc_end"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("ident"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("ignored_nl"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("imaginary"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("int"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("ivar"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("kw"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("label"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("label_end"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("lbrace"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("lbracket"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("lparen"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("nl"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("op"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("period"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("qsymbols_beg"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("qwords_beg"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("rational"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("rbrace"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("rbracket"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("regexp_beg"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("regexp_end"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("rparen"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("semicolon"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("sp"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("symbeg"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("symbols_beg"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("tlambda"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("tlambeg"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("tstring_beg"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("tstring_content"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("tstring_end"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("words_beg"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("words_sep"), runtime2.newFixnum(1));
        return hash2;
    }

    private static IRubyObject createParserEventTable(Ruby runtime2, RubyClass ripper2) {
        RubyHash hash2 = new RubyHash(runtime2);
        hash2.fastASet(runtime2.newSymbol("BEGIN"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("END"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("alias"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("alias_error"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("aref"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("aref_field"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("arg_ambiguous"), runtime2.newFixnum(0));
        hash2.fastASet(runtime2.newSymbol("arg_paren"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("args_add"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("args_add_block"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("args_add_star"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("args_new"), runtime2.newFixnum(0));
        hash2.fastASet(runtime2.newSymbol("array"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("assign"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("assign_error"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("assoc_new"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("assoc_splat"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("assoclist_from_args"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("bare_assoc_hash"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("begin"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("binary"), runtime2.newFixnum(3));
        hash2.fastASet(runtime2.newSymbol("block_var"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("block_var_add_block"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("block_var_add_star"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("blockarg"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("bodystmt"), runtime2.newFixnum(4));
        hash2.fastASet(runtime2.newSymbol("brace_block"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("break"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("call"), runtime2.newFixnum(3));
        hash2.fastASet(runtime2.newSymbol("case"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("class"), runtime2.newFixnum(3));
        hash2.fastASet(runtime2.newSymbol("class_name_error"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("command"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("command_call"), runtime2.newFixnum(4));
        hash2.fastASet(runtime2.newSymbol("const_path_field"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("const_path_ref"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("const_ref"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("def"), runtime2.newFixnum(3));
        hash2.fastASet(runtime2.newSymbol("defined"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("defs"), runtime2.newFixnum(5));
        hash2.fastASet(runtime2.newSymbol("do_block"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("dot2"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("dot3"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("dyna_symbol"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("else"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("elsif"), runtime2.newFixnum(3));
        hash2.fastASet(runtime2.newSymbol("ensure"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("excessed_comma"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("fcall"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("field"), runtime2.newFixnum(3));
        hash2.fastASet(runtime2.newSymbol("for"), runtime2.newFixnum(3));
        hash2.fastASet(runtime2.newSymbol("hash"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("heredoc_dedent"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("if"), runtime2.newFixnum(3));
        hash2.fastASet(runtime2.newSymbol("if_mod"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("ifop"), runtime2.newFixnum(3));
        hash2.fastASet(runtime2.newSymbol("kwrest_param"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("lambda"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("magic_comment"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("massign"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("method_add_arg"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("method_add_block"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("mlhs_add"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("mlhs_add_post"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("mlhs_add_star"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("mlhs_new"), runtime2.newFixnum(0));
        hash2.fastASet(runtime2.newSymbol("mlhs_paren"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("module"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("mrhs_add"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("mrhs_add_star"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("mrhs_new"), runtime2.newFixnum(0));
        hash2.fastASet(runtime2.newSymbol("mrhs_new_from_args"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("next"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("opassign"), runtime2.newFixnum(3));
        hash2.fastASet(runtime2.newSymbol("operator_ambiguous"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("param_error"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("params"), runtime2.newFixnum(7));
        hash2.fastASet(runtime2.newSymbol("paren"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("parse_error"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("program"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("qsymbols_add"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("qsymbols_new"), runtime2.newFixnum(0));
        hash2.fastASet(runtime2.newSymbol("qwords_add"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("qwords_new"), runtime2.newFixnum(0));
        hash2.fastASet(runtime2.newSymbol("redo"), runtime2.newFixnum(0));
        hash2.fastASet(runtime2.newSymbol("regexp_add"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("regexp_literal"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("regexp_new"), runtime2.newFixnum(0));
        hash2.fastASet(runtime2.newSymbol("rescue"), runtime2.newFixnum(4));
        hash2.fastASet(runtime2.newSymbol("rescue_mod"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("rest_param"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("retry"), runtime2.newFixnum(0));
        hash2.fastASet(runtime2.newSymbol("return"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("return0"), runtime2.newFixnum(0));
        hash2.fastASet(runtime2.newSymbol("sclass"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("stmts_add"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("stmts_new"), runtime2.newFixnum(0));
        hash2.fastASet(runtime2.newSymbol("string_add"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("string_concat"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("string_content"), runtime2.newFixnum(0));
        hash2.fastASet(runtime2.newSymbol("string_dvar"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("string_embexpr"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("string_literal"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("super"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("symbol"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("symbol_literal"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("symbols_add"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("symbols_new"), runtime2.newFixnum(0));
        hash2.fastASet(runtime2.newSymbol("top_const_field"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("top_const_ref"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("unary"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("undef"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("unless"), runtime2.newFixnum(3));
        hash2.fastASet(runtime2.newSymbol("unless_mod"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("until"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("until_mod"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("var_alias"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("var_field"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("var_ref"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("vcall"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("void_stmt"), runtime2.newFixnum(0));
        hash2.fastASet(runtime2.newSymbol("when"), runtime2.newFixnum(3));
        hash2.fastASet(runtime2.newSymbol("while"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("while_mod"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("word_add"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("word_new"), runtime2.newFixnum(0));
        hash2.fastASet(runtime2.newSymbol("words_add"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("words_new"), runtime2.newFixnum(0));
        hash2.fastASet(runtime2.newSymbol("xstring_add"), runtime2.newFixnum(2));
        hash2.fastASet(runtime2.newSymbol("xstring_literal"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("xstring_new"), runtime2.newFixnum(0));
        hash2.fastASet(runtime2.newSymbol("yield"), runtime2.newFixnum(1));
        hash2.fastASet(runtime2.newSymbol("yield0"), runtime2.newFixnum(0));
        hash2.fastASet(runtime2.newSymbol("zsuper"), runtime2.newFixnum(0));
        return hash2;
    }

    private RubyRipper(Ruby runtime2, RubyClass klazz) {
        super(runtime2, klazz);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject src) {
        return this.initialize(context, src, null, null);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject src, IRubyObject file2) {
        return this.initialize(context, src, file2, null);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject src, IRubyObject file2, IRubyObject line) {
        this.filename = this.filenameAsString(context, file2).dup();
        this.parser = new RipperParser(context, this, this.source(context, src, this.filename.asJavaString(), this.lineAsInt(context, line)));
        return context.nil;
    }

    @JRubyMethod
    public IRubyObject column(ThreadContext context) {
        if (!this.parser.hasStarted()) {
            throw context.runtime.newArgumentError("method called for uninitialized object");
        }
        if (!this.parseStarted) {
            return context.nil;
        }
        return context.runtime.newFixnum(this.parser.getColumn());
    }

    @JRubyMethod
    public IRubyObject encoding(ThreadContext context) {
        return context.runtime.getEncodingService().getEncoding(this.parser.encoding());
    }

    @JRubyMethod(name={"end_seen?"})
    public IRubyObject end_seen_p(ThreadContext context) {
        return RubyBoolean.newBoolean(context, this.parser.isEndSeen());
    }

    @JRubyMethod(name={"error?"})
    public IRubyObject error_p(ThreadContext context) {
        return RubyBoolean.newBoolean(context, this.parser.isError());
    }

    @JRubyMethod
    public IRubyObject filename(ThreadContext context) {
        return this.filename;
    }

    @JRubyMethod
    public IRubyObject lineno(ThreadContext context) {
        if (!this.parser.hasStarted()) {
            throw context.runtime.newArgumentError("method called for uninitialized object");
        }
        if (!this.parseStarted) {
            return context.nil;
        }
        return context.runtime.newFixnum(this.parser.getLineno());
    }

    @JRubyMethod
    public IRubyObject state(ThreadContext context) {
        int state2 = this.parser.getState();
        return state2 == 0 ? context.nil : context.runtime.newFixnum(this.parser.getState());
    }

    @JRubyMethod
    public IRubyObject parse(ThreadContext context) {
        this.parseStarted = true;
        try {
            return this.parser.parse(true);
        }
        catch (IOException e) {
            System.out.println("ERRROR: " + e);
        }
        catch (SyntaxException syntaxException) {
            // empty catch block
        }
        return context.nil;
    }

    @JRubyMethod
    public IRubyObject yydebug(ThreadContext context) {
        return RubyBoolean.newBoolean(context, this.parser.getYYDebug());
    }

    @JRubyMethod(name={"yydebug="})
    public IRubyObject yydebug_set(ThreadContext context, IRubyObject arg2) {
        this.parser.setYYDebug(arg2.isTrue());
        return arg2;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject dedent_string(ThreadContext context, IRubyObject self2, IRubyObject _input, IRubyObject _width) {
        RubyString input = _input.convertToString();
        int wid = _width.convertToInteger().getIntValue();
        input.modify19();
        int col = LexingCommon.dedent_string(input.getByteList(), wid);
        return context.runtime.newFixnum(col);
    }

    @JRubyMethod
    public IRubyObject dedent_string(ThreadContext context, IRubyObject _input, IRubyObject _width) {
        return RubyRipper.dedent_string(context, this, _input, _width);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject lex_state_name(ThreadContext context, IRubyObject self2, IRubyObject lexStateParam) {
        int lexState = lexStateParam.convertToInteger().getIntValue();
        boolean needsSeparator = false;
        RubyString name2 = null;
        for (int i2 = 0; i2 < singleStateLexStateNames; ++i2) {
            if ((lexState & lexStateValues[i2]) == 0) continue;
            if (!needsSeparator) {
                name2 = context.runtime.newString(lexStateNames[i2]);
                needsSeparator = true;
                continue;
            }
            name2.cat(124);
            name2.catString(lexStateNames[i2]);
        }
        if (name2 == null) {
            name2 = context.runtime.newString("EXPR_NONE");
        }
        return name2;
    }

    private LexerSource source(ThreadContext context, IRubyObject src, String filename2, int lineno2) {
        DynamicMethod method2 = src.getMetaClass().searchMethod("gets");
        if (method2.isUndefined() || method2.getVisibility() == Visibility.PRIVATE) {
            return new ByteListLexerSource(filename2, lineno2, src.convertToString().getByteList(), null);
        }
        return new GetsLexerSource(filename2, lineno2, src, null);
    }

    private IRubyObject filenameAsString(ThreadContext context, IRubyObject filename2) {
        if (filename2 == null || filename2.isNil()) {
            return context.runtime.newString("(ripper)");
        }
        return filename2.convertToString();
    }

    private int lineAsInt(ThreadContext context, IRubyObject line) {
        if (line == null || line.isNil()) {
            return 0;
        }
        return RubyNumeric.fix2int(line.convertToInteger()) - 1;
    }
}

