/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.RubySymbol;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Interp;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.OneOperandResultBaseInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class SetCapturedVarInstr
extends OneOperandResultBaseInstr
implements FixedArityInstr {
    private final RubySymbol variableName;

    public SetCapturedVarInstr(Variable result2, Operand match2Result, RubySymbol variableName) {
        super(Operation.SET_CAPTURED_VAR, result2, match2Result);
        assert (result2 != null) : "SetCapturedVarInstr result is null";
        this.variableName = variableName;
    }

    public Operand getMatch2Result() {
        return this.getOperand1();
    }

    public String getId() {
        return this.variableName.idString();
    }

    public RubySymbol getName() {
        return this.variableName;
    }

    @Override
    public String[] toStringNonOperandArgs() {
        return new String[]{"name: " + this.getName()};
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new SetCapturedVarInstr(ii.getRenamedVariable(this.result), this.getMatch2Result().cloneForInlining(ii), this.getName());
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getMatch2Result());
        e.encode(this.getName());
    }

    public static SetCapturedVarInstr decode(IRReaderDecoder d) {
        return new SetCapturedVarInstr(d.decodeVariable(), d.decodeOperand(), d.decodeSymbol());
    }

    @Override
    @Interp
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        IRubyObject matchRes = (IRubyObject)this.getMatch2Result().retrieve(context, self2, currScope, currDynScope, temp);
        return IRRuntimeHelpers.setCapturedVar(context, matchRes, this.getId());
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.SetCapturedVarInstr(this);
    }
}

