/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.bsf;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;

public class BSFExample {
    private BSFManager manager;

    public static void main(String[] args2) {
        BSFManager.registerScriptingEngine((String)"ruby", (String)"org.jruby.javasupport.bsf.JRubyEngine", (String[])new String[]{"rb"});
        new BSFExample(new BSFManager());
    }

    public BSFExample(BSFManager manager) {
        this.manager = manager;
        this.initUI();
    }

    private void initUI() {
        final JFrame frame = new JFrame("A sample BSF application");
        JMenuBar menubar = new JMenuBar();
        final JTextArea input = new JTextArea("$frame.setTitle(\"A new title\")");
        JButton execute = new JButton("Execute");
        JButton eval2 = new JButton("Eval");
        try {
            this.manager.declareBean("frame", (Object)frame, JFrame.class);
            this.manager.declareBean("menubar", (Object)menubar, JMenuBar.class);
            this.manager.declareBean("input", (Object)input, JTextArea.class);
            this.manager.declareBean("execute", (Object)execute, JButton.class);
            this.manager.declareBean("eval", (Object)eval2, JButton.class);
        }
        catch (BSFException excptn) {
            excptn.printStackTrace();
            JOptionPane.showMessageDialog(null, excptn.getMessage());
        }
        frame.getContentPane().setLayout(new BorderLayout(12, 12));
        frame.getContentPane().add((Component)input, "Center");
        JPanel buttonPane = new JPanel(new FlowLayout(12));
        frame.getContentPane().add((Component)buttonPane, "South");
        buttonPane.add((Component)execute, "East");
        buttonPane.add((Component)eval2, "East");
        try {
            this.manager.exec("ruby", "initUI", 1, 1, (Object)"$frame.setJMenuBar($menubar)");
        }
        catch (BSFException excptn) {
            excptn.printStackTrace();
            JOptionPane.showMessageDialog(null, excptn.getMessage());
        }
        execute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    BSFExample.this.manager.exec("ruby", "initUI", 1, 1, (Object)input.getText());
                }
                catch (BSFException excptn) {
                    excptn.printStackTrace();
                    JOptionPane.showMessageDialog(frame, excptn.getMessage());
                }
            }
        });
        eval2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String expression = JOptionPane.showInputDialog(frame, (Object)"Please enter a Ruby expression:");
                    input.setText(String.valueOf(BSFExample.this.manager.eval("ruby", "initUI", 1, 1, (Object)expression)));
                }
                catch (BSFException excptn) {
                    excptn.printStackTrace();
                    JOptionPane.showMessageDialog(frame, excptn.getMessage());
                }
            }
        });
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }
}

