/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.diff;

import com.intellij.util.diff.FilesTooBigForDiffException;
import com.intellij.util.diff.MyersLCS;
import com.intellij.util.diff.UniqueLCS;
import java.util.BitSet;

class PatienceIntLCS {
    private final int[] myFirst;
    private final int[] mySecond;
    private final int myStart1;
    private final int myStart2;
    private final int myCount1;
    private final int myCount2;
    private final BitSet myChanges1;
    private final BitSet myChanges2;

    PatienceIntLCS(int[] first2, int[] second) {
        this(first2, second, 0, first2.length, 0, second.length, new BitSet(first2.length), new BitSet(second.length));
    }

    PatienceIntLCS(int[] first2, int[] second, int start1, int count1, int start2, int count2, BitSet changes1, BitSet changes2) {
        this.myFirst = first2;
        this.mySecond = second;
        this.myStart1 = start1;
        this.myStart2 = start2;
        this.myCount1 = count1;
        this.myCount2 = count2;
        this.myChanges1 = changes1;
        this.myChanges2 = changes2;
    }

    public void execute() throws FilesTooBigForDiffException {
        this.execute(false);
    }

    public void execute(boolean failOnSmallReduction) throws FilesTooBigForDiffException {
        int thresholdCheckCounter = failOnSmallReduction ? 2 : -1;
        this.execute(this.myStart1, this.myCount1, this.myStart2, this.myCount2, thresholdCheckCounter);
    }

    private void execute(int start1, int count1, int start2, int count2, int thresholdCheckCounter) throws FilesTooBigForDiffException {
        int startOffset;
        int endOffset;
        if (count1 == 0 && count2 == 0) {
            return;
        }
        if (count1 == 0 || count2 == 0) {
            this.addChange(start1, count1, start2, count2);
            return;
        }
        if ((count1 -= (endOffset = this.matchBackward(start1 += (startOffset = this.matchForward(start1, count1, start2, count2)), count1 -= startOffset, start2 += startOffset, count2 -= startOffset))) == 0 || (count2 -= endOffset) == 0) {
            this.addChange(start1, count1, start2, count2);
        } else {
            if (thresholdCheckCounter == 0) {
                this.checkReduction(count1, count2);
            }
            thresholdCheckCounter = Math.max(-1, thresholdCheckCounter - 1);
            UniqueLCS uniqueLCS = new UniqueLCS(this.myFirst, this.mySecond, start1, count1, start2, count2);
            int[][] matching2 = uniqueLCS.execute();
            if (matching2 == null) {
                if (thresholdCheckCounter >= 0) {
                    this.checkReduction(count1, count2);
                }
                MyersLCS intLCS = new MyersLCS(this.myFirst, this.mySecond, start1, count1, start2, count2, this.myChanges1, this.myChanges2);
                intLCS.executeLinear();
            } else {
                int s2;
                int s1;
                int matched = matching2[0].length;
                assert (matched > 0);
                int c1 = matching2[0][0];
                int c2 = matching2[1][0];
                this.execute(start1, c1, start2, c2, thresholdCheckCounter);
                for (int i = 1; i < matching2[0].length; ++i) {
                    s1 = matching2[0][i - 1] + 1;
                    s2 = matching2[1][i - 1] + 1;
                    c1 = matching2[0][i] - s1;
                    c2 = matching2[1][i] - s2;
                    if (c1 <= 0 && c2 <= 0) continue;
                    this.execute(start1 + s1, c1, start2 + s2, c2, thresholdCheckCounter);
                }
                if (matching2[0][matched - 1] == count1 - 1) {
                    s1 = count1 - 1;
                    c1 = 0;
                } else {
                    s1 = matching2[0][matched - 1] + 1;
                    c1 = count1 - s1;
                }
                if (matching2[1][matched - 1] == count2 - 1) {
                    s2 = count2 - 1;
                    c2 = 0;
                } else {
                    s2 = matching2[1][matched - 1] + 1;
                    c2 = count2 - s2;
                }
                this.execute(start1 + s1, c1, start2 + s2, c2, thresholdCheckCounter);
            }
        }
    }

    private int matchForward(int start1, int count1, int start2, int count2) {
        int size = Math.min(count1, count2);
        int idx = 0;
        for (int i = 0; i < size && this.myFirst[start1 + i] == this.mySecond[start2 + i]; ++i) {
            ++idx;
        }
        return idx;
    }

    private int matchBackward(int start1, int count1, int start2, int count2) {
        int size = Math.min(count1, count2);
        int idx = 0;
        for (int i = 1; i <= size && this.myFirst[start1 + count1 - i] == this.mySecond[start2 + count2 - i]; ++i) {
            ++idx;
        }
        return idx;
    }

    private void addChange(int start1, int count1, int start2, int count2) {
        this.myChanges1.set(start1, start1 + count1);
        this.myChanges2.set(start2, start2 + count2);
    }

    public BitSet[] getChanges() {
        return new BitSet[]{this.myChanges1, this.myChanges2};
    }

    private void checkReduction(int count1, int count2) throws FilesTooBigForDiffException {
        if (count1 * 2 < this.myCount1) {
            return;
        }
        if (count2 * 2 < this.myCount2) {
            return;
        }
        throw new FilesTooBigForDiffException();
    }
}

