/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.range.forLoop;

import java.util.Collection;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.range.RangeCodegenUtilKt;
import org.jetbrains.kotlin.codegen.range.comparison.ComparisonGenerator;
import org.jetbrains.kotlin.codegen.range.comparison.ComparisonGeneratorKt;
import org.jetbrains.kotlin.codegen.range.comparison.SignedIntegerComparisonGenerator;
import org.jetbrains.kotlin.codegen.range.forLoop.AbstractForInProgressionOrRangeLoopGenerator;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001d\u001a\u00020\u001eH\u0014J\b\u0010\u001f\u001a\u00020\u001eH\u0016J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"H\u0014J\b\u0010$\u001a\u00020\u001eH$R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR\u001a\u0010\u0013\u001a\u00020\u0014X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/codegen/range/forLoop/AbstractForInProgressionLoopGenerator;", "Lorg/jetbrains/kotlin/codegen/range/forLoop/AbstractForInProgressionOrRangeLoopGenerator;", "codegen", "Lorg/jetbrains/kotlin/codegen/ExpressionCodegen;", "forExpression", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "(Lorg/jetbrains/kotlin/codegen/ExpressionCodegen;Lorg/jetbrains/kotlin/psi/KtForExpression;)V", "asmLoopRangeType", "Lorg/jetbrains/org/objectweb/asm/Type;", "getAsmLoopRangeType", "()Lorg/jetbrains/org/objectweb/asm/Type;", "elementComparisonGenerator", "Lorg/jetbrains/kotlin/codegen/range/comparison/ComparisonGenerator;", "incrementComparisonGenerator", "Lorg/jetbrains/kotlin/codegen/range/comparison/SignedIntegerComparisonGenerator;", "incrementKotlinType", "Lorg/jetbrains/kotlin/types/KotlinType;", "incrementType", "getIncrementType", "incrementVar", "", "getIncrementVar", "()I", "setIncrementVar", "(I)V", "rangeElementKotlinType", "rangeKotlinType", "getRangeKotlinType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "assignToLoopParameter", "", "beforeLoop", "checkEmptyLoop", "loopExit", "Lorg/jetbrains/org/objectweb/asm/Label;", "checkPostConditionAndIncrement", "storeProgressionParametersToLocalVars", "backend"})
public abstract class AbstractForInProgressionLoopGenerator
extends AbstractForInProgressionOrRangeLoopGenerator {
    private int incrementVar;
    @NotNull
    private final Type asmLoopRangeType;
    @NotNull
    private final KotlinType rangeKotlinType;
    private final KotlinType rangeElementKotlinType;
    private final KotlinType incrementKotlinType;
    @NotNull
    private final Type incrementType;
    private final SignedIntegerComparisonGenerator incrementComparisonGenerator;
    private final ComparisonGenerator elementComparisonGenerator;

    protected final int getIncrementVar() {
        return this.incrementVar;
    }

    protected final void setIncrementVar(int n) {
        this.incrementVar = n;
    }

    @NotNull
    protected final Type getAsmLoopRangeType() {
        return this.asmLoopRangeType;
    }

    @NotNull
    protected final KotlinType getRangeKotlinType() {
        return this.rangeKotlinType;
    }

    @NotNull
    protected final Type getIncrementType() {
        return this.incrementType;
    }

    @Override
    public void beforeLoop() {
        super.beforeLoop();
        this.incrementVar = this.createLoopTempVariable(this.getAsmElementType());
        this.storeProgressionParametersToLocalVars();
    }

    protected abstract void storeProgressionParametersToLocalVars();

    @Override
    public void checkEmptyLoop(@NotNull Label loopExit) {
        Intrinsics.checkParameterIsNotNull(loopExit, "loopExit");
        this.loopParameter().put(this.getAsmElementType(), this.getElementType(), this.getV());
        this.getV().load(this.getEndVar(), this.getAsmElementType());
        this.getV().load(this.incrementVar, this.incrementType);
        Label negativeIncrement = new Label();
        Label afterIf = new Label();
        this.incrementComparisonGenerator.jumpIfLessThanZero(this.getV(), negativeIncrement);
        this.elementComparisonGenerator.jumpIfGreater(this.getV(), loopExit);
        this.getV().goTo(afterIf);
        this.getV().mark(negativeIncrement);
        this.elementComparisonGenerator.jumpIfLess(this.getV(), loopExit);
        this.getV().mark(afterIf);
    }

    @Override
    protected void assignToLoopParameter() {
    }

    @Override
    protected void checkPostConditionAndIncrement(@NotNull Label loopExit) {
        Intrinsics.checkParameterIsNotNull(loopExit, "loopExit");
        this.checkPostCondition(loopExit);
        StackValue loopParameter = this.loopParameter();
        loopParameter.put(this.getAsmElementType(), this.getElementType(), this.getV());
        this.getV().load(this.incrementVar, this.getAsmElementType());
        this.getV().add(this.getAsmElementType());
        if (this.getAsmElementType() == Type.BYTE_TYPE || this.getAsmElementType() == Type.SHORT_TYPE || this.getAsmElementType() == Type.CHAR_TYPE) {
            StackValue.coerce(Type.INT_TYPE, this.getAsmElementType(), this.getV());
        }
        loopParameter.store(StackValue.onStack(this.getAsmElementType(), this.getElementType()), this.getV());
    }

    public AbstractForInProgressionLoopGenerator(@NotNull ExpressionCodegen codegen2, @NotNull KtForExpression forExpression) {
        Intrinsics.checkParameterIsNotNull(codegen2, "codegen");
        Intrinsics.checkParameterIsNotNull(forExpression, "forExpression");
        super(codegen2, forExpression);
        this.incrementVar = -1;
        BindingContext bindingContext = this.getBindingContext();
        KtExpression ktExpression = forExpression.getLoopRange();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        KotlinType kotlinType = bindingContext.getType(ktExpression);
        if (kotlinType == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "bindingContext.getType(f\u2026Expression.loopRange!!)!!");
        this.rangeKotlinType = kotlinType;
        KotlinType kotlinType2 = RangeCodegenUtilKt.getRangeOrProgressionElementType(this.rangeKotlinType);
        if (kotlinType2 == null) {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected loop range type: " + this.rangeKotlinType)));
        }
        this.rangeElementKotlinType = kotlinType2;
        Type type2 = codegen2.asmType(this.rangeKotlinType);
        Intrinsics.checkExpressionValueIsNotNull(type2, "codegen.asmType(rangeKotlinType)");
        this.asmLoopRangeType = type2;
        MemberScope memberScope2 = this.rangeKotlinType.getMemberScope();
        Name name = Name.identifier("step");
        Intrinsics.checkExpressionValueIsNotNull(name, "Name.identifier(\"step\")");
        Collection<? extends PropertyDescriptor> incrementProp = memberScope2.getContributedVariables(name, NoLookupLocation.FROM_BACKEND);
        boolean bl = incrementProp.size() == 1;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = this.rangeKotlinType.toString() + " " + incrementProp.size();
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        KotlinType kotlinType3 = ((PropertyDescriptor)CollectionsKt.single((Iterable)incrementProp)).getType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType3, "incrementProp.single().type");
        this.incrementKotlinType = kotlinType3;
        Type type3 = codegen2.asmType(this.incrementKotlinType);
        Intrinsics.checkExpressionValueIsNotNull(type3, "codegen.asmType(incrementKotlinType)");
        this.incrementType = type3;
        ComparisonGenerator comparisonGenerator = ComparisonGeneratorKt.getComparisonGeneratorForKotlinType(this.incrementKotlinType);
        if (!(comparisonGenerator instanceof SignedIntegerComparisonGenerator)) {
            comparisonGenerator = null;
        }
        SignedIntegerComparisonGenerator signedIntegerComparisonGenerator = (SignedIntegerComparisonGenerator)comparisonGenerator;
        if (signedIntegerComparisonGenerator == null) {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected increment type: " + this.incrementKotlinType)));
        }
        this.incrementComparisonGenerator = signedIntegerComparisonGenerator;
        this.elementComparisonGenerator = ComparisonGeneratorKt.getComparisonGeneratorForKotlinType(this.rangeElementKotlinType);
    }
}

